/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.AutoValueLink;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.ItemImporter;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.KeyTest;
import com.ef_prime.rflow.core.common.keyvalue.KeyWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.TitleLink;
import com.ef_prime.rflow.core.common.keyvalue.ValidationContext;
import com.ef_prime.rflow.core.common.keyvalue.Validator;
import com.ef_prime.rflow.core.common.keyvalue.ValueErrors;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.feature.search.KeySearchResult;
import com.ef_prime.rflow.core.feature.search.ListSearchResult;
import com.ef_prime.rflow.core.feature.search.SearchContext;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.node.ui.PreviewFunction;
import com.ef_prime.rflow.resource.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Key<V>
implements Validator {
    protected String id;
    protected String title;
    protected V defaultValue;
    protected String subTitle;
    protected boolean hidden = false;
    protected boolean editable = true;
    protected boolean frequentUpdate = false;
    protected boolean fillDefaultOnFocus = false;
    protected boolean growY = false;
    protected boolean growX = false;
    protected boolean quietUpdate;
    private boolean required;
    private boolean dynamicDefault;
    private boolean noSave;
    private boolean obsolete;
    private boolean noRegister;
    protected int height = -1;
    protected int minWidth = -1;
    protected int width = -1;
    protected String labelPosition = null;
    protected String icon;
    protected List<KeyLink> keyLinks;
    private AutoValueLink autoValueLink;
    private TitleLink titleLink;
    protected List<ItemImporter> importers;
    private PreviewFunction<V> previewFunction;
    private Function<ValueMap, Boolean> enabledFunction;

    public static final String toDefault(String string) {
        return string;
    }

    public static final String getDefaultPrefix() {
        return Messages.getString("Widget.default") + ": ";
    }

    protected static <V> V yamlValue(V v, Class<V> clazz, String string, Map<?, ?> map) {
        Object obj = map.get(string);
        if (obj == null) {
            return v;
        }
        return (V)YamlEx.typeCheck(clazz, obj);
    }

    protected static <V> V yamlObject(Class<V> clazz, String string, Map<?, ?> map) {
        return (V)YamlEx.typeCheck(clazz, map.get(string));
    }

    public Key(String string, V v) {
        this(string, string, v);
    }

    public Key(String string, String string2, V v) {
        this.id = string;
        this.title = string2;
        this.defaultValue = v;
    }

    public Key(Map<?, ?> map) {
        this.id = Key.yamlValue(this.id, String.class, "id", map);
        this.title = Key.yamlValue(this.title, String.class, "title", map);
        this.defaultValue = Utility.cast(map.get("default"));
        this.subTitle = Key.yamlValue(this.subTitle, String.class, "subTitle", map);
        this.height = Key.yamlValue(this.height, Integer.class, "height", map);
        this.minWidth = Key.yamlValue(this.minWidth, Integer.class, "minWidth", map);
        this.width = Key.yamlValue(this.width, Integer.class, "width", map);
        this.labelPosition = Key.yamlValue(this.labelPosition, String.class, "labelPosition", map);
        this.icon = Key.yamlValue(this.icon, String.class, "icon", map);
        this.hidden = Key.yamlValue(this.hidden, Boolean.class, "hidden", map);
        this.editable = Key.yamlValue(this.editable, Boolean.class, "editable", map);
        this.frequentUpdate = Key.yamlValue(this.frequentUpdate, Boolean.class, "frequentUpdate", map);
        this.fillDefaultOnFocus = Key.yamlValue(this.fillDefaultOnFocus, Boolean.class, "fillDefaultOnFocus", map);
        this.growY = Key.yamlValue(this.growY, Boolean.class, "growY", map);
        this.growX = Key.yamlValue(this.growX, Boolean.class, "growX", map);
        this.quietUpdate = Key.yamlValue(this.quietUpdate, Boolean.class, "quietUpdate", map);
        this.required = Key.yamlValue(this.required, Boolean.class, "required", map);
        this.dynamicDefault = Key.yamlValue(this.dynamicDefault, Boolean.class, "dynamic-default", map);
        this.noSave = Key.yamlValue(this.noSave, Boolean.class, "noSave", map);
        this.obsolete = Key.yamlValue(this.obsolete, Boolean.class, "obsolete", map);
    }

    protected Key(Builder<V, ?> builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.defaultValue = Utility.cast(builder.getDefaultValue());
        this.subTitle = builder.subTitle;
        this.hidden = builder.hidden;
        this.editable = builder.editable;
        this.keyLinks = builder.links;
        this.height = builder.height;
        this.minWidth = builder.minWidth;
        this.width = builder.width;
        this.frequentUpdate = builder.frequentUpdate;
        this.fillDefaultOnFocus = builder.fillDefaultOnFocus;
        this.labelPosition = builder.labelPosition;
        this.growY = builder.growY;
        this.growX = builder.growX;
        this.icon = builder.icon;
        this.quietUpdate = builder.quietUpdate;
        this.required = builder.required;
        this.dynamicDefault = builder.dynamicDefault;
        this.autoValueLink = builder.autoValueLink;
        this.titleLink = builder.titleLink;
        this.noSave = builder.noSave;
        this.obsolete = builder.obsolete;
        this.noRegister = builder.noRegister;
        this.previewFunction = builder.previewFunction;
        this.enabledFunction = builder.enabledFunction;
    }

    public abstract String valueToString(Object var1);

    public abstract Object stringToValue(String var1);

    public abstract V copyValue(V var1);

    public abstract void valueToElement(Document var1, Element var2, Object var3);

    public abstract Object elementToValue(Element var1);

    public abstract boolean isAtomic();

    public abstract Class<?> getJavaClass();

    protected void addImporter(ItemImporter itemImporter) {
        if (this.importers == null) {
            this.importers = new ArrayList<ItemImporter>();
        }
        this.importers.add(itemImporter);
    }

    public Object valueToYamlValue(YamlEx yamlEx, Object object, boolean bl) {
        return object;
    }

    public Object yamlValueToValue(YamlEx yamlEx, Object object) throws Exception {
        return object;
    }

    public Object toYaml() {
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
        this.toYaml(linkedHashMap);
        return linkedHashMap;
    }

    protected String getYamlType() {
        return "";
    }

    protected void toYaml(Map<Object, Object> map) {
        map.put("type", this.getYamlType());
        if (this.title != null) {
            map.put("title", this.title);
        }
        if (this.height >= 0) {
            map.put("height", this.height);
        }
        if (this.minWidth >= 0) {
            map.put("minWidth", this.minWidth);
        }
        if (this.width >= 0) {
            map.put("width", this.width);
        }
        if (this.subTitle != null) {
            map.put("subTitle", this.subTitle);
        }
        if (this.labelPosition != null) {
            map.put("labelPosition", this.labelPosition);
        }
        if (this.icon != null) {
            map.put("icon", this.icon);
        }
        if (!this.editable) {
            map.put("editable", this.editable);
        }
        if (this.hidden) {
            map.put("hidden", this.hidden);
        }
        if (this.frequentUpdate) {
            map.put("frequentUpdate", this.frequentUpdate);
        }
        if (this.fillDefaultOnFocus) {
            map.put("fillDefaultOnFocus", this.fillDefaultOnFocus);
        }
        if (this.growY) {
            map.put("growY", this.growY);
        }
        if (this.growX) {
            map.put("growX", this.growX);
        }
        if (this.quietUpdate) {
            map.put("quietUpdate", this.quietUpdate);
        }
        if (this.required) {
            map.put("required", this.required);
        }
        if (this.dynamicDefault) {
            map.put("dynamic-default", this.dynamicDefault);
        }
        if (this.noSave) {
            map.put("noSave", this.noSave);
        }
        if (this.obsolete) {
            map.put("obsolete", this.obsolete);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        if (this.title == null) {
            return this.id;
        }
        return this.title;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public V getDefaultValue() {
        return this.copyValue(this.defaultValue);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isGrowY() {
        return this.growY;
    }

    public boolean isGrowX() {
        return this.growX;
    }

    public boolean isFrequentUpdate() {
        return this.frequentUpdate;
    }

    public boolean isFillDefaultOnFocus() {
        return this.fillDefaultOnFocus;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isKeyLink() {
        return this.keyLinks != null && !this.keyLinks.isEmpty();
    }

    public List<KeyLink> getKeyLinks() {
        return this.keyLinks;
    }

    public AutoValueLink getAutoValueLink() {
        return this.autoValueLink;
    }

    public boolean isAutoValueLink() {
        return this.autoValueLink != null;
    }

    public BoolKey getAutoValueLinkKey() {
        if (this.autoValueLink == null) {
            return null;
        }
        return this.autoValueLink.getSaveKey(this);
    }

    public TitleLink getTitleLink() {
        return this.titleLink;
    }

    public boolean isImporter() {
        return this.importers != null && !this.importers.isEmpty();
    }

    public List<ItemImporter> getImporters() {
        return this.importers;
    }

    public PreviewFunction<V> getPreviewFunction() {
        return this.previewFunction;
    }

    public Function<ValueMap, Boolean> getEnabledFunction() {
        return this.enabledFunction;
    }

    public String getLabelPosition() {
        if (this.labelPosition == null) {
            return "left";
        }
        return this.labelPosition;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isQuietUpdate() {
        return this.quietUpdate;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isDynamicDefault() {
        return this.dynamicDefault;
    }

    public boolean isNoSave() {
        return this.noSave || this.obsolete;
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public boolean isNoRegister() {
        return this.noRegister;
    }

    public boolean isSearchable() {
        return false;
    }

    public void search(List<SearchResult> list, SearchContext searchContext, Object object, ValueMap valueMap) {
    }

    public boolean replace(SearchContext searchContext, String string, SearchResult searchResult, List<SearchResult> list, Object object, ValueMap valueMap) {
        return false;
    }

    public boolean validateSearchResult(SearchContext searchContext, SearchResult searchResult, Object object) {
        return true;
    }

    protected void searchValueMapList(Iterator<ValueMap> iterator, List<SearchResult> list, SearchContext searchContext) {
        ViewOptions viewOptions = ViewOptions.builder().setWizard(false).setTab(true).build();
        ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
        int n = 0;
        while (iterator.hasNext()) {
            ValueMap valueMap = iterator.next();
            WidgetNode widgetNode = valueMap.getWidgetNode(viewOptions);
            Iterator<WidgetNode> iterator2 = widgetNode.treeIterator();
            while (iterator2.hasNext()) {
                Key<?> key;
                WidgetNode widgetNode2 = iterator2.next();
                if (!(widgetNode2 instanceof KeyWidgetNode) || !valueMap.isSearchable(key = ((KeyWidgetNode)widgetNode2).getKey())) continue;
                arrayList.clear();
                key.search(arrayList, searchContext, valueMap.getValue(key), valueMap);
                for (SearchResult searchResult : arrayList) {
                    list.add(new KeySearchResult(this, new ListSearchResult(n, searchResult)));
                }
            }
            ++n;
        }
    }

    protected boolean replaceValueMapList(SearchContext searchContext, String string, SearchResult searchResult, List<SearchResult> list, Function<Integer, ValueMap> function) {
        if (!(searchResult instanceof ListSearchResult)) {
            return false;
        }
        ListSearchResult listSearchResult = (ListSearchResult)searchResult;
        ValueMap valueMap = function.apply(listSearchResult.getIndex());
        if (valueMap == null) {
            return false;
        }
        if (!(listSearchResult.getResult() instanceof KeySearchResult)) {
            return false;
        }
        KeySearchResult keySearchResult = (KeySearchResult)listSearchResult.getResult();
        ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
        for (SearchResult searchResult2 : list) {
            if (!(searchResult2 instanceof ListSearchResult)) continue;
            ListSearchResult listSearchResult2 = (ListSearchResult)searchResult2;
            if (listSearchResult.getIndex() != listSearchResult2.getIndex() || !(listSearchResult2.getResult() instanceof KeySearchResult)) continue;
            KeySearchResult keySearchResult2 = (KeySearchResult)listSearchResult2.getResult();
            if (!keySearchResult.getKey().equals(keySearchResult2.getKey())) continue;
            arrayList.add(keySearchResult2.getResult());
        }
        return keySearchResult.getKey().replace(searchContext, string, keySearchResult.getResult(), arrayList, valueMap.getValue(keySearchResult.getKey()), valueMap);
    }

    public boolean supportXmlEncoding() {
        return true;
    }

    public Class<?> getBaseClass() {
        return null;
    }

    public void localize(Map<String, String> map) {
        this.title = Key.valueOrDefault(map, this.title);
    }

    public void localizationValues(List<String> list) {
        list.add(this.title);
    }

    protected static String valueOrDefault(Map<String, String> map, String string) {
        String string2 = map.get(string);
        return string2 == null ? string : string2;
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Key) {
            return this.id.equals(((Key)object).getId());
        }
        if (object instanceof String) {
            return this.id.equals((String)object);
        }
        return false;
    }

    public boolean isValueEmpty(V v) {
        return false;
    }

    @Override
    public void validate(Key<?> key, Object object, ValidationContext validationContext) {
        this.validate(object, validationContext);
    }

    protected void validate(V v, ValidationContext validationContext) {
        if (this.isRequired() && (v == null || this.isValueEmpty(v))) {
            validationContext.addError(this, ValueErrors.required(this));
        }
    }

    public static abstract class Builder<V, T extends Builder<V, T>> {
        protected String id;
        private String title;
        private Object defaultValue;
        private String subTitle;
        private boolean hidden = false;
        private boolean editable = true;
        private List<KeyLink> links;
        private int height = -1;
        private int minWidth = -1;
        private int width = -1;
        private boolean frequentUpdate;
        private boolean fillDefaultOnFocus;
        private String labelPosition;
        private boolean growY;
        private boolean growX;
        private String icon;
        private boolean quietUpdate;
        private boolean required = false;
        private boolean dynamicDefault;
        private AutoValueLink autoValueLink;
        private TitleLink titleLink;
        private boolean noSave;
        private boolean obsolete;
        private boolean noRegister;
        private PreviewFunction<V> previewFunction;
        private Function<ValueMap, Boolean> enabledFunction;

        public Builder(String string, String string2) {
            this.id = string;
            this.title = string2;
        }

        protected abstract T self();

        public T setTitle(String string) {
            this.title = string;
            return this.self();
        }

        public T setDefaultValue(Object object) {
            this.defaultValue = object;
            return this.self();
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        protected boolean isDefaultValue() {
            return this.defaultValue != null;
        }

        public T setSubTitle(String string) {
            this.subTitle = string;
            return this.self();
        }

        public T setHidden(boolean bl) {
            this.hidden = bl;
            return this.self();
        }

        public final T setEditable(boolean bl) {
            this.editable = bl;
            return this.self();
        }

        public T addVisibleKeyLink(StrKey strKey, String ... stringArray) {
            return this.addKeyLink(KeyLink.visible(StrKeyTest.create(strKey, stringArray)));
        }

        public T addVisibleKeyLink(BoolKey boolKey, boolean bl) {
            return this.addKeyLink(KeyLink.visible(BoolKeyTest.create(boolKey, bl)));
        }

        public T addInvisibleKeyLink(StrKey strKey, String ... stringArray) {
            return this.addKeyLink(KeyLink.invisible(StrKeyTest.create(strKey, stringArray)));
        }

        public T addInvisibleKeyLink(BoolKey boolKey, boolean bl) {
            return this.addKeyLink(KeyLink.invisible(BoolKeyTest.create(boolKey, bl)));
        }

        public T addEnabledKeyLink(StrKey strKey, String ... stringArray) {
            return this.addKeyLink(KeyLink.enabled(StrKeyTest.create(strKey, stringArray)));
        }

        public T addEnabledKeyLink(BoolKey boolKey, boolean bl) {
            return this.addKeyLink(KeyLink.enabled(BoolKeyTest.create(boolKey, bl)));
        }

        public T addKeyLink(KeyLink keyLink) {
            if (this.links == null) {
                this.links = new ArrayList<KeyLink>();
            }
            this.links.add(keyLink);
            return this.self();
        }

        public T addKeyLinks(List<KeyLink> list) {
            if (list != null) {
                for (KeyLink keyLink : list) {
                    this.addKeyLink(keyLink);
                }
            }
            return this.self();
        }

        public T disabled() {
            return this.addKeyLink(KeyLink.disabled(KeyTest.ALWAYS_TRUE));
        }

        public T setHeight(int n) {
            this.height = n;
            return this.self();
        }

        public T setMinWidth(int n) {
            this.minWidth = n;
            return this.self();
        }

        public T setWidth(int n) {
            this.width = n;
            return this.self();
        }

        public T setFrequentUpdate(boolean bl) {
            this.frequentUpdate = bl;
            return this.self();
        }

        public T setFillDefaultOnFocus(boolean bl) {
            this.fillDefaultOnFocus = bl;
            return this.self();
        }

        public T setLabelPosition(String string) {
            this.labelPosition = string;
            return this.self();
        }

        public T noLabel() {
            return this.setLabelPosition("none");
        }

        public T setGrowY(boolean bl) {
            this.growY = bl;
            return this.self();
        }

        public T setGrowX(boolean bl) {
            this.growX = bl;
            return this.self();
        }

        public T setIcon(String string) {
            this.icon = string;
            return this.self();
        }

        public T setQuietUpdate(boolean bl) {
            this.quietUpdate = bl;
            return this.self();
        }

        public T setRequired(boolean bl) {
            this.required = bl;
            return this.self();
        }

        public T setDynamicDefault(boolean bl) {
            this.dynamicDefault = bl;
            return this.self();
        }

        public T setAutoValueLink(AutoValueLink autoValueLink) {
            this.autoValueLink = autoValueLink;
            return this.self();
        }

        public T setAutoValueLink(Key<?> ... keyArray) {
            return this.setAutoValueLink(false, keyArray);
        }

        public T setAutoValueLink(String ... stringArray) {
            this.autoValueLink = new AutoValueLink(false, stringArray);
            return this.self();
        }

        public T setAutoValueLink(boolean bl, Key<?> ... keyArray) {
            this.autoValueLink = new AutoValueLink(bl, keyArray);
            return this.self();
        }

        public T setTitleLink(TitleLink titleLink) {
            this.titleLink = titleLink;
            return this.self();
        }

        public T setNoSave(boolean bl) {
            this.noSave = bl;
            return this.self();
        }

        public T setObsolete(boolean bl) {
            this.obsolete = bl;
            return this.self();
        }

        public T setNoRegister(boolean bl) {
            this.noRegister = bl;
            return this.self();
        }

        public T setPreviewFunction(PreviewFunction<V> previewFunction) {
            this.previewFunction = previewFunction;
            return this.self();
        }

        public T setEnabledFunction(Function<ValueMap, Boolean> function) {
            this.enabledFunction = function;
            return this.self();
        }
    }
}

