/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.NonAtomicKey;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.util.YamlEx;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ListKey<V>
extends NonAtomicKey<List<V>> {
    private Key<V> innerKey;

    public ListKey(String string, String string2, Key<V> key) {
        this(string, string2, key, new ArrayList());
    }

    public ListKey(String string, String string2, Key<V> key, ArrayList<V> arrayList) {
        super(string, string2, arrayList);
        this.innerKey = key;
    }

    protected ListKey(Builder<V, ?> builder) {
        super(builder);
        this.innerKey = builder.innerKey;
    }

    public static <V> Builder<V, ?> builder(String string, String string2, Key<V> key) {
        return new Builder2<V>(string, string2, key);
    }

    @Override
    public void valueToElement(Document document, Element element, Object object) {
        ArrayList arrayList = (ArrayList)object;
        for (Object e : arrayList) {
            Element element2 = document.createElement("v");
            this.innerKey.valueToElement(document, element2, e);
            element.appendChild(element2);
        }
    }

    @Override
    public Object elementToValue(Element element) {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Object> arrayList = new ArrayList<Object>(nodeList.getLength());
        for (Element element2 : XmlUtility.elements(element)) {
            arrayList.add(this.innerKey.elementToValue(element2));
        }
        return arrayList;
    }

    @Override
    public Object stringToValue(String string) {
        String[] stringArray = string.split("(^:|(\\\\\\\\)*:)");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String string2 : stringArray) {
            string2 = ListKey.unescapeChar(string2, ":");
            arrayList.add(this.innerKey.stringToValue(string2));
        }
        return arrayList;
    }

    @Override
    public String valueToString(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((List)object).iterator();
        while (iterator.hasNext()) {
            String string = this.innerKey.valueToString(iterator.next());
            stringBuffer.append(ListKey.escapeChar(string, ":"));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    @Override
    public List<V> copyValue(List<V> list) {
        ArrayList<V> arrayList = new ArrayList<V>(list.size());
        for (V v : list) {
            arrayList.add(this.innerKey.copyValue(v));
        }
        return arrayList;
    }

    @Override
    public Class<?> getJavaClass() {
        return List.class;
    }

    public static String escapeChar(String string, String string2) {
        return string.replaceAll("\\", "\\\\").replaceAll(string2, "\\" + string2);
    }

    public static String unescapeChar(String string, String string2) {
        return string.replaceAll("\\\\", "\\").replaceAll("\\" + string2, string2);
    }

    @Override
    public Object valueToYamlValue(YamlEx yamlEx, Object object, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = (List)Utility.cast(object);
        for (Object e : list) {
            arrayList.add(this.innerKey.valueToYamlValue(yamlEx, e, false));
        }
        return arrayList;
    }

    @Override
    public Object yamlValueToValue(YamlEx yamlEx, Object object) throws Exception {
        List list = (List)YamlEx.typeCheck(List.class, object);
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (Object e : list) {
            arrayList.add(this.innerKey.yamlValueToValue(yamlEx, e));
        }
        return arrayList;
    }

    public static abstract class Builder<V, T extends Builder<V, T>>
    extends Key.Builder<List<V>, T> {
        private Key<V> innerKey;

        public Builder(String string, String string2, Key<V> key) {
            super(string, string2);
            this.setDefaultValue(new ArrayList(4));
            this.innerKey = key;
        }

        @Override
        protected abstract T self();

        public ListKey<V> build() {
            return new ListKey(this);
        }
    }

    private static class Builder2<V>
    extends Builder<V, Builder2<V>> {
        public Builder2(String string, String string2, Key<V> key) {
            super(string, string2, key);
        }

        @Override
        protected Builder2<V> self() {
            return this;
        }
    }
}

