/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.NonAtomicKey;
import com.ef_prime.rflow.core.common.list.BasicListModel;
import com.ef_prime.rflow.core.common.list.ListModel;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.util.YamlEx;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ListModelKey<V>
extends NonAtomicKey<ListModel<V>> {
    private Key<V> columnKey;

    protected ListModelKey(Builder<V, ?> builder) {
        super(builder);
        this.columnKey = builder.columnKey;
    }

    public static <V> Builder<V, ?> builder(String string, String string2, Key<V> key) {
        return new Builder2<V>(string, string2, key);
    }

    public Key<V> getColumnKey() {
        return this.columnKey;
    }

    public List<V> validElements(ListModel<V> listModel) {
        ArrayList arrayList = new ArrayList(listModel.size());
        for (Object e : listModel) {
            if (this.columnKey.isValueEmpty(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    @Override
    public void valueToElement(Document document, Element element, Object object) {
        List list = (List)object;
        for (Object e : list) {
            Element element2 = document.createElement("v");
            this.columnKey.valueToElement(document, element2, e);
            element.appendChild(element2);
        }
    }

    @Override
    public Object elementToValue(Element element) {
        NodeList nodeList = element.getChildNodes();
        BasicListModel basicListModel = new BasicListModel(nodeList.getLength());
        for (Element element2 : XmlUtility.elements(element)) {
            basicListModel.add(this.columnKey.elementToValue(element2));
        }
        return basicListModel;
    }

    @Override
    public Object valueToYamlValue(YamlEx yamlEx, Object object, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = (List)object;
        for (Object e : list) {
            arrayList.add(this.columnKey.valueToYamlValue(yamlEx, e, false));
        }
        return arrayList;
    }

    @Override
    public Object yamlValueToValue(YamlEx yamlEx, Object object) throws Exception {
        List list = (List)YamlEx.typeCheck(List.class, object);
        BasicListModel basicListModel = new BasicListModel(list.size());
        for (Object e : list) {
            basicListModel.add(this.columnKey.yamlValueToValue(yamlEx, e));
        }
        return basicListModel;
    }

    @Override
    public Class<?> getJavaClass() {
        return ListModel.class;
    }

    @Override
    public ListModel<V> copyValue(ListModel<V> listModel) {
        BasicListModel basicListModel = new BasicListModel(listModel.size());
        for (Object e : listModel) {
            basicListModel.add(this.columnKey.copyValue(e));
        }
        return basicListModel;
    }

    public static abstract class Builder<V, T extends Builder<V, T>>
    extends Key.Builder<ListModel<V>, T> {
        private Key<V> columnKey;

        public Builder(String string, String string2, Key<V> key) {
            super(string, string2);
            this.columnKey = key;
        }

        protected ListModel<?> buildModel() {
            return new BasicListModel();
        }

        @Override
        public Object getDefaultValue() {
            if (!this.isDefaultValue()) {
                return this.buildModel();
            }
            return super.getDefaultValue();
        }

        public ListModelKey<V> build() {
            if (!this.isDefaultValue()) {
                this.setDefaultValue(this.buildModel());
            }
            return new ListModelKey(this);
        }

        @Override
        protected abstract T self();
    }

    private static class Builder2<V>
    extends Builder<V, Builder2<V>> {
        public Builder2(String string, String string2, Key<V> key) {
            super(string, string2, key);
        }

        @Override
        protected Builder2<V> self() {
            return this;
        }
    }
}

