/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.NonAtomicKey;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.util.YamlEx;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MapKey<V>
extends NonAtomicKey<Map<String, V>> {
    private Key<V> innerKey;

    protected MapKey(Builder<V, ?> builder) {
        super(builder);
        this.innerKey = builder.innerKey;
    }

    public static <V> Builder<V, ?> builder(String string, String string2, Key<V> key) {
        return new Builder2<V>(string, string2, key);
    }

    @Override
    public Map<String, V> copyValue(Map<String, V> map) {
        LinkedHashMap<String, V> linkedHashMap = new LinkedHashMap<String, V>(map.size());
        for (Map.Entry<String, V> entry : map.entrySet()) {
            linkedHashMap.put(entry.getKey(), this.innerKey.copyValue(entry.getValue()));
        }
        return linkedHashMap;
    }

    @Override
    public void valueToElement(Document document, Element element, Object object) {
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            Element element2 = document.createElement("v");
            element2.setAttribute("key", entry.getKey().toString());
            this.innerKey.valueToElement(document, element2, entry.getValue());
            element.appendChild(element2);
        }
    }

    @Override
    public Object elementToValue(Element element) {
        NodeList nodeList = element.getChildNodes();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(nodeList.getLength());
        for (Element element2 : XmlUtility.elements(element)) {
            String string = element2.getAttribute("key");
            if (string == null || string.isEmpty()) continue;
            linkedHashMap.put(string, this.innerKey.elementToValue(element2));
        }
        return linkedHashMap;
    }

    @Override
    public Object valueToYamlValue(YamlEx yamlEx, Object object, boolean bl) {
        Map map = (Map)object;
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            linkedHashMap.put(entry.getKey().toString(), this.innerKey.valueToYamlValue(yamlEx, entry.getValue(), bl));
        }
        return linkedHashMap;
    }

    @Override
    public Object yamlValueToValue(YamlEx yamlEx, Object object) throws Exception {
        Map map = (Map)YamlEx.typeCheck(Map.class, object);
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            linkedHashMap.put(entry.getKey().toString(), this.innerKey.yamlValueToValue(yamlEx, entry.getValue()));
        }
        return linkedHashMap;
    }

    @Override
    public Class<?> getJavaClass() {
        return Map.class;
    }

    public static abstract class Builder<V, T extends Builder<V, T>>
    extends Key.Builder<Map<String, V>, T> {
        private Key<V> innerKey;

        public Builder(String string, String string2, Key<V> key) {
            super(string, string2);
            this.setDefaultValue(new LinkedHashMap(4));
            this.innerKey = key;
        }

        @Override
        protected abstract T self();

        public MapKey<V> build() {
            return new MapKey(this);
        }
    }

    private static class Builder2<V>
    extends Builder<V, Builder2<V>> {
        public Builder2(String string, String string2, Key<V> key) {
            super(string, string2, key);
        }

        @Override
        protected Builder2<V> self() {
            return this;
        }
    }
}

