/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.AtomicKey;
import com.ef_prime.rflow.core.common.keyvalue.BasicDescriptionLink;
import com.ef_prime.rflow.core.common.keyvalue.ConstantDescriptionLink;
import com.ef_prime.rflow.core.common.keyvalue.DescriptionLink;
import com.ef_prime.rflow.core.common.keyvalue.DescriptionProvider;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.feature.search.KeySearchResult;
import com.ef_prime.rflow.core.feature.search.SearchContext;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.SearchUtility;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class StrKey
extends AtomicKey<String> {
    private boolean multiLine;
    private boolean defaultMessage;
    private boolean lazyUpdate;
    private boolean fixed;
    private DescriptionLink emptyMessageLink;
    private DescriptionLink descriptionLink;
    private Supplier<String> toolTipSupplier;

    public StrKey(String string) {
        this(string, "");
    }

    public StrKey(String string, String string2) {
        this(string, (String)null, string2);
    }

    public StrKey(String string, String string2, String string3) {
        super(string, string2, string3);
        this.minWidth = 150;
    }

    public StrKey(Map<?, ?> map) {
        super(map);
        if (!map.containsKey("default")) {
            this.defaultValue = "";
        }
        if (!map.containsKey("minWidth")) {
            this.minWidth = 150;
        }
        this.multiLine = StrKey.yamlValue(this.multiLine, Boolean.class, "multiLine", map);
        this.fixed = StrKey.yamlValue(this.fixed, Boolean.class, "fixed", map);
        this.defaultMessage = StrKey.yamlValue(this.defaultMessage, Boolean.class, "defaultMessage", map);
    }

    protected StrKey(Builder<?> builder) {
        super(builder);
        this.multiLine = builder.multiLine;
        this.emptyMessageLink = builder.emptyMessageLink;
        this.lazyUpdate = builder.lazyUpdate;
        this.fixed = builder.fixed;
        this.defaultMessage = builder.defaultMessage;
        this.descriptionLink = builder.descriptionLink;
        this.toolTipSupplier = builder.toolTipSupplier;
    }

    public static Builder<?> builder(String string) {
        return StrKey.builder(string, string);
    }

    public static Builder<?> builder(String string, String string2) {
        return new Builder2(string, string2);
    }

    @Override
    protected String getYamlType() {
        return "string";
    }

    public boolean isEmptyMessage() {
        return this.emptyMessageLink != null && (!this.emptyMessageLink.isConstant() || !this.emptyMessageLink.getConstantDescription().isEmpty());
    }

    public String getEmptyMessage(ValueMap valueMap) {
        if (!this.isEmptyMessage()) {
            return "";
        }
        String string = this.emptyMessageLink.getDescription(this, valueMap.getValue(this), valueMap);
        if (this.defaultMessage) {
            string = StrKey.toDefault(string);
        }
        return string;
    }

    public String getDynamicDefaultMessage(ValueMap valueMap) {
        String string = (String)valueMap.getDynamicDefaultValue(this);
        if (string == null) {
            string = "";
        }
        return StrKey.toDefault(string);
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public boolean isLazyUpdate() {
        return this.lazyUpdate;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public DescriptionLink getDescriptionLink() {
        return this.descriptionLink;
    }

    public String getDescriptionMessage(ValueMap valueMap) {
        if (this.descriptionLink == null) {
            return "";
        }
        return this.descriptionLink.getDescription(this, valueMap.getValue(this), valueMap);
    }

    public Supplier<String> getToolTipSupplier() {
        return this.toolTipSupplier;
    }

    @Override
    public boolean isSearchable() {
        return true;
    }

    @Override
    public void search(List<SearchResult> list, SearchContext searchContext, Object object, ValueMap valueMap) {
        List<TextSearchResult> list2 = SearchUtility.searchText(searchContext, (String)object, !this.isMultiLine());
        for (TextSearchResult textSearchResult : list2) {
            list.add(new KeySearchResult(this, textSearchResult));
        }
    }

    @Override
    public boolean replace(SearchContext searchContext, String string, SearchResult searchResult, List<SearchResult> list, Object object, ValueMap valueMap) {
        if (!(searchResult instanceof TextSearchResult)) {
            return false;
        }
        TextSearchResult textSearchResult = (TextSearchResult)searchResult;
        String string2 = (String)object;
        if (searchContext.isRegularExpression() && (string = SearchUtility.replaceStringForRegex(searchContext, string2, textSearchResult.getOffset(), textSearchResult.getLength(), string)) == null) {
            return false;
        }
        if (this.isAutoValueLink()) {
            valueMap.putValue(this.getAutoValueLinkKey(), Boolean.FALSE);
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.replace(textSearchResult.getOffset(), textSearchResult.getEnd(), string);
        valueMap.putValue(this, stringBuilder.toString());
        for (SearchResult searchResult2 : list) {
            TextSearchResult textSearchResult2;
            if (!(searchResult2 instanceof TextSearchResult) || (textSearchResult2 = (TextSearchResult)searchResult2).getOffset() <= textSearchResult.getOffset()) continue;
            textSearchResult2.setOffset(textSearchResult2.getOffset() - textSearchResult.getLength() + string.length());
        }
        textSearchResult.setLength(string.length());
        return true;
    }

    @Override
    public boolean validateSearchResult(SearchContext searchContext, SearchResult searchResult, Object object) {
        if (!(searchResult instanceof TextSearchResult) || !searchResult.isEnabled()) {
            return true;
        }
        boolean bl = false;
        return bl;
    }

    @Override
    protected void toYaml(Map<Object, Object> map) {
        super.toYaml(map);
        if (this.defaultValue != null && !((String)this.defaultValue).isEmpty()) {
            map.put("default", this.defaultValue);
        }
        if (this.multiLine) {
            map.put("multiLine", this.multiLine);
        }
        if (this.fixed) {
            map.put("fixed", this.fixed);
        }
        if (this.defaultMessage) {
            map.put("defaultMessage", this.defaultMessage);
        }
    }

    @Override
    public boolean isValueEmpty(String string) {
        return string.length() < 1;
    }

    @Override
    public String valueToString(Object object) {
        return object.toString();
    }

    @Override
    public Object stringToValue(String string) {
        return string;
    }

    @Override
    public String copyValue(String string) {
        return string;
    }

    @Override
    public Class<?> getJavaClass() {
        return String.class;
    }

    @Override
    public void localizationValues(List<String> list) {
        super.localizationValues(list);
        if (this.emptyMessageLink != null && this.emptyMessageLink.isConstant()) {
            list.add(this.emptyMessageLink.getConstantDescription());
        }
    }

    @Override
    public void localize(Map<String, String> map) {
        String string;
        super.localize(map);
        if (this.emptyMessageLink != null && this.emptyMessageLink.isConstant() && map.containsKey(string = this.emptyMessageLink.getConstantDescription())) {
            this.emptyMessageLink = new ConstantDescriptionLink(StrKey.valueOrDefault(map, string));
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Key.Builder<String, T> {
        private boolean multiLine = false;
        private boolean lazyUpdate = false;
        private boolean fixed = false;
        private boolean defaultMessage;
        private DescriptionLink emptyMessageLink;
        private DescriptionLink descriptionLink;
        private Supplier<String> toolTipSupplier;

        public Builder(String string, String string2) {
            super(string, string2);
            this.setDefaultValue("");
            this.setMinWidth(150);
        }

        @Override
        protected abstract T self();

        public StrKey build() {
            return new StrKey(this);
        }

        public T setMultiLine(boolean bl) {
            this.multiLine = bl;
            return (T)this.self();
        }

        public T setDefaultMessage(String string) {
            this.defaultMessage = true;
            return this.setEmptyMessage(string);
        }

        public T setEmptyMessage(String string) {
            this.emptyMessageLink = new ConstantDescriptionLink(string);
            return (T)this.self();
        }

        public T setEmptyMessageLink(DescriptionProvider descriptionProvider, String ... stringArray) {
            this.emptyMessageLink = new BasicDescriptionLink(descriptionProvider, stringArray);
            return (T)this.self();
        }

        public T setLazyUpdate(boolean bl) {
            this.lazyUpdate = bl;
            return (T)this.self();
        }

        public T setFixed(boolean bl) {
            this.fixed = bl;
            return (T)this.self();
        }

        public T setDescriptionLink(DescriptionProvider descriptionProvider) {
            return this.setDescriptionLink(this.id, descriptionProvider);
        }

        public T setDescriptionLink(String string, DescriptionProvider descriptionProvider) {
            this.descriptionLink = new BasicDescriptionLink(descriptionProvider, string);
            return (T)this.self();
        }

        public T setDescriptionLink(DescriptionProvider descriptionProvider, String ... stringArray) {
            this.descriptionLink = new BasicDescriptionLink(descriptionProvider, stringArray);
            return (T)this.self();
        }

        public T setToolTipSupplier(Supplier<String> supplier) {
            this.toolTipSupplier = supplier;
            return (T)this.self();
        }

        public T label() {
            return (T)((Builder)((Builder)((Key.Builder)this.setFixed(true)).setNoSave(true)).setMinWidth(0));
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        public Builder2(String string, String string2) {
            super(string, string2);
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

