/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.BasicKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;

public class StrKeyTest
extends BasicKeyTest {
    private Set<String> values;

    public StrKeyTest(String string, boolean bl, String ... stringArray) {
        super(string, bl);
        this.values = Sets.newHashSet((Object[])stringArray);
    }

    public static StrKeyTest ignoreEnabled(StrKey strKey, String ... stringArray) {
        return new StrKeyTest(strKey.getId(), false, stringArray);
    }

    public static StrKeyTest create(StrKey strKey, String ... stringArray) {
        return new StrKeyTest(strKey.getId(), true, stringArray);
    }

    @Override
    protected boolean disabled() {
        return false;
    }

    @Override
    protected boolean test(ValueMap valueMap, Key<?> key) {
        return this.values.contains(valueMap.getValue(key));
    }

    @Override
    protected void setValue(ValueMap valueMap, Key<?> key, boolean bl) {
        ChoiceKey choiceKey;
        if (bl) {
            valueMap.putValue(key, this.values.iterator().next());
        } else if (key instanceof ChoiceKey && !(choiceKey = (ChoiceKey)key).isChoiceEditable()) {
            String string = null;
            List<Choice> list = choiceKey.getChoices(valueMap);
            for (Choice choice : list) {
                if (this.values.contains(choice.getValue())) continue;
                string = choice.getValue();
            }
            if (string != null) {
                valueMap.putValue(choiceKey, string);
            }
        }
    }
}

