/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.BasicValueError;
import com.ef_prime.rflow.core.common.keyvalue.CompoundValueError;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.NonAtomicKey;
import com.ef_prime.rflow.core.common.keyvalue.TableRowValidator;
import com.ef_prime.rflow.core.common.keyvalue.ValidationContext;
import com.ef_prime.rflow.core.common.keyvalue.ValueError;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.Keys;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.core.common.table.RowBasedTableModelEvent;
import com.ef_prime.rflow.core.common.table.RowBasedTableModelEventHandler;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.feature.search.KeySearchResult;
import com.ef_prime.rflow.core.feature.search.SearchContext;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.SearchUtility;
import com.ef_prime.rflow.core.feature.search.TableTextSearchResult;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.node.ui.RAddonOpData;
import com.ef_prime.rflow.resource.Messages;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TableKey
extends NonAtomicKey<KeysTableModel>
implements RowBasedTableModelEventHandler {
    public static final int DEFAULT_COLUMN_WIDTH = 300;
    public static final Predicate<KeysTableRow> DEFAULT_VALID_ROW_PREDICATE = new Predicate<KeysTableRow>(){

        @Override
        public boolean test(KeysTableRow keysTableRow) {
            for (int i = 0; i < keysTableRow.getColumnCount(); ++i) {
                Key<?> key = keysTableRow.getColumnKey(i);
                if (key.isValueEmpty(keysTableRow.getValue(i))) continue;
                return true;
            }
            return false;
        }
    };
    private KeysTableModel baseModel;
    private Predicate<KeysTableRow> rowPredicate;
    private List<TableRowValidator> rowValidators;

    protected TableKey(Builder<?> builder) {
        super(builder);
        this.baseModel = (KeysTableModel)this.getDefaultValue();
        this.rowPredicate = builder.rowPredicate;
        this.rowValidators = builder.rowValidators;
        if (this.rowPredicate != null) {
            if (this.rowValidators == null) {
                this.rowValidators = new ArrayList<TableRowValidator>(1);
            }
            this.rowValidators.add(new TableRowValidator(){

                @Override
                public ValueError validate(Key<?> key, KeysTableModel keysTableModel, KeysTableRow keysTableRow, int n) {
                    if (!TableKey.this.rowPredicate.test(keysTableRow)) {
                        BasicValueError basicValueError = new BasicValueError(1, Messages.getString("Message.row_ignored"), null);
                        basicValueError.setHighPriority(true);
                        return basicValueError;
                    }
                    return null;
                }
            });
        }
    }

    public TableKey(Map<?, ?> map) {
        super(map);
        this.growY = true;
        Map map2 = (Map)Utility.cast(YamlEx.mapValue(Map.class, "columns", map));
        List<Key<?>> list = RAddonOpData.getKeys(map2);
        this.baseModel = new KeysTableModel(list.toArray(new Key[list.size()]), GeneralTableModel.UI_DEFAULT2);
        this.defaultValue = (KeysTableModel)this.baseModel.copy();
    }

    public static Builder<?> builder(String string, String string2, Key<?> ... keyArray) {
        return new Builder2(string, string2, keyArray);
    }

    @Override
    protected String getYamlType() {
        return "table";
    }

    public List<TableRowValidator> getRowValidators() {
        return this.rowValidators;
    }

    public Key<?>[] getColumnKeys() {
        return this.baseModel.getColumnKeys();
    }

    @Override
    public boolean isSearchable() {
        return true;
    }

    @Override
    public void search(List<SearchResult> list, SearchContext searchContext, Object object, ValueMap valueMap) {
        KeysTableModel keysTableModel = (KeysTableModel)object;
        ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
        for (int i = 0; i < keysTableModel.getRowCount(); ++i) {
            KeysTableRow keysTableRow = (KeysTableRow)keysTableModel.getRow(i);
            for (int j = 0; j < keysTableRow.getColumnCount(); ++j) {
                Key<?> key = keysTableRow.getColumnKey(j);
                if (!valueMap.isSearchable(key)) continue;
                arrayList.clear();
                key.search(arrayList, searchContext, keysTableModel.getValueAt(i, j), valueMap);
                for (SearchResult searchResult : arrayList) {
                    if (!(searchResult instanceof KeySearchResult) || !(((KeySearchResult)searchResult).getResult() instanceof TextSearchResult)) continue;
                    TextSearchResult textSearchResult = (TextSearchResult)((KeySearchResult)searchResult).getResult();
                    list.add(new KeySearchResult(this, new TableTextSearchResult(i, j, textSearchResult.getOffset(), textSearchResult.getLength())));
                }
            }
        }
    }

    @Override
    public boolean replace(SearchContext searchContext, String string, SearchResult searchResult, List<SearchResult> list, Object object, ValueMap valueMap) {
        if (!(searchResult instanceof TableTextSearchResult)) {
            return false;
        }
        TableTextSearchResult tableTextSearchResult = (TableTextSearchResult)searchResult;
        KeysTableModel keysTableModel = (KeysTableModel)object;
        String string2 = (String)keysTableModel.getValueAt(tableTextSearchResult.getRow(), tableTextSearchResult.getColumn());
        if (searchContext.isRegularExpression() && (string = SearchUtility.replaceStringForRegex(searchContext, string2, tableTextSearchResult.getOffset(), tableTextSearchResult.getLength(), string)) == null) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.replace(tableTextSearchResult.getOffset(), tableTextSearchResult.getEnd(), string);
        keysTableModel.setValueAt(stringBuilder.toString(), tableTextSearchResult.getRow(), tableTextSearchResult.getColumn());
        for (SearchResult searchResult2 : list) {
            if (!(searchResult2 instanceof TableTextSearchResult)) continue;
            TableTextSearchResult tableTextSearchResult2 = (TableTextSearchResult)searchResult2;
            if (tableTextSearchResult.getRow() != tableTextSearchResult2.getRow() || tableTextSearchResult.getColumn() != tableTextSearchResult2.getColumn() || tableTextSearchResult.getOffset() >= tableTextSearchResult2.getOffset()) continue;
            tableTextSearchResult2.setOffset(tableTextSearchResult2.getOffset() - tableTextSearchResult.getLength() + string.length());
        }
        tableTextSearchResult.setLength(string.length());
        return true;
    }

    @Override
    public boolean isValueEmpty(KeysTableModel keysTableModel) {
        if (this.rowPredicate != null) {
            for (KeysTableRow keysTableRow : keysTableModel) {
                if (!this.rowPredicate.test(keysTableRow)) continue;
                return false;
            }
            return true;
        }
        return keysTableModel.getRowCount() == 0;
    }

    @Override
    public void valueToElement(Document document, Element element, Object object) {
        KeysTableModel keysTableModel = (KeysTableModel)object;
        keysTableModel.storeToElement(new XmlContext(), document, element);
    }

    @Override
    public Object elementToValue(Element element) {
        KeysTableModel keysTableModel = new KeysTableModel(this.baseModel);
        keysTableModel.removeAllRows();
        keysTableModel.loadElement(element, new XmlContext());
        keysTableModel.addRowBasedTableModelEventHandler(this);
        return keysTableModel;
    }

    @Override
    public Object valueToYamlValue(YamlEx yamlEx, Object object, boolean bl) {
        return ((KeysTableModel)object).toYamlValue(yamlEx);
    }

    @Override
    public Object yamlValueToValue(YamlEx yamlEx, Object object) {
        KeysTableModel keysTableModel = new KeysTableModel(this.baseModel);
        keysTableModel.removeAllRows();
        keysTableModel.loadYamlValue(yamlEx, object);
        keysTableModel.addRowBasedTableModelEventHandler(this);
        return keysTableModel;
    }

    @Override
    public KeysTableModel copyValue(KeysTableModel keysTableModel) {
        KeysTableModel keysTableModel2 = (KeysTableModel)keysTableModel.copy();
        keysTableModel2.addRowBasedTableModelEventHandler(this);
        return keysTableModel2;
    }

    @Override
    public Class<?> getJavaClass() {
        return KeysTableModel.class;
    }

    @Override
    protected void validate(KeysTableModel keysTableModel, ValidationContext validationContext) {
        List<ValueError> list;
        super.validate(keysTableModel, validationContext);
        if (keysTableModel != null && (list = keysTableModel.getErrors()) != null && !list.isEmpty()) {
            validationContext.addAllErrors(this, list);
        }
    }

    public void validate(KeysTableModel keysTableModel, int n, int n2) {
        ValueMap valueMap = keysTableModel.getParentValueMap();
        KeysTableRow keysTableRow = (KeysTableRow)keysTableModel.getRow(n);
        ValueError valueError = null;
        List<TableRowValidator> list = this.getRowValidators();
        if (list != null && !list.isEmpty()) {
            TableRowValidator tableRowValidator;
            Object object = list.iterator();
            while (object.hasNext() && (valueError = (tableRowValidator = object.next()).validate(this, keysTableModel, keysTableRow, n2)) == null) {
            }
            if (valueError != null && valueError.isHighPriority()) {
                n2 = 0;
                for (int i = 0; i < keysTableModel.getColumnCount(); ++i) {
                    keysTableModel.removeError(n, i);
                }
            } else {
                object = new ValidationContext();
                for (int i = 0; i < keysTableModel.getColumnCount(); ++i) {
                    Key<?> key = keysTableModel.getColumnKey(i);
                    if (valueMap == null || valueMap.isEnabled(key)) {
                        key.validate(keysTableRow.getValue(i), (ValidationContext)object);
                    }
                    keysTableModel.putError(n, i, CompoundValueError.convert(((ValidationContext)object).getError(key)));
                }
            }
            if (valueError != null) {
                ValueError valueError2 = keysTableModel.getError(n, 0);
                if (valueError2 != null) {
                    valueError = new CompoundValueError(null, Lists.newArrayList((Object[])new ValueError[]{valueError, valueError2}));
                }
                keysTableModel.putError(n, 0, valueError);
            }
        } else {
            ValidationContext validationContext = new ValidationContext();
            Key<?> key = keysTableModel.getColumnKey(n2);
            if (valueMap == null || valueMap.isEnabled(key)) {
                key.validate(keysTableRow.getValue(n2), validationContext);
            }
            keysTableModel.putError(n, n2, CompoundValueError.convert(validationContext.getError(key)));
        }
    }

    public void revalidate(KeysTableModel keysTableModel) {
        for (int i = 0; i < keysTableModel.getRowCount(); ++i) {
            for (int j = 0; j < keysTableModel.getColumnCount(); ++j) {
                this.validate(keysTableModel, i, j);
            }
        }
    }

    @Override
    public void localize(Map<String, String> map) {
        super.localize(map);
        String string = this.baseModel.getEmptyMessage();
        this.baseModel.setEmptyMessage(TableKey.valueOrDefault(map, string));
        if (!Objects.equals(string, this.baseModel.getEmptyMessage())) {
            this.defaultValue = (KeysTableModel)this.baseModel.copy();
        }
        for (Key<?> key : this.getColumnKeys()) {
            key.localize(map);
        }
    }

    @Override
    public void localizationValues(List<String> list) {
        super.localizationValues(list);
        list.add(this.baseModel.getEmptyMessage());
        for (Key<?> key : this.getColumnKeys()) {
            key.localizationValues(list);
        }
    }

    @Override
    public void rowBasedTableChanged(RowBasedTableModelEvent rowBasedTableModelEvent) {
        KeysTableModel keysTableModel = (KeysTableModel)rowBasedTableModelEvent.getModel();
        switch (rowBasedTableModelEvent.getType()) {
            case 2: {
                this.validate(keysTableModel, rowBasedTableModelEvent.getUpdatedRow(), rowBasedTableModelEvent.getUpdatedColumn());
                break;
            }
            case 0: {
                int[] nArray = rowBasedTableModelEvent.getRows();
                for (int i = 0; i < nArray.length; ++i) {
                    for (int j = 0; j < keysTableModel.getColumnCount(); ++j) {
                        this.validate(keysTableModel, nArray[i], j);
                    }
                }
                break;
            }
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Key.Builder<KeysTableModel, T> {
        private Key<?>[] columnKeys;
        private int[] uiControls;
        private boolean useLastColumnAsDetail;
        private List<KeysTableRow> rows;
        private KeysTableRow defaultRow;
        private Map<Integer, Integer> columnWidth;
        private Map<Integer, Integer> fixedColumnWidth;
        private boolean unboundTableArea = true;
        private Boolean hideHeader;
        private int onOffColumn = -1;
        private String emptyMessage = null;
        private boolean defaultMessage;
        private int selectionMode;
        private Predicate<KeysTableRow> rowPredicate;
        private List<TableRowValidator> rowValidators;

        public Builder(String string, String string2, Key<?> ... keyArray) {
            super(string, string2);
            this.columnKeys = keyArray;
            this.setGrowY(true);
            this.setLabelPosition("top");
        }

        @Override
        protected abstract T self();

        private KeysTableModel buildModel() {
            KeysTableModel keysTableModel = null;
            keysTableModel = this.defaultRow != null ? new KeysTableModel(this.defaultRow, this.uiControls, this.useLastColumnAsDetail, this.rows) : new KeysTableModel(this.columnKeys, this.uiControls, this.useLastColumnAsDetail, this.rows);
            keysTableModel.setColumnWidthMap(this.columnWidth);
            keysTableModel.setFixedColumnWidthMap(this.fixedColumnWidth);
            keysTableModel.setUnboundTableArea(this.unboundTableArea);
            keysTableModel.setOnOffColumn(this.onOffColumn);
            if (this.hideHeader == null) {
                keysTableModel.setHideHeader(keysTableModel.getColumnCount() == 1);
            } else {
                keysTableModel.setHideHeader(this.hideHeader);
            }
            keysTableModel.setEmptyMessage(this.emptyMessage);
            keysTableModel.setDefaultMessage(this.defaultMessage);
            keysTableModel.setSelectionMode(this.selectionMode);
            return keysTableModel;
        }

        @Override
        public Object getDefaultValue() {
            if (!this.isDefaultValue()) {
                return this.buildModel();
            }
            return super.getDefaultValue();
        }

        public TableKey build() {
            if (!this.isDefaultValue()) {
                this.setDefaultValue(this.buildModel());
            }
            return new TableKey(this);
        }

        public T setUiControls(int[] nArray) {
            this.uiControls = nArray;
            return (T)this.self();
        }

        public T setUseLastColumnAsDetail(boolean bl) {
            this.useLastColumnAsDetail = bl;
            return (T)this.self();
        }

        public T setColumnWidth(int n, int n2) {
            if (this.columnWidth == null) {
                this.columnWidth = new HashMap<Integer, Integer>();
            }
            this.columnWidth.put(n, n2);
            return (T)this.self();
        }

        public T setFixedColumnWidth(int n, int n2) {
            if (this.fixedColumnWidth == null) {
                this.fixedColumnWidth = new HashMap<Integer, Integer>();
            }
            this.fixedColumnWidth.put(n, n2);
            return (T)this.self();
        }

        public T addRow(Object ... objectArray) {
            if (this.rows == null) {
                this.rows = new ArrayList<KeysTableRow>();
            }
            if (this.defaultRow == null) {
                this.defaultRow = new KeysTableRow(new Keys(this.columnKeys));
            }
            KeysTableRow keysTableRow = (KeysTableRow)this.defaultRow.copyRow();
            keysTableRow.load(objectArray);
            this.rows.add(keysTableRow);
            return (T)this.self();
        }

        public T setUnboundTableArea(boolean bl) {
            this.unboundTableArea = bl;
            return (T)this.self();
        }

        public T setHideHeader(Boolean bl) {
            this.hideHeader = bl;
            return (T)this.self();
        }

        public T setDefaultRow(KeysTableRow keysTableRow) {
            if (this.defaultRow != null) {
                throw new RuntimeException("'defaultRow' already defined");
            }
            this.defaultRow = keysTableRow;
            return (T)this.self();
        }

        public T setOnOffColumn(int n) {
            this.onOffColumn = n;
            return (T)this.self();
        }

        public T setDefaultMessage(String string) {
            this.defaultMessage = true;
            return this.setEmptyMessage(string);
        }

        public T setEmptyMessage(String string) {
            this.emptyMessage = string;
            return (T)this.self();
        }

        public T setSelectionMode(int n) {
            this.selectionMode = n;
            return (T)this.self();
        }

        public T addRowValidator(TableRowValidator tableRowValidator) {
            if (this.rowValidators == null) {
                this.rowValidators = new ArrayList<TableRowValidator>(1);
            }
            this.rowValidators.add(tableRowValidator);
            return (T)this.self();
        }

        public T setRowPredicate(Predicate<KeysTableRow> predicate) {
            this.rowPredicate = predicate;
            return (T)this.self();
        }

        public T setDefaultRowPredicate() {
            return this.setRowPredicate(DEFAULT_VALID_ROW_PREDICATE);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        public Builder2(String string, String string2, Key<?> ... keyArray) {
            super(string, string2, keyArray);
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

