/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.resource.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class UIValueMap
extends ValueMap {
    private static final Logger LOGGER = Logger.getLogger(UIValueMap.class.getName());
    public static final String STR_MAIN = "Main";
    public static final String STR_OPTIONS = "Options";
    public static final String STR_ADVANCED = "Advanced";
    private static final Map<String, String> defaultI18nMap = new HashMap<String, String>(3);
    protected Map<String, String> i18nMap;

    public UIValueMap() {
        this.initKeys();
    }

    protected UIValueMap(UIValueMap uIValueMap) {
        super(uIValueMap);
        this.i18nMap = uIValueMap.i18nMap;
    }

    protected abstract void initKeys();

    protected void localize(Map<String, String> map) {
    }

    public void loadResource() {
        this.i18nMap = new HashMap<String, String>(defaultI18nMap);
        this.loadResourceFiles();
        try {
            this.localize(this.i18nMap);
            for (Key<?> key : this.keySet()) {
                key.localize(this.i18nMap);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to localize: " + String.valueOf(this.getClass()), exception);
        }
    }

    protected void loadResourceFiles() {
        this.loadResourceFile(this.getClass());
    }

    protected void loadResourceFile(Class<?> clazz) {
        UIValueMap.loadResourceFile(clazz, this.i18nMap);
    }

    public static void loadResourceFile(Class<?> clazz, Map<String, String> map) {
        try (InputStream inputStream = clazz.getResourceAsStream(clazz.getSimpleName() + ".xml");){
            if (inputStream == null) {
                return;
            }
            Document document = XmlUtility.readXml(inputStream);
            Element element = XmlUtility.getChild("i18n", document.getDocumentElement());
            if (element == null) {
                return;
            }
            String string = Locale.getDefault().getLanguage();
            Element element2 = XmlUtility.getChild(string, element);
            if (element2 == null) {
                return;
            }
            List<Element> list = XmlUtility.getChildren("replace", element2);
            for (Element element3 : list) {
                String string2 = element3.getAttribute("from");
                if (StringUtils.isEmpty((CharSequence)string2)) continue;
                String string3 = element3.getAttribute("to");
                map.put(string2, string3);
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Failed to read resource file: " + clazz.getSimpleName() + ".xml", iOException);
        }
    }

    public WidgetNode getUIWidgetNode(ViewOptions viewOptions) {
        WidgetNode widgetNode = this.getWidgetNode(viewOptions);
        if (this.i18nMap != null) {
            widgetNode.localize(this.i18nMap);
        }
        return widgetNode;
    }

    static {
        defaultI18nMap.put(STR_MAIN, Messages.getString("Node.default.main"));
        defaultI18nMap.put(STR_OPTIONS, Messages.getString("Node.default.options"));
        defaultI18nMap.put(STR_ADVANCED, Messages.getString("Node.default.advanced"));
    }
}

