/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.NonAtomicKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.table.UnboundTableModel;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.feature.search.KeySearchResult;
import com.ef_prime.rflow.core.feature.search.SearchContext;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.SearchUtility;
import com.ef_prime.rflow.core.feature.search.TableTextSearchResult;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.core.util.YamlEx;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UnboundTableKey
extends NonAtomicKey<UnboundTableModel> {
    private UnboundTableModel baseModel = (UnboundTableModel)this.getDefaultValue();

    public UnboundTableKey(Builder<?> builder) {
        super(builder);
    }

    public static Builder<?> builder(String string, String string2) {
        return new Builder2(string, string2);
    }

    @Override
    public boolean isSearchable() {
        return true;
    }

    @Override
    public void search(List<SearchResult> list, SearchContext searchContext, Object object, ValueMap valueMap) {
        UnboundTableModel unboundTableModel = (UnboundTableModel)object;
        for (int i = 0; i < unboundTableModel.getRowCount(); ++i) {
            List<Object> list2 = unboundTableModel.getRow(i);
            for (int j = 0; j < list2.size(); ++j) {
                String string = (String)list2.get(j);
                if (string == null || string.isEmpty()) continue;
                List<TextSearchResult> list3 = SearchUtility.searchText(searchContext, string, false);
                for (TextSearchResult textSearchResult : list3) {
                    list.add(new KeySearchResult(this, new TableTextSearchResult(i, j, textSearchResult.getOffset(), textSearchResult.getLength())));
                }
            }
        }
    }

    @Override
    public boolean replace(SearchContext searchContext, String string, SearchResult searchResult, List<SearchResult> list, Object object, ValueMap valueMap) {
        if (!(searchResult instanceof TableTextSearchResult)) {
            return false;
        }
        TableTextSearchResult tableTextSearchResult = (TableTextSearchResult)searchResult;
        UnboundTableModel unboundTableModel = (UnboundTableModel)object;
        String string2 = (String)unboundTableModel.getValueAt(tableTextSearchResult.getRow(), tableTextSearchResult.getColumn());
        if (searchContext.isRegularExpression() && (string = SearchUtility.replaceStringForRegex(searchContext, string2, tableTextSearchResult.getOffset(), tableTextSearchResult.getLength(), string)) == null) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.replace(tableTextSearchResult.getOffset(), tableTextSearchResult.getEnd(), string);
        unboundTableModel.setValueAt(stringBuilder.toString(), tableTextSearchResult.getRow(), tableTextSearchResult.getColumn());
        for (SearchResult searchResult2 : list) {
            if (!(searchResult2 instanceof TableTextSearchResult)) continue;
            TableTextSearchResult tableTextSearchResult2 = (TableTextSearchResult)searchResult2;
            if (tableTextSearchResult.getRow() != tableTextSearchResult2.getRow() || tableTextSearchResult.getColumn() != tableTextSearchResult2.getColumn() || tableTextSearchResult.getOffset() >= tableTextSearchResult2.getOffset()) continue;
            tableTextSearchResult2.setOffset(tableTextSearchResult2.getOffset() - tableTextSearchResult.getLength() + string.length());
        }
        tableTextSearchResult.setLength(string.length());
        return true;
    }

    @Override
    public boolean isValueEmpty(UnboundTableModel unboundTableModel) {
        return unboundTableModel.getRowCount() == 0;
    }

    @Override
    public UnboundTableModel copyValue(UnboundTableModel unboundTableModel) {
        return unboundTableModel.copy();
    }

    @Override
    public void valueToElement(Document document, Element element, Object object) {
        UnboundTableModel unboundTableModel = (UnboundTableModel)object;
        unboundTableModel.storeToElement(new XmlContext(), document, element);
    }

    @Override
    public Object elementToValue(Element element) {
        UnboundTableModel unboundTableModel = this.baseModel.copy();
        unboundTableModel.clear();
        unboundTableModel.loadElement(element, new XmlContext());
        return unboundTableModel;
    }

    @Override
    public Object valueToYamlValue(YamlEx yamlEx, Object object, boolean bl) {
        return ((UnboundTableModel)object).toYamlValue(yamlEx);
    }

    @Override
    public Object yamlValueToValue(YamlEx yamlEx, Object object) {
        UnboundTableModel unboundTableModel = this.baseModel.copy();
        unboundTableModel.clear();
        unboundTableModel.loadYamlValue(yamlEx, object);
        return unboundTableModel;
    }

    @Override
    public Class<?> getJavaClass() {
        return UnboundTableModel.class;
    }

    private static class Builder2
    extends Builder<Builder2> {
        public Builder2(String string, String string2) {
            super(string, string2);
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Key.Builder<UnboundTableModel, T> {
        private List<List<Object>> rows;

        public Builder(String string, String string2) {
            super(string, string2);
            this.setGrowY(true);
            this.setGrowX(true);
            this.setLabelPosition("top");
        }

        @Override
        protected abstract T self();

        private UnboundTableModel buildModel() {
            UnboundTableModel unboundTableModel = this.rows == null ? new UnboundTableModel() : new UnboundTableModel(this.rows);
            return unboundTableModel;
        }

        @Override
        public Object getDefaultValue() {
            if (!this.isDefaultValue()) {
                return this.buildModel();
            }
            return super.getDefaultValue();
        }

        public UnboundTableKey build() {
            if (!this.isDefaultValue()) {
                this.setDefaultValue(this.buildModel());
            }
            return new UnboundTableKey(this);
        }

        public T addRow(Object ... objectArray) {
            if (this.rows == null) {
                this.rows = new ArrayList<List<Object>>(2);
            }
            this.rows.add(Lists.newArrayList((Object[])objectArray));
            return (T)this.self();
        }
    }
}

