/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.CompoundValueError;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.Validator;
import com.ef_prime.rflow.core.common.keyvalue.ValueError;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ValidationContext {
    private List<Validator> validators;
    private Multimap<Key<?>, Validator> keyValidators;
    private ListMultimap<Validator, ValueError> validatorErrors;

    public synchronized void init(ValueMap valueMap) {
        if (this.validatorErrors != null) {
            this.validatorErrors.clear();
        }
        boolean bl = false;
        if (this.validators != null) {
            for (Validator iterator : this.validators) {
                iterator.validate(null, null, this);
            }
            if (this.validatorErrors != null) {
                HashSet hashSet = new HashSet();
                for (ValueError valueError : this.validatorErrors.values()) {
                    if (!valueError.isHighPriority()) continue;
                    hashSet.add(valueError);
                }
                if (!hashSet.isEmpty()) {
                    Iterator iterator = this.validatorErrors.values().iterator();
                    while (iterator.hasNext()) {
                        ValueError valueError;
                        valueError = (ValueError)iterator.next();
                        if (valueError.isHighPriority()) continue;
                        iterator.remove();
                    }
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.validateAllKeyValues(valueMap);
        }
    }

    public synchronized <T> void validate(ValueMap valueMap, Key<T> key) {
        block8: {
            Object var3_3;
            block7: {
                Object v0 = var3_3 = valueMap.contains(key) ? valueMap.getValue(key) : null;
                if (this.validators == null) break block7;
                for (Validator iterator : this.validators) {
                    this.validatorErrors.get((Object)iterator).clear();
                    iterator.validate(key, var3_3, this);
                }
                if (this.validatorErrors == null) break block8;
                HashSet hashSet = new HashSet();
                for (ValueError valueError : this.validatorErrors.values()) {
                    if (!valueError.isHighPriority()) continue;
                    hashSet.add(valueError);
                }
                if (!hashSet.isEmpty()) {
                    Iterator iterator = this.validatorErrors.values().iterator();
                    while (iterator.hasNext()) {
                        ValueError valueError;
                        valueError = (ValueError)iterator.next();
                        if (valueError.isHighPriority()) continue;
                        iterator.remove();
                    }
                } else {
                    this.validateAllKeyValues(valueMap);
                }
                break block8;
            }
            this.validateKeyValue(key, var3_3, valueMap);
            block3: for (Key<?> key2 : valueMap.keys()) {
                if (key2.isObsolete() || key2.equals(key) || !key2.isKeyLink()) continue;
                List<KeyLink> list = key2.getKeyLinks();
                for (KeyLink keyLink : list) {
                    if (!keyLink.contains(valueMap, key.getId())) continue;
                    this.validateKeyValue(key2, valueMap);
                    continue block3;
                }
            }
        }
    }

    private void validateAllKeyValues(ValueMap valueMap) {
        for (Key<?> key : valueMap.keys()) {
            if (key.isObsolete()) continue;
            this.validateKeyValue(key, valueMap);
        }
    }

    private void validateKeyValue(Key<?> key, ValueMap valueMap) {
        Object var3_3;
        Object v0 = var3_3 = valueMap.contains(key) ? valueMap.getValue(key) : null;
        if (var3_3 == null) {
            var3_3 = key.getDefaultValue();
        }
        this.validateKeyValue(key, var3_3, valueMap);
    }

    private void validateKeyValue(Key<?> key, Object object, ValueMap valueMap) {
        if (this.validatorErrors != null) {
            this.validatorErrors.get(key).clear();
        }
        if (!valueMap.isEnabled(key)) {
            return;
        }
        key.validate(key, object, this);
        if (this.keyValidators != null) {
            for (Validator validator : this.keyValidators.get(key)) {
                this.validatorErrors.get((Object)validator).clear();
                validator.validate(key, object, this);
            }
        }
    }

    public CompoundValueError getErrorOrNull(int n) {
        List<ValueError> list = this.getAllErrors(n);
        if (list.isEmpty()) {
            return null;
        }
        return new CompoundValueError(null, list);
    }

    public synchronized List<ValueError> getAllErrors(int n) {
        ArrayList<ValueError> arrayList = new ArrayList<ValueError>();
        if (this.validatorErrors != null) {
            for (ValueError valueError : this.validatorErrors.values()) {
                if (valueError.getLevel() < n) continue;
                arrayList.add(valueError);
            }
        }
        return arrayList;
    }

    public boolean containsNoError() {
        return this.getAllErrors(4).isEmpty();
    }

    public synchronized List<ValueError> getError(Key<?> key) {
        if (!this.isError()) {
            return null;
        }
        ArrayList<ValueError> arrayList = new ArrayList<ValueError>();
        for (ValueError valueError : this.validatorErrors.values()) {
            if (!Objects.equals(key, valueError.getKey())) continue;
            arrayList.add(valueError);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public synchronized List<ValueError> getErrors(Collection<Key<?>> collection) {
        if (!this.isError()) {
            return null;
        }
        HashMultimap hashMultimap = HashMultimap.create((int)collection.size(), (int)1);
        for (Object object : this.validatorErrors.values()) {
            if (!collection.contains(object.getKey())) continue;
            hashMultimap.put(object.getKey(), object);
        }
        ArrayList arrayList = new ArrayList(hashMultimap.size());
        for (Key key : collection) {
            arrayList.addAll(hashMultimap.get((Object)key));
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public boolean isError() {
        return this.validatorErrors != null && this.validatorErrors.size() > 0;
    }

    private void ensureValidatorErrorsMap() {
        if (this.validatorErrors == null) {
            this.validatorErrors = LinkedListMultimap.create();
        }
    }

    public synchronized void addValidator(Validator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList<Validator>();
        }
        this.validators.add(validator);
        this.ensureValidatorErrorsMap();
    }

    public synchronized void addValidator(Key<?> key, Validator validator) {
        if (this.keyValidators == null) {
            this.keyValidators = LinkedListMultimap.create();
        }
        this.keyValidators.put(key, (Object)validator);
        this.ensureValidatorErrorsMap();
    }

    public synchronized void removeValidator(Validator validator) {
        if (this.validators != null) {
            this.validators.remove(validator);
        }
    }

    public synchronized void removeValidator(Key<?> key, Validator validator) {
        if (this.keyValidators != null) {
            this.keyValidators.remove(key, (Object)validator);
        }
    }

    public synchronized void addError(Validator validator, ValueError valueError) {
        this.ensureValidatorErrorsMap();
        this.validatorErrors.put((Object)validator, (Object)valueError);
    }

    public synchronized void addAllErrors(Validator validator, List<ValueError> list) {
        if (list != null && !list.isEmpty()) {
            this.ensureValidatorErrorsMap();
            this.validatorErrors.putAll((Object)validator, list);
        }
    }

    public synchronized List<ValueError> getErrors(Validator validator) {
        if (this.validatorErrors != null) {
            return this.validatorErrors.get((Object)validator);
        }
        return null;
    }
}

