/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.resource.Messages;
import java.util.Comparator;
import java.util.List;

public interface ValueError {
    public static final int ERROR = 4;
    public static final int WARNING = 3;
    public static final int NOTICE = 2;
    public static final int INFO = 1;
    public static final int ALL = 0;
    public static final Comparator<ValueError> LEVEL_COMPARATOR = new Comparator<ValueError>(){

        @Override
        public int compare(ValueError valueError, ValueError valueError2) {
            return Integer.compare(valueError2.getLevel(), valueError.getLevel());
        }
    };

    public int getLevel();

    public String getMessage(boolean var1, boolean var2);

    public Key<?> getKey();

    public boolean isContainer();

    public List<ValueError> getChildren();

    public ValueError getParent();

    public void setParent(ValueError var1);

    public boolean isHighPriority();

    default public boolean isError() {
        return this.getLevel() == 4;
    }

    default public boolean isWarning() {
        return this.getLevel() == 3;
    }

    default public Key<?> getParentKey() {
        Key<?> key = this.getKey();
        for (ValueError valueError = this.getParent(); valueError != null; valueError = valueError.getParent()) {
            Key<?> key2 = valueError.getKey();
            if (key2 == null) continue;
            key = key2;
        }
        return key;
    }

    default public String getLevelName() {
        switch (this.getLevel()) {
            case 4: {
                return Messages.getString("Error.title.error");
            }
            case 3: {
                return Messages.getString("Error.title.warning");
            }
        }
        return Messages.getString("Message.log.info");
    }
}

