/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.AutoValueLink;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.KeyWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.MutableValue;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValidationContext;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.common.xml.XmlElement;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.core.util.Yamlable;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.ChangeEventSupport;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ValueMap
extends EventSupport<ValueChangeEvent, ValueChangeEventHandler>
implements XmlElement,
MutableValue,
Yamlable {
    private static final Logger LOGGER = Logger.getLogger(ValueMap.class.getName());
    private LinkedHashMap<Key<?>, Object> map = new LinkedHashMap();
    private ChangeEventSupport changeEventSupport;
    private Map<Key<?>, ChangeEventHandler> changeEventHandlers;
    private boolean lock;
    private ValidationContext validationContext;
    private Deque<Key<?>> linkedKeys;
    private Deque<Key<?>> dynamicDefaultKeys;
    private Object valueParent;
    private Set<String> lookUpKeys;
    private boolean stopValidation;
    protected Map<?, ?> unknownYamlEntries;

    public ValueMap() {
    }

    protected ValueMap(ValueMap valueMap) {
        if (valueMap != null) {
            this.copyValues(valueMap);
        }
        this.initValueMap();
    }

    public void initValueMap() {
    }

    public void copyValues(ValueMap valueMap) {
        for (Map.Entry<Key<?>, Object> entry : valueMap.map.entrySet()) {
            Key<?> key = entry.getKey();
            Object object = entry.getValue();
            object = object == null ? null : key.copyValue(object);
            this.putValue(key, object, true);
        }
        if (valueMap.lookUpKeys != null) {
            this.lookUpKeys = new HashSet<String>(valueMap.lookUpKeys);
        }
        if (valueMap.linkedKeys != null) {
            this.linkedKeys = new ArrayDeque(valueMap.linkedKeys);
        }
    }

    public void lock() {
        this.lock = true;
    }

    private void checkLock() {
        if (this.lock) {
            throw new UnsupportedOperationException("this object is locked.");
        }
    }

    public Key<?> getKey(String string) {
        if (this.lookUpKeys != null && this.lookUpKeys.contains(string)) {
            return this.getKeyLookup(string);
        }
        return this.getKeyInternal(string);
    }

    private Key<?> getKeyInternal(String string) {
        for (Key<?> key : this.keySet()) {
            if (!key.getId().equals(string)) continue;
            return key;
        }
        return null;
    }

    protected Key<?> getKeyLookup(String string) {
        Object object = this;
        while (object instanceof MutableValue) {
            Key<?> key;
            if (object instanceof ValueMap && (key = ((ValueMap)object).getKeyInternal(string)) != null) {
                return key;
            }
            object = ((MutableValue)object).getValueParent();
        }
        return null;
    }

    protected void registerAllKeys() {
        this.registerAllKeys(this.getClass());
    }

    protected void registerAllKeys(Class<?> clazz) {
        Key[] keyArray = (Key[])Arrays.stream(clazz.getDeclaredFields()).filter(field -> Key.class.isAssignableFrom(field.getType())).map(field -> {
            try {
                field.setAccessible(true);
                return (Key)field.get(Modifier.isStatic(field.getModifiers()) ? null : this);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Failed to register key:" + field.getName(), exception);
                return null;
            }
        }).filter(key -> key != null && !key.isNoRegister()).toArray(Key[]::new);
        this.registerKeys(keyArray);
    }

    protected void registerKeys(Key<?> ... keyArray) {
        this.registerKeys(false, keyArray);
    }

    protected void registerKeys(boolean bl, Key<?> ... keyArray) {
        this.checkLock();
        for (Key<?> boolKey : keyArray) {
            if (boolKey == null) continue;
            if (!bl && this.map.containsKey(boolKey)) {
                LOGGER.warning("Tried to register duplicate key. class:" + String.valueOf(this.getClass()) + " key:" + boolKey.getId());
                continue;
            }
            this.map.put(boolKey, null);
            if (boolKey.getAutoValueLink() != null) {
                BoolKey boolKey2 = boolKey.getAutoValueLinkKey();
                if (!this.map.containsKey(boolKey2)) {
                    this.map.put(boolKey2, null);
                }
                if (this.linkedKeys == null) {
                    this.linkedKeys = new ArrayDeque();
                }
                this.linkedKeys.addLast(boolKey);
            }
            if (!boolKey.isDynamicDefault()) continue;
            if (this.dynamicDefaultKeys == null) {
                this.dynamicDefaultKeys = new ArrayDeque();
            }
            this.dynamicDefaultKeys.addLast(boolKey);
        }
        if (this.linkedKeys != null) {
            for (Key key : this.linkedKeys) {
                AutoValueLink autoValueLink = key.getAutoValueLink();
                BoolKey boolKey = autoValueLink.getSaveKey(key);
                if (!this.getValue(boolKey).booleanValue()) continue;
                this.putAutoValueQuietly(key);
            }
        }
    }

    public Key<?>[] keys() {
        return this.map.keySet().toArray(new Key[this.map.size()]);
    }

    public Iterator<Key<?>> keyIterator() {
        return this.map.keySet().iterator();
    }

    protected Set<Key<?>> keySet() {
        return this.map.keySet();
    }

    protected Set<Map.Entry<Key<?>, Object>> entrySet() {
        return this.map.entrySet();
    }

    public Object getValue(String string) {
        return this.getValue(this.getKey(string));
    }

    public String getStrValue(String string) {
        Object object = this.getValue(string);
        return object == null ? null : object.toString();
    }

    public <V> V getValue(Key<V> key) {
        if (this.lookUpKeys != null && this.lookUpKeys.contains(key.getId())) {
            return (V)this.getValueLookUp(key.getId());
        }
        Object object = this.map.get(key);
        if (object == null) {
            V v = key.getDefaultValue();
            this.putValueQuietly(key, v);
            return v;
        }
        return (V)object;
    }

    public <V> V getValue(Key<V> key, V v) {
        return this.isEnabled(key) ? this.getValue(key) : v;
    }

    public Object getValueLookUp(String string) {
        Object object = this;
        while (object instanceof MutableValue) {
            Key<?> key;
            if (object instanceof ValueMap && (key = ((ValueMap)object).getKeyInternal(string)) != null) {
                return ((ValueMap)object).getValue(key);
            }
            object = ((MutableValue)object).getValueParent();
        }
        return null;
    }

    public boolean isDefault(Key<?> key) {
        Object object = this.map.get(key);
        return object == null || Objects.equals(object, key.getDefaultValue());
    }

    public <V> V getValueOrDefault(Key<V> key) {
        if (!key.isDynamicDefault()) {
            return this.getValue(key);
        }
        Object object = this.map.get(key);
        if (object == null || Objects.equals(object, key.getDefaultValue())) {
            return (V)this.getDynamicDefaultValue(key);
        }
        return (V)object;
    }

    public Object getDynamicDefaultValue(Key<?> key) {
        return key.getDefaultValue();
    }

    public Object getAutoValue(Key<?> key) {
        return null;
    }

    public Object getDynamicDefaultValue(KeysTableModel keysTableModel, int n, Key<?> key) {
        return null;
    }

    public void putAutoValue(Key<?> key) {
        Object object = this.getAutoValue(key);
        if (object != null) {
            this.putValue(key, object);
        }
    }

    public void putAutoValueQuietly(Key<?> key) {
        Object object = this.getAutoValue(key);
        if (object != null) {
            this.putValue(key, object, true);
        }
    }

    public <V> V putValue(Key<V> key, Object object) {
        return this.putValue(key, object, false);
    }

    public <V> V putValueQuietly(Key<V> key, Object object) {
        return this.putValue(key, object, true);
    }

    public <V> V putValue(Key<V> key, Object object, boolean bl) {
        Object object2;
        this.checkLock();
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Object object3 = this.map.put(key, object);
        if (Objects.equals(object, object3)) {
            return (V)object3;
        }
        if (!bl) {
            if (this.isValidationEnabled() && !this.stopValidation) {
                this.getValidationContext().validate(this, key);
                if (this.dynamicDefaultKeys != null) {
                    object2 = this.dynamicDefaultKeys.iterator();
                    while (object2.hasNext()) {
                        Key key2 = (Key)object2.next();
                        this.getValidationContext().validate(this, key2);
                    }
                }
            }
            this.dispatchEvent(new ValueChangeEvent(key, object3, this));
        }
        if (object instanceof MutableValue) {
            if (this.changeEventHandlers == null) {
                this.changeEventHandlers = new HashMap();
            }
            if ((object2 = this.changeEventHandlers.get(key)) == null) {
                object2 = new MutableValueChangeEventHandler(key);
                this.changeEventHandlers.put(key, (ChangeEventHandler)object2);
            }
            ((MutableValue)object).addChangeEventHandler((ChangeEventHandler)object2);
            ((MutableValue)object).setValueParent(this);
        }
        if (object3 instanceof MutableValue) {
            if (this.changeEventHandlers != null && (object2 = this.changeEventHandlers.get(key)) != null) {
                ((MutableValue)object3).removeChangeEventHandler((ChangeEventHandler)object2);
            }
            ((MutableValue)object3).setValueParent(null);
        }
        return (V)object3;
    }

    public void putValues(ValueMap valueMap) {
        for (Key<?> key : valueMap.keySet()) {
            this.putValue(key, valueMap.getValue(key));
        }
    }

    public boolean contains(Key<?> key) {
        return this.map.get(key) != null;
    }

    public boolean isEmpty() {
        for (Key<?> key : this.keySet()) {
            if (!this.isEnabled(key) || Objects.equals(this.getValue(key), key.getDefaultValue())) continue;
            return false;
        }
        return true;
    }

    public boolean isStringEmpty(Key<?> key) {
        Object obj = this.getValue(key);
        if (obj == null) {
            return true;
        }
        return obj.toString().isEmpty();
    }

    public boolean isEnabled(Key<?> key) {
        Function<ValueMap, Boolean> function = key.getEnabledFunction();
        if (function != null) {
            return function.apply(this);
        }
        if (!key.isKeyLink()) {
            return true;
        }
        for (KeyLink keyLink : key.getKeyLinks()) {
            boolean bl = keyLink.accept(this);
            switch (keyLink.getType()) {
                case "VISIBLE_ON": 
                case "EDITABLE_ON": {
                    if (bl) break;
                    return false;
                }
                case "VISIBLE_OFF": 
                case "EDITABLE_OFF": {
                    if (!bl) break;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isSearchable(Key<?> key) {
        return key.isSearchable() && !key.isHidden() && this.isEnabled(key);
    }

    public void addLookUpKey(String string) {
        if (this.lookUpKeys == null) {
            this.lookUpKeys = new HashSet<String>(1);
        }
        this.lookUpKeys.add(string);
    }

    public void removeLookUpKey(String string) {
        if (this.lookUpKeys != null) {
            this.lookUpKeys.remove(string);
        }
    }

    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        PanelWidgetNode panelWidgetNode = new PanelWidgetNode();
        for (Key<?> key : this.map.keySet()) {
            panelWidgetNode.add(new KeyWidgetNode(key));
        }
        return panelWidgetNode;
    }

    public <V> boolean equals(Key<V> key, V v) {
        return this.getValue(key).equals(v);
    }

    public String getSubtitle(Key<?> key) {
        return key.getSubTitle();
    }

    @Override
    public void storeToElement(XmlContext xmlContext, Document document, Element element) {
        for (Key<?> key : this.keySet()) {
            Object obj;
            if (key.isNoSave() || !key.supportXmlEncoding() || (obj = this.getValue(key)) == null) continue;
            Element element2 = document.createElement("v");
            if (!key.getId().isEmpty()) {
                element2.setAttribute("key", key.getId());
            }
            key.valueToElement(document, element2, obj);
            element.appendChild(element2);
        }
    }

    public Element getElement(Document document, Element element, Key<?>[] keyArray) {
        for (Key<?> key : keyArray) {
            Object obj = this.getValue(key);
            if (obj == null) continue;
            Element element2 = document.createElement("v");
            if (!key.getId().isEmpty()) {
                element2.setAttribute("key", key.getId());
            }
            key.valueToElement(document, element2, obj);
            element.appendChild(element2);
        }
        return element;
    }

    private void checkSavedValues() {
        for (Key<?> key : this.keySet()) {
            Object object;
            Object obj;
            if (!key.isAutoValueLink() || !this.getValue(key.getAutoValueLinkKey()).booleanValue() || key.isNoSave() || key.getAutoValueLinkKey().isNoSave() || Objects.equals(obj = this.getValue(key), object = this.getAutoValue(key))) continue;
            this.putValueQuietly(key.getAutoValueLinkKey(), Boolean.FALSE);
        }
    }

    @Override
    public void loadElement(Element element, XmlContext xmlContext) {
        this.checkLock();
        for (Key<?> key : this.keySet()) {
            try {
                this.loadElement(element, key);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        this.checkSavedValues();
        this.initValueMap();
    }

    public void loadElement(Element element, Key<?>[] keyArray) {
        this.checkLock();
        for (Key<?> key : keyArray) {
            this.loadElement(element, key);
        }
    }

    private void loadElement(Element element, Key<?> key) {
        for (Element element2 : XmlUtility.getChildren("v", element)) {
            String string = element2.getAttribute("key");
            if (!key.getId().equals(string)) continue;
            this.putValueQuietly(key, key.elementToValue(element2));
            break;
        }
    }

    public Document createDocument(String string) {
        Document document = XmlUtility.createDocument();
        Element element = document.createElement(string);
        this.storeToElement(new XmlContext(), document, element);
        document.appendChild(element);
        return document;
    }

    public void storeToXml(File file, String string) throws IOException {
        XmlUtility.writeXml(file, this.createDocument(string));
    }

    public void loadFromXml(File file) throws IOException {
        Document document = XmlUtility.readXml(file);
        this.loadElement(document.getDocumentElement(), new XmlContext());
    }

    protected boolean keepUnknownYamlEntries() {
        return false;
    }

    @Override
    public Map<Object, Object> toYamlValue(YamlEx yamlEx) {
        return this.toYamlValue(yamlEx, false);
    }

    public Map<Object, Object> toYamlValue(YamlEx yamlEx, boolean bl) {
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
        for (Key<?> key : this.keySet()) {
            Object obj;
            if (key.isNoSave() || (obj = this.getValue(key)) == null) continue;
            linkedHashMap.put(bl ? key.getTitle() : key.getId(), key.valueToYamlValue(yamlEx, obj, bl));
        }
        if (this.keepUnknownYamlEntries() && this.unknownYamlEntries != null) {
            linkedHashMap.putAll(this.unknownYamlEntries);
        }
        return linkedHashMap;
    }

    public Map<Object, Object> toYamlValue(YamlEx yamlEx, Collection<Key<?>> collection) {
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
        for (Key<?> key : collection) {
            Object obj;
            if (key.isNoSave() || (obj = this.getValue(key)) == null) continue;
            linkedHashMap.put(key.getId(), key.valueToYamlValue(yamlEx, obj, false));
        }
        return linkedHashMap;
    }

    @Override
    public void loadYamlValue(YamlEx yamlEx, Object object) {
        this.checkLock();
        Map map = (Map)YamlEx.typeCheck(Map.class, object);
        for (Key<?> key : this.keySet()) {
            try {
                this.loadYamlValue(yamlEx, map, key);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Failed to read a entry from a yaml file. key: " + key.getId(), exception);
            }
        }
        if (this.keepUnknownYamlEntries()) {
            for (Key<?> key : this.keySet()) {
                map.remove(key.getId());
            }
            if (!map.isEmpty()) {
                this.unknownYamlEntries = map;
            }
        }
        this.checkSavedValues();
        this.initValueMap();
    }

    private void loadYamlValue(YamlEx yamlEx, Map<?, ?> map, Key<?> key) throws Exception {
        Object obj = map.get(key.getId());
        if (obj != null) {
            this.putValueQuietly(key, key.yamlValueToValue(yamlEx, obj));
        }
    }

    public String getYamlSummary() {
        YamlEx yamlEx = new YamlEx();
        Map<Object, Object> map = this.toYamlValue(yamlEx, true);
        StringWriter stringWriter = new StringWriter();
        yamlEx.dump(map, stringWriter);
        return stringWriter.toString().trim();
    }

    public void storeToYaml(File file) throws IOException {
        YamlEx yamlEx = new YamlEx();
        yamlEx.dump(file, this.toYamlValue(yamlEx));
    }

    public void loadFromYaml(File file) throws IOException {
        YamlEx yamlEx = new YamlEx();
        this.loadYamlValue(yamlEx, yamlEx.load(file));
    }

    public ValueMap copy() {
        ValueMap valueMap;
        try {
            valueMap = (ValueMap)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to copy : default constructor is required.");
        }
        valueMap.copyValues(this);
        return valueMap;
    }

    public void doAction(WidgetNode widgetNode, String string) {
    }

    public boolean isValidationEnabled() {
        return false;
    }

    public void setStopValidation(boolean bl) {
        this.stopValidation = bl;
    }

    public ValidationContext getValidationContext() {
        if (this.validationContext == null) {
            this.validationContext = new ValidationContext();
            this.configureValidationContext(this.validationContext);
            this.validationContext.init(this);
        }
        return this.validationContext;
    }

    protected void configureValidationContext(ValidationContext validationContext) {
    }

    public void validate(Key<?> key) {
        this.getValidationContext().validate(this, key);
    }

    protected void processValueChanged(ValueChangeEvent valueChangeEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(ValueChangeEvent valueChangeEvent) {
        this.beginValueChange();
        try {
            this.processValueChanged(valueChangeEvent);
            super.dispatchEvent(valueChangeEvent);
            if (this.linkedKeys != null) {
                for (Key<?> key : this.linkedKeys) {
                    AutoValueLink autoValueLink = key.getAutoValueLink();
                    BoolKey boolKey = autoValueLink.getSaveKey(key);
                    Key<?> key2 = valueChangeEvent.getKey();
                    if (!this.getValue(boolKey).booleanValue() || !key2.equals(boolKey) && !autoValueLink.isLinked(key2.getId())) continue;
                    this.putAutoValue(key);
                }
            }
            if (this.changeEventSupport != null) {
                this.changeEventSupport.dispatchEvent();
            }
        }
        finally {
            this.endValueChange();
        }
    }

    private void createChangeEventSupport() {
        if (this.changeEventSupport == null) {
            this.changeEventSupport = new ChangeEventSupport(this);
        }
    }

    @Override
    public void addChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.createChangeEventSupport();
        this.changeEventSupport.addEventHandler(changeEventHandler);
    }

    @Override
    public void removeChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.createChangeEventSupport();
        this.changeEventSupport.removeEventHandler(changeEventHandler);
    }

    @Override
    public boolean containsChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.createChangeEventSupport();
        return this.changeEventSupport.containsEventHandler(changeEventHandler);
    }

    @Override
    public void beginValueChange() {
        this.createChangeEventSupport();
        this.changeEventSupport.beginChange();
    }

    @Override
    public void endValueChange() {
        this.createChangeEventSupport();
        this.changeEventSupport.endChange();
    }

    @Override
    public Object getValueParent() {
        return this.valueParent;
    }

    @Override
    public void setValueParent(Object object) {
        this.valueParent = object;
    }

    private class MutableValueChangeEventHandler
    implements ChangeEventHandler {
        private Key<?> key;

        public MutableValueChangeEventHandler(Key<?> key) {
            this.key = key;
        }

        @Override
        public void handleChanged(ChangeEvent changeEvent) {
            if (ValueMap.this.isValidationEnabled() && !ValueMap.this.stopValidation) {
                ValueMap.this.getValidationContext().validate(ValueMap.this, this.key);
                if (ValueMap.this.dynamicDefaultKeys != null) {
                    for (Key<?> key : ValueMap.this.dynamicDefaultKeys) {
                        ValueMap.this.getValidationContext().validate(ValueMap.this, key);
                    }
                }
            }
            ValueMap.this.dispatchEvent(new ValueChangeEvent(this.key, changeEvent.getSource(), ValueMap.this));
        }
    }
}

