/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.NonAtomicKey;
import com.ef_prime.rflow.core.common.keyvalue.ValidationContext;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.node.ui.OpManager;
import com.ef_prime.rflow.node.ui.Operation;
import com.google.common.collect.HashBiMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ValueMapKey
extends NonAtomicKey<ValueMap> {
    private static final Logger LOGGER = Logger.getLogger(ValueMapKey.class.getName());
    private LinkedHashMap<String, String> classMap;
    private Map<String, String> inverseClassMap;

    public ValueMapKey(String string, String string2, ValueMap valueMap) {
        super(string, string2, valueMap);
    }

    protected ValueMapKey(Builder<?> builder) {
        super(builder);
        if (builder.classes != null && builder.classes.size() > 0) {
            this.classMap = new LinkedHashMap<String, String>(builder.classes);
        }
    }

    public Map<String, String> getClassMap() {
        return this.classMap;
    }

    @Override
    public boolean isValueEmpty(ValueMap valueMap) {
        return valueMap.isEmpty();
    }

    @Override
    protected void validate(ValueMap valueMap, ValidationContext validationContext) {
        ValidationContext validationContext2;
        super.validate(valueMap, validationContext);
        if (valueMap != null && (validationContext2 = valueMap.getValidationContext()).isError()) {
            validationContext.addAllErrors(this, validationContext2.getAllErrors(0));
        }
    }

    @Override
    public void valueToElement(Document document, Element element, Object object) {
        ((ValueMap)object).storeToElement(null, document, element);
        if (this.classMap != null) {
            if (this.inverseClassMap == null) {
                this.inverseClassMap = HashBiMap.create(this.classMap).inverse();
            }
            String string = this.inverseClassMap.get(object.getClass().getName());
            element.setAttribute("type", string);
        }
    }

    @Override
    public Object elementToValue(Element element) {
        try {
            ValueMap valueMap = null;
            if (this.classMap == null) {
                ValueMap valueMap2 = (ValueMap)this.getDefaultValue();
                if (valueMap2 instanceof Operation) {
                    valueMap = OpManager.getInstance().getInstance(((Operation)valueMap2).getId());
                }
                if (valueMap == null) {
                    valueMap = valueMap2.copy();
                }
            } else {
                String string = element.getAttribute("type");
                String string2 = this.classMap.get(string);
                valueMap = OpManager.getInstance().getInstance(string2);
                if (valueMap == null) {
                    valueMap = (ValueMap)Class.forName(string2).newInstance();
                }
            }
            valueMap.loadElement(element, (XmlContext)null);
            return valueMap;
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to create class: " + String.valueOf(((ValueMap)this.getDefaultValue()).getClass()), element);
            return null;
        }
    }

    @Override
    public Object valueToYamlValue(YamlEx yamlEx, Object object, boolean bl) {
        Object object2 = ((ValueMap)object).toYamlValue(yamlEx);
        if (this.classMap == null) {
            return object2;
        }
        if (this.inverseClassMap == null) {
            this.inverseClassMap = HashBiMap.create(this.classMap).inverse();
        }
        String string = this.inverseClassMap.get(object.getClass().getName());
        return YamlEx.yamlValueWithType(string, object2);
    }

    @Override
    public Object yamlValueToValue(YamlEx yamlEx, Object object) {
        ValueMap valueMap = null;
        try {
            if (this.classMap == null) {
                ValueMap valueMap2 = (ValueMap)this.getDefaultValue();
                if (valueMap2 instanceof Operation) {
                    valueMap = OpManager.getInstance().getInstance(((Operation)valueMap2).getId());
                }
                if (valueMap == null) {
                    valueMap = valueMap2.copy();
                }
            } else {
                String string = YamlEx.typeInYamlValue(object);
                String string2 = this.classMap.get(string);
                valueMap = OpManager.getInstance().getInstance(string2);
                if (valueMap == null) {
                    valueMap = (ValueMap)Class.forName(string2).newInstance();
                }
                object = YamlEx.valueInYamlValue(object);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        valueMap.loadYamlValue(yamlEx, object);
        return valueMap;
    }

    @Override
    public ValueMap copyValue(ValueMap valueMap) {
        return valueMap.copy();
    }

    @Override
    public Class<?> getJavaClass() {
        return ValueMap.class;
    }

    public static Builder<?> builder(String string, String string2, Object object) {
        return new Builder2(string, string2, object);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Key.Builder<ValueMap, T> {
        private Map<String, String> classes;

        public Builder(String string, String string2, Object object) {
            super(string, string2);
            this.setDefaultValue(object);
        }

        @Override
        protected abstract T self();

        public ValueMapKey build() {
            return new ValueMapKey(this);
        }

        public T addClass(String string, Class<?> clazz) {
            return this.addClass(string, clazz.getName());
        }

        public T addClass(String string, String string2) {
            if (this.classes == null) {
                this.classes = new LinkedHashMap<String, String>();
            }
            this.classes.put(string, string2);
            return (T)this.self();
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        public Builder2(String string, String string2, Object object) {
            super(string, string2, object);
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

