/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ValueMapKey;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class VariousInput
extends ValueMap {
    public VariousInput() {
    }

    public VariousInput(Key<?> ... keyArray) {
        for (Key<?> key : keyArray) {
            if (key instanceof StrKey || key instanceof ValueMapKey) continue;
            throw new IllegalArgumentException("key must be StrKey or ValueMapKey");
        }
        this.registerKeys(keyArray);
        this.init();
    }

    private void init() {
        Key<?> key = this.keySet().iterator().next();
        for (Key<?> key2 : this.keySet()) {
            if (key2 == key) {
                this.putValue(key, key.getDefaultValue());
                continue;
            }
            this.putValue(key2, null);
        }
    }

    public Key<?> getSelectedKey() {
        for (Map.Entry<Key<?>, Object> entry : this.entrySet()) {
            if (entry.getValue() == null) continue;
            return entry.getKey();
        }
        this.init();
        return this.keySet().iterator().next();
    }

    public Object getSelectedValue() {
        for (Map.Entry<Key<?>, Object> entry : this.entrySet()) {
            if (entry.getValue() == null) continue;
            return entry.getValue();
        }
        this.init();
        return this.getValue(this.keySet().iterator().next());
    }

    public String getSelectedKeyString() {
        return this.getSelectedKey().getId();
    }

    @Override
    public boolean isEmpty() {
        if (this.isStringValue()) {
            return StringUtils.isEmpty((CharSequence)((String)this.getSelectedValue()));
        }
        ValueMap valueMap = (ValueMap)this.getSelectedValue();
        if (valueMap == null) {
            return true;
        }
        return StringUtils.isEmpty((CharSequence)valueMap.toString());
    }

    public void switchValueTo(Key<?> key) {
        Key<?> key2 = this.getSelectedKey();
        if (key2.equals(key)) {
            return;
        }
        if (key instanceof StrKey) {
            this.setSelectedValue(key, this.getSelectedValue().toString());
        } else {
            this.setSelectedValue(key, key.getDefaultValue());
        }
    }

    public void setSelectedValue(Key<?> key, Object object) {
        Set<Key<?>> set = this.keySet();
        for (Key<?> key2 : set) {
            if (key2.equals(key)) {
                this.putValue(key2, object);
                continue;
            }
            this.putValue(key2, null);
        }
    }

    public boolean isStringValue() {
        return this.getSelectedKey() instanceof StrKey;
    }

    public void clear() {
        this.init();
    }

    public String toString() {
        return this.getSelectedValue().toString();
    }
}

