/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.KeyWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class WidgetNode
implements Iterable<WidgetNode> {
    private WidgetNode parent;
    private List<WidgetNode> children;
    private List<ValueChangeEventHandler> valueChangeEventHandlers;
    private List<KeyLink> keyLinks;
    private boolean autoUpdate = true;
    private boolean growY;
    private String labelPosition;
    private ValueMap properties;

    public boolean isWidget() {
        return true;
    }

    public boolean isGrowY() {
        if (this.growY) {
            return true;
        }
        if (this.children != null) {
            for (WidgetNode widgetNode : this.children) {
                if (!widgetNode.isGrowY()) continue;
                return true;
            }
        }
        return false;
    }

    public WidgetNode setGrowY(boolean bl) {
        this.growY = bl;
        return this;
    }

    public int getHeight() {
        return 0;
    }

    public boolean isGrowX() {
        return true;
    }

    public int getMinWidth() {
        return 0;
    }

    public int getWidth() {
        return -1;
    }

    public String getLabelPosition() {
        return this.labelPosition;
    }

    public WidgetNode setLabelPosition(String string) {
        this.labelPosition = string;
        return this;
    }

    public void setParent(WidgetNode widgetNode) {
        this.parent = widgetNode;
    }

    public WidgetNode getParent() {
        return this.parent;
    }

    public WidgetNode getRoot() {
        WidgetNode widgetNode = this;
        for (WidgetNode widgetNode2 = widgetNode.getParent(); widgetNode2 != null; widgetNode2 = widgetNode2.getParent()) {
            widgetNode = widgetNode2;
        }
        return widgetNode;
    }

    public WidgetNode add(WidgetNode widgetNode) {
        if (this.children == null) {
            this.children = new ArrayList<WidgetNode>();
        }
        this.children.add(widgetNode);
        widgetNode.setParent(this);
        return this;
    }

    public WidgetNode addKeys(Key<?> ... keyArray) {
        for (Key<?> key : keyArray) {
            this.add(new KeyWidgetNode(key));
        }
        return this;
    }

    public WidgetNode addElements(Object ... objectArray) {
        for (Object object : objectArray) {
            if (object instanceof Key) {
                this.add(new KeyWidgetNode((Key)object));
                continue;
            }
            if (!(object instanceof WidgetNode)) continue;
            this.add((WidgetNode)object);
        }
        return this;
    }

    public WidgetNode addIterableElements(Iterable<?> iterable) {
        for (Object obj : iterable) {
            if (obj instanceof Key) {
                this.add(new KeyWidgetNode((Key)obj));
                continue;
            }
            if (!(obj instanceof WidgetNode)) continue;
            this.add((WidgetNode)obj);
        }
        return this;
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public WidgetNode getChildAt(int n) {
        if (this.children == null || n < 0 || n >= this.children.size()) {
            return null;
        }
        return this.children.get(n);
    }

    public boolean isValueChangeEventHandler() {
        return this.valueChangeEventHandlers != null && !this.valueChangeEventHandlers.isEmpty();
    }

    public List<ValueChangeEventHandler> getValueChangeEventHandlers() {
        if (this.valueChangeEventHandlers == null) {
            return new ArrayList<ValueChangeEventHandler>();
        }
        return this.valueChangeEventHandlers;
    }

    public void addValueChangeEventHandler(ValueChangeEventHandler valueChangeEventHandler) {
        if (this.valueChangeEventHandlers == null) {
            this.valueChangeEventHandlers = new ArrayList<ValueChangeEventHandler>();
        }
        this.valueChangeEventHandlers.add(valueChangeEventHandler);
    }

    public boolean isKeyLink() {
        return this.keyLinks != null && !this.keyLinks.isEmpty();
    }

    public List<KeyLink> getKeyLinks() {
        if (this.keyLinks == null) {
            return new ArrayList<KeyLink>();
        }
        return this.keyLinks;
    }

    public boolean controlsKeyLink() {
        return false;
    }

    public WidgetNode addVisibleKeyLink(StrKey strKey, String ... stringArray) {
        return this.addKeyLink(KeyLink.visible(StrKeyTest.create(strKey, stringArray)));
    }

    public WidgetNode addVisibleKeyLink(BoolKey boolKey, boolean bl) {
        return this.addKeyLink(KeyLink.visible(BoolKeyTest.create(boolKey, bl)));
    }

    public WidgetNode addKeyLink(StrKey strKey, String string, String ... stringArray) {
        return this.addKeyLink(new KeyLink(string, StrKeyTest.create(strKey, stringArray)));
    }

    public WidgetNode addKeyLink(BoolKey boolKey, String string, boolean bl) {
        return this.addKeyLink(new KeyLink(string, BoolKeyTest.create(boolKey, bl)));
    }

    public WidgetNode addKeyLink(KeyLink keyLink) {
        if (this.keyLinks == null) {
            this.keyLinks = new ArrayList<KeyLink>();
        }
        this.keyLinks.add(keyLink);
        return this;
    }

    public WidgetNode addKeyLinks(List<KeyLink> list) {
        if (list != null) {
            for (KeyLink keyLink : list) {
                this.addKeyLink(keyLink);
            }
        }
        return this;
    }

    public WidgetNode setAutoUpdate(boolean bl) {
        this.autoUpdate = bl;
        return this;
    }

    public boolean isAutoUpdate() {
        for (WidgetNode widgetNode = this; widgetNode != null; widgetNode = widgetNode.getParent()) {
            if (!widgetNode.autoUpdate) continue;
            return true;
        }
        return false;
    }

    public void localize(Map<String, String> map) {
        if (this.children != null) {
            for (WidgetNode widgetNode : this.children) {
                widgetNode.localize(map);
            }
        }
    }

    public void localizationValues(List<String> list) {
        if (this.children != null) {
            for (WidgetNode widgetNode : this.children) {
                widgetNode.localizationValues(list);
            }
        }
    }

    protected static String valueOrDefault(Map<String, String> map, String string) {
        String string2 = map.get(string);
        return string2 == null ? string : string2;
    }

    public <V> WidgetNode setProperty(Key<V> key, V v) {
        if (this.properties == null) {
            this.properties = new ValueMap();
        }
        this.properties.putValue(key, v);
        return this;
    }

    public <V> WidgetNode setProperties(ValueMap valueMap) {
        if (this.properties == null) {
            this.properties = new ValueMap();
        }
        this.properties.putValues(valueMap);
        return this;
    }

    public <V> V getProperty(Key<V> key) {
        if (this.properties == null) {
            return key.getDefaultValue();
        }
        return this.properties.getValue(key);
    }

    @Override
    public Iterator<WidgetNode> iterator() {
        return new WidgetNodeIterator(this);
    }

    public Iterator<WidgetNode> treeIterator() {
        return new WidgetNodeTreeIterator(this);
    }

    private static class WidgetNodeIterator
    implements Iterator<WidgetNode> {
        private WidgetNode node;
        private int index = 0;

        public WidgetNodeIterator(WidgetNode widgetNode) {
            this.node = widgetNode;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.node.getChildCount();
        }

        @Override
        public WidgetNode next() {
            WidgetNode widgetNode = this.node.getChildAt(this.index);
            ++this.index;
            return widgetNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class WidgetNodeTreeIterator
    implements Iterator<WidgetNode> {
        private Deque<WidgetNode> stack = new ArrayDeque<WidgetNode>();

        public WidgetNodeTreeIterator(WidgetNode widgetNode) {
            this.stack.add(widgetNode);
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public WidgetNode next() {
            WidgetNode widgetNode = this.stack.removeLast();
            for (int i = widgetNode.getChildCount() - 1; i >= 0; --i) {
                this.stack.addLast(widgetNode.getChildAt(i));
            }
            return widgetNode;
        }
    }
}

