/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.NonAtomicKey;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.core.util.Yamlable;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class YamlableKey
extends NonAtomicKey<Yamlable> {
    private BiMap<String, String> classMap;
    private String defaultClass;

    public YamlableKey(String string, Yamlable yamlable) {
        super(string, yamlable);
    }

    protected YamlableKey(Builder<?> builder) {
        super(builder);
        this.defaultClass = builder.defaultClass;
        if (builder.classes != null && builder.classes.size() > 0) {
            this.classMap = HashBiMap.create(builder.classes);
        }
    }

    @Override
    public Yamlable copyValue(Yamlable yamlable) {
        return yamlable;
    }

    @Override
    public void valueToElement(Document document, Element element, Object object) {
    }

    @Override
    public Object elementToValue(Element element) {
        return null;
    }

    @Override
    public Object valueToYamlValue(YamlEx yamlEx, Object object, boolean bl) {
        Object object2 = ((Yamlable)object).toYamlValue(yamlEx);
        if (this.classMap == null) {
            return object2;
        }
        String string = (String)this.classMap.inverse().get((Object)object.getClass().getName());
        return YamlEx.yamlValueWithType(string, object2);
    }

    @Override
    public Object yamlValueToValue(YamlEx yamlEx, Object object) {
        Yamlable yamlable = null;
        try {
            if (this.classMap == null) {
                yamlable = (Yamlable)((Yamlable)this.getDefaultValue()).getClass().newInstance();
            } else {
                String string = YamlEx.typeInYamlValue(object);
                String string2 = this.defaultClass;
                if (!StringUtils.isEmpty((CharSequence)string)) {
                    string2 = (String)this.classMap.get((Object)string);
                }
                yamlable = (Yamlable)Class.forName(string2).newInstance();
                object = YamlEx.valueInYamlValue(object);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        yamlable.loadYamlValue(yamlEx, object);
        return yamlable;
    }

    @Override
    public Class<?> getJavaClass() {
        return Yamlable.class;
    }

    public static Builder<?> builder(String string, String string2, Object object) {
        return new Builder2(string, string2, object);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Key.Builder<Yamlable, T> {
        private Map<String, String> classes;
        private String defaultClass;

        public Builder(String string, String string2, Object object) {
            super(string, string2);
            this.setDefaultValue(object);
        }

        @Override
        protected abstract T self();

        public YamlableKey build() {
            return new YamlableKey(this);
        }

        public T addClass(String string, Class<?> clazz) {
            return this.addClass(string, clazz.getName());
        }

        public T addClass(String string, String string2) {
            if (this.classes == null) {
                this.classes = new HashMap<String, String>();
            }
            this.classes.put(string, string2);
            return (T)this.self();
        }

        public T setDefaultClass(Class<?> clazz) {
            return this.setDefaultClass(clazz.getName());
        }

        public T setDefaultClass(String string) {
            this.defaultClass = string;
            return (T)this.self();
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        public Builder2(String string, String string2, Object object) {
            super(string, string2, object);
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

