/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.list;

import com.ef_prime.rflow.core.common.list.GeneralSelectionListEvent;
import com.ef_prime.rflow.core.common.list.GeneralSelectionListEventHandler;
import com.ef_prime.rflow.core.common.list.GeneralSelectionListModel;
import com.ef_prime.rflow.core.common.list.ListEvent;
import com.ef_prime.rflow.core.common.list.ListEventHandler;
import com.ef_prime.rflow.core.common.list.ListModel;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractGeneralSelectionListModel<T>
implements GeneralSelectionListModel<T> {
    private int[] selections;
    private EventSupport<GeneralSelectionListEvent, GeneralSelectionListEventHandler> observable = new EventSupport();

    public AbstractGeneralSelectionListModel() {
        this(null);
    }

    public AbstractGeneralSelectionListModel(int n) {
        this(new int[]{n});
    }

    public AbstractGeneralSelectionListModel(int[] nArray) {
        if (nArray != null) {
            this.selections = (int[])nArray.clone();
        }
    }

    protected abstract ListModel<T> getListModel();

    @Override
    public boolean isSelectionEmpty() {
        return ArrayUtils.isEmpty((int[])this.selections);
    }

    @Override
    public void clearSelection() {
        this.setSelectedIndices(null);
    }

    @Override
    public int getSelectedIndex() {
        if (this.isSelectionEmpty()) {
            return -1;
        }
        return this.selections[0];
    }

    @Override
    public int[] getSelectedIndices() {
        if (this.isSelectionEmpty()) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        return (int[])this.selections.clone();
    }

    @Override
    public T getSelectedItem() {
        if (this.isSelectionEmpty()) {
            return null;
        }
        return (T)this.getListModel().get(this.selections[0]);
    }

    @Override
    public T[] getSelectedItems() {
        if (this.isSelectionEmpty()) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (int n : this.selections) {
            arrayList.add(this.getListModel().get(n));
        }
        return arrayList.toArray();
    }

    @Override
    public void setSelectedIndex(int n) {
        this.setSelectedIndices(new int[]{n});
    }

    @Override
    public void setSelectedIndices(int[] nArray) {
        if (this.isSelectionEmpty() && ArrayUtils.isEmpty((int[])nArray)) {
            return;
        }
        if (!ArrayUtils.isEmpty((int[])nArray) && this.isSingleSelectionMode() && nArray.length > 1) {
            nArray = new int[]{nArray[0]};
        }
        if (ArrayUtils.isEquals((Object)this.selections, (Object)nArray)) {
            return;
        }
        this.selections = nArray;
        this.dispatchEvent(new GeneralSelectionListEvent(this));
    }

    @Override
    public void setSelectedItem(T t) {
        this.setSelectedItems(ArrayUtils.toArray((Object[])new Object[]{t}));
    }

    @Override
    public void setSelectedItems(T[] TArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (T t : TArray) {
            int n = this.getListModel().indexOf(t);
            if (n <= 0) continue;
            arrayList.add(n);
        }
        this.setSelectedIndices(ArrayUtils.toPrimitive((Integer[])arrayList.toArray(new Integer[0])));
    }

    @Override
    public boolean isSelected(int n) {
        if (this.isSelectionEmpty()) {
            return false;
        }
        return ArrayUtils.contains((int[])this.selections, (int)n);
    }

    @Override
    public void addSelection(int[] nArray) {
        if (this.isSingleSelectionMode()) {
            this.setSelectedIndices(nArray);
        } else {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            if (!this.isSelectionEmpty()) {
                for (int n : this.selections) {
                    treeSet.add(n);
                }
            }
            for (int n : nArray) {
                treeSet.add(n);
            }
            this.setSelectedIndices(ArrayUtils.toPrimitive((Integer[])treeSet.toArray(new Integer[0])));
        }
    }

    @Override
    public void removeSelection(int[] nArray) {
        if (this.isSelectionEmpty() || ArrayUtils.isEmpty((int[])nArray)) {
            return;
        }
        if (!this.isSingleSelectionMode()) {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            if (!this.isSelectionEmpty()) {
                for (int n : this.selections) {
                    treeSet.add(n);
                }
            }
            for (int n : nArray) {
                treeSet.remove(n);
            }
            this.setSelectedIndices(ArrayUtils.toPrimitive((Integer[])treeSet.toArray(new Integer[0])));
        }
    }

    @Override
    public String valueToString(T t) {
        return t.toString();
    }

    @Override
    public void addObserver(GeneralSelectionListEventHandler generalSelectionListEventHandler) {
        this.observable.addEventHandler(generalSelectionListEventHandler);
    }

    @Override
    public void removeObserver(GeneralSelectionListEventHandler generalSelectionListEventHandler) {
        this.observable.removeEventHandler(generalSelectionListEventHandler);
    }

    @Override
    public void dispatchEvent(GeneralSelectionListEvent generalSelectionListEvent) {
        this.observable.dispatchEvent(generalSelectionListEvent);
    }

    @Override
    public T getElementAt(int n) {
        return this.getListModel().getElementAt(n);
    }

    @Override
    public int getSize() {
        return this.getListModel().getSize();
    }

    @Override
    public void addEventHandler(ListEventHandler listEventHandler) {
        this.getListModel().addEventHandler(listEventHandler);
    }

    @Override
    public void dispatchEvent(ListEvent listEvent) {
        this.getListModel().dispatchEvent(listEvent);
    }

    @Override
    public void removeEventHandler(ListEventHandler listEventHandler) {
        this.getListModel().removeEventHandler(listEventHandler);
    }

    @Override
    public void add(int n, T t) {
        this.getListModel().add(n, t);
    }

    @Override
    public boolean add(T t) {
        return this.getListModel().add(t);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        return this.getListModel().addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        return this.getListModel().addAll(n, collection);
    }

    @Override
    public void clear() {
        this.getListModel().clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.getListModel().contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getListModel().containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        return this.getListModel().equals(object);
    }

    @Override
    public T get(int n) {
        return (T)this.getListModel().get(n);
    }

    @Override
    public int hashCode() {
        return this.getListModel().hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this.getListModel().indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.getListModel().isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.getListModel().iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getListModel().lastIndexOf(object);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.getListModel().listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int n) {
        return this.getListModel().listIterator(n);
    }

    @Override
    public T remove(int n) {
        return (T)this.getListModel().remove(n);
    }

    @Override
    public boolean remove(Object object) {
        return this.getListModel().remove(object);
    }

    @Override
    public T set(int n, T t) {
        return this.getListModel().set(n, t);
    }

    @Override
    public int size() {
        return this.getListModel().size();
    }

    @Override
    public List<T> subList(int n, int n2) {
        return this.getListModel().subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.getListModel().toArray();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.getListModel().removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.getListModel().retainAll(collection);
    }

    @Override
    public <U> U[] toArray(U[] UArray) {
        return this.getListModel().toArray(UArray);
    }

    public String toString() {
        return this.getListModel().toString();
    }
}

