/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.list;

import com.ef_prime.rflow.core.common.keyvalue.MutableValue;
import com.ef_prime.rflow.core.common.list.ListEvent;
import com.ef_prime.rflow.core.common.list.ListEventHandler;
import com.ef_prime.rflow.core.common.list.ListModel;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.ChangeEventSupport;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class BasicListModel<T>
implements ListModel<T>,
ChangeEventHandler {
    private Object eventSource = this;
    private List<T> list;
    private Object parent;
    private EventSupport<ListEvent, ListEventHandler> observable = new EventSupport();
    private ChangeEventSupport changeEventSupport = new ChangeEventSupport(this);
    private Map<Object, Integer> indexCache = new HashMap<Object, Integer>(4);

    public static <T> BasicListModel<T> createWithArray(T[] TArray) {
        BasicListModel<T> basicListModel = new BasicListModel<T>(TArray.length);
        for (T t : TArray) {
            basicListModel.add(t);
        }
        return basicListModel;
    }

    public BasicListModel() {
        this(new ArrayList());
    }

    public BasicListModel(int n) {
        this(new ArrayList(n));
    }

    public BasicListModel(List<T> list) {
        this.list = list;
    }

    public BasicListModel(List<T> list, Object object) {
        this.list = list;
        this.eventSource = object;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    @Override
    public T getElementAt(int n) {
        return this.list.get(n);
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public void add(int n, T t) {
        this.list.add(n, t);
        this.fireIntervalAdded(new int[]{n}, new Object[]{t});
    }

    @Override
    public boolean add(T t) {
        int n = this.list.size();
        if (this.list.add(t)) {
            this.fireIntervalAdded(new int[]{n}, new Object[]{t});
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        int n = this.list.size();
        if (this.list.addAll(collection)) {
            this.fireIntervalAdded(this.indices(n, collection.size()), collection.toArray());
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        if (this.list.addAll(n, collection)) {
            this.fireIntervalAdded(this.indices(n, collection.size()), collection.toArray());
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        int n = this.list.size();
        if (n > 0) {
            Object[] objectArray = this.list.toArray();
            this.list.clear();
            this.fireIntervalRemoved(this.indices(0, n - 1), objectArray);
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        return this.list.equals(object);
    }

    @Override
    public T get(int n) {
        return this.list.get(n);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this.list.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.list.lastIndexOf(object);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int n) {
        return this.list.listIterator(n);
    }

    @Override
    public T remove(int n) {
        T t = this.list.remove(n);
        this.fireIntervalRemoved(new int[]{n}, new Object[]{t});
        return t;
    }

    @Override
    public void remove(int[] nArray) {
        Arrays.sort(nArray);
        ArrayDeque<T> arrayDeque = new ArrayDeque<T>();
        for (int i = nArray.length - 1; i >= 0; --i) {
            arrayDeque.addFirst(this.list.remove(nArray[i]));
        }
        this.fireIntervalRemoved(nArray, arrayDeque.toArray());
    }

    @Override
    public boolean remove(Object object) {
        int n = this.list.indexOf(object);
        if (n < 0) {
            return false;
        }
        T t = this.list.remove(n);
        this.fireIntervalRemoved(new int[]{n}, new Object[]{t});
        return true;
    }

    @Override
    public void move(int n, int n2) {
        if (n == n2) {
            return;
        }
        T t = this.list.remove(n);
        this.list.add(n2, t);
        this.fireContentsMoved(n, n2);
    }

    @Override
    public T set(int n, T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<T> subList(int n, int n2) {
        return this.list.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <U> U[] toArray(U[] UArray) {
        return this.list.toArray(UArray);
    }

    private int[] indices(int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n + i;
        }
        return nArray;
    }

    @Override
    public void addEventHandler(ListEventHandler listEventHandler) {
        this.observable.addEventHandler(listEventHandler);
    }

    @Override
    public void dispatchEvent(ListEvent listEvent) {
        this.observable.dispatchEvent(listEvent);
        this.changeEventSupport.dispatchEvent();
    }

    @Override
    public void removeEventHandler(ListEventHandler listEventHandler) {
        this.observable.removeEventHandler(listEventHandler);
    }

    public void fireContentsChanged(int[] nArray) {
        this.dispatchEvent(new ListEvent(this.eventSource, 0, nArray, null));
    }

    public void fireIntervalAdded(int[] nArray, Object[] objectArray) {
        this.indexCache.clear();
        for (Object object : objectArray) {
            if (!(object instanceof MutableValue)) continue;
            ((MutableValue)object).addChangeEventHandler(this);
            ((MutableValue)object).setValueParent(this);
        }
        this.dispatchEvent(new ListEvent(this.eventSource, 1, nArray, objectArray));
    }

    public void fireIntervalRemoved(int[] nArray, Object[] objectArray) {
        this.indexCache.clear();
        for (Object object : objectArray) {
            if (!(object instanceof MutableValue)) continue;
            ((MutableValue)object).removeChangeEventHandler(this);
            ((MutableValue)object).setValueParent(null);
        }
        this.dispatchEvent(new ListEvent(this.eventSource, 2, nArray, objectArray));
    }

    public void fireContentsMoved(int n, int n2) {
        this.dispatchEvent(new ListEvent(this.eventSource, 3, new int[]{n, n2}, null));
    }

    @Override
    public boolean containsChangeEventHandler(ChangeEventHandler changeEventHandler) {
        return this.changeEventSupport.containsEventHandler(changeEventHandler);
    }

    @Override
    public void addChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.changeEventSupport.addEventHandler(changeEventHandler);
    }

    @Override
    public void removeChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.changeEventSupport.removeEventHandler(changeEventHandler);
    }

    @Override
    public void beginValueChange() {
        this.changeEventSupport.beginChange();
    }

    @Override
    public void endValueChange() {
        this.changeEventSupport.endChange();
    }

    @Override
    public Object getValueParent() {
        return this.parent;
    }

    @Override
    public void setValueParent(Object object) {
        this.parent = object;
    }

    @Override
    public void handleChanged(ChangeEvent changeEvent) {
        Integer n = null;
        n = this.indexCache.get(changeEvent.getSource());
        if (n == null && (n = Integer.valueOf(this.list.indexOf(changeEvent.getSource()))) >= 0) {
            this.indexCache.put(changeEvent.getSource(), n);
        }
        if (n >= 0) {
            this.fireContentsChanged(new int[]{n});
        }
    }
}

