/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.table;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.MutableValue;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.GeneralTableModelEvent;
import com.ef_prime.rflow.core.common.table.GeneralTableModelEventHandler;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.ChangeEventSupport;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractGeneralTableModel
implements GeneralTableModel {
    private boolean unboundTableArea;
    private boolean hideHeader;
    private String emptyMessage = null;
    private boolean defaultMessage;
    private Map<Integer, Integer> columnWidthMap;
    private Map<Integer, Integer> fixedColumnWidthMap;
    private EventSupport<GeneralTableModelEvent, GeneralTableModelEventHandler> observable = new EventSupport();
    private ChangeEventSupport changeEventSupport = new ChangeEventSupport(this);
    private Object parent;

    public AbstractGeneralTableModel() {
    }

    protected AbstractGeneralTableModel(AbstractGeneralTableModel abstractGeneralTableModel) {
        this.unboundTableArea = abstractGeneralTableModel.unboundTableArea;
        this.columnWidthMap = abstractGeneralTableModel.columnWidthMap == null ? null : new HashMap<Integer, Integer>(abstractGeneralTableModel.columnWidthMap);
        this.fixedColumnWidthMap = abstractGeneralTableModel.fixedColumnWidthMap == null ? null : new HashMap<Integer, Integer>(abstractGeneralTableModel.fixedColumnWidthMap);
        this.hideHeader = abstractGeneralTableModel.hideHeader;
        this.emptyMessage = abstractGeneralTableModel.emptyMessage;
        this.defaultMessage = abstractGeneralTableModel.defaultMessage;
    }

    public void setUnboundTableArea(boolean bl) {
        this.unboundTableArea = bl;
    }

    @Override
    public boolean isUnboundTableArea() {
        return this.unboundTableArea;
    }

    public void setHideHeader(boolean bl) {
        this.hideHeader = bl;
    }

    @Override
    public boolean hideHeader() {
        return this.hideHeader;
    }

    public void setEmptyMessage(String string) {
        this.emptyMessage = string;
    }

    public void setDefaultMessage(boolean bl) {
        this.defaultMessage = bl;
    }

    public boolean isDefaultMessage() {
        return this.defaultMessage;
    }

    @Override
    public String getEmptyMessage() {
        return this.emptyMessage;
    }

    public void setColumnWidthMap(Map<Integer, Integer> map) {
        this.columnWidthMap = map;
    }

    @Override
    public int getColumnWidth(int n) {
        Key<?> key;
        if (this.columnWidthMap != null && (key = this.columnWidthMap.get(n)) != null) {
            return (Integer)((Object)key);
        }
        key = this.getColumnKey(n);
        if (key != null && key.getWidth() >= 0) {
            return key.getWidth();
        }
        return -1;
    }

    public void setFixedColumnWidthMap(Map<Integer, Integer> map) {
        this.fixedColumnWidthMap = map;
    }

    @Override
    public int getFixedColumnWidth(int n) {
        if (this.fixedColumnWidthMap == null) {
            return -1;
        }
        Integer n2 = this.fixedColumnWidthMap.get(n);
        return n2 == null ? -1 : n2;
    }

    @Override
    public void addNewRow() {
        this.insertNewRow(this.getRowCount());
    }

    @Override
    public void addNewRow(Object ... objectArray) {
        this.insertNewRow(this.getRowCount(), objectArray);
    }

    @Override
    public boolean useLastColumnAsDetail() {
        return false;
    }

    @Override
    public String valueToString(Object object, int n, int n2) {
        return object == null ? "" : object.toString();
    }

    @Override
    public int getColumnIndex(Key<?> key) {
        Key<?>[] keyArray = this.getColumnKeys();
        for (int i = 0; i < keyArray.length; ++i) {
            if (!keyArray[i].equals(key)) continue;
            return i;
        }
        return -1;
    }

    protected int[] indices(int n, int n2) {
        int[] nArray = new int[n2 - n + 1];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n + i;
        }
        return nArray;
    }

    @Override
    public List<Object> getValues(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            arrayList.add(this.getValueAt(i, n));
        }
        return arrayList;
    }

    public <V> List<V> getValues(Key<V> key) {
        int n = this.getColumnIndex(key);
        if (n < 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            arrayList.add(this.getValueAt(i, n));
        }
        return arrayList;
    }

    public List<Object> get(String string) {
        Key<?>[] keyArray = this.getColumnKeys();
        int n = -1;
        for (int i = 0; i < keyArray.length; ++i) {
            if (!keyArray[i].getId().equals(string)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            arrayList.add(this.getValueAt(i, n));
        }
        return arrayList;
    }

    public int rowOf(int n, Object object) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!object.equals(this.getValueAt(i, n))) continue;
            return i;
        }
        return -1;
    }

    public ValueMap getParentValueMap() {
        return MutableValue.getParent(this, ValueMap.class);
    }

    @Override
    public void addEventHandler(GeneralTableModelEventHandler generalTableModelEventHandler) {
        this.observable.addEventHandler(generalTableModelEventHandler);
    }

    @Override
    public void removeEventHandler(GeneralTableModelEventHandler generalTableModelEventHandler) {
        this.observable.removeEventHandler(generalTableModelEventHandler);
    }

    @Override
    public void dispatchEvent(GeneralTableModelEvent generalTableModelEvent) {
        this.observable.dispatchEvent(generalTableModelEvent);
    }

    @Override
    public void fireChangeEvent() {
        this.changeEventSupport.dispatchEvent();
    }

    @Override
    public void addChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.changeEventSupport.addEventHandler(changeEventHandler);
    }

    @Override
    public void removeChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.changeEventSupport.removeEventHandler(changeEventHandler);
    }

    @Override
    public boolean containsChangeEventHandler(ChangeEventHandler changeEventHandler) {
        return this.changeEventSupport.containsEventHandler(changeEventHandler);
    }

    @Override
    public void beginValueChange() {
        this.changeEventSupport.beginChange();
    }

    @Override
    public void endValueChange() {
        this.changeEventSupport.endChange();
    }

    @Override
    public Object getValueParent() {
        return this.parent;
    }

    @Override
    public void setValueParent(Object object) {
        this.parent = object;
    }
}

