/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.table;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.TableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueError;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.Keys;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.core.common.table.RowBasedTableModel;
import com.ef_prime.rflow.core.common.table.RowBasedTableModelEvent;
import com.ef_prime.rflow.core.common.table.RowBasedTableModelEventHandler;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class KeysTableModel
extends RowBasedTableModel<KeysTableRow>
implements RowBasedTableModelEventHandler {
    private int[] uiControls;
    private boolean useLastColumnAsDetail;
    private Table<Integer, Integer, ValueError> errorTable;

    public KeysTableModel(Key<?>[] keyArray, int[] nArray) {
        this(keyArray, nArray, false, null);
    }

    public KeysTableModel(Key<?>[] keyArray, int[] nArray, boolean bl, List<KeysTableRow> list) {
        this(new KeysTableRow(new Keys(keyArray)), nArray, bl, list);
    }

    public KeysTableModel(KeysTableRow keysTableRow, int[] nArray, boolean bl, List<KeysTableRow> list) {
        super(keysTableRow, list);
        this.uiControls = nArray;
        this.useLastColumnAsDetail = bl;
        this.addRowBasedTableModelEventHandler(this);
    }

    public KeysTableModel(KeysTableModel keysTableModel) {
        super(keysTableModel);
        this.uiControls = keysTableModel.uiControls;
        this.useLastColumnAsDetail = keysTableModel.useLastColumnAsDetail;
        if (keysTableModel.errorTable != null) {
            this.errorTable = HashBasedTable.create(keysTableModel.errorTable);
        }
        this.addRowBasedTableModelEventHandler(this);
    }

    public static boolean equals(KeysTableModel keysTableModel, KeysTableModel keysTableModel2) {
        if (keysTableModel.getRowCount() != keysTableModel2.getRowCount() || keysTableModel.getColumnCount() != keysTableModel2.getColumnCount()) {
            return false;
        }
        for (int i = 0; i < keysTableModel.getRowCount(); ++i) {
            KeysTableRow keysTableRow = (KeysTableRow)keysTableModel.getRow(i);
            KeysTableRow keysTableRow2 = (KeysTableRow)keysTableModel2.getRow(i);
            for (int j = 0; j < keysTableModel.getColumnCount(); ++j) {
                if (Objects.equals(keysTableRow.getValue(j), keysTableRow2.getValue(j))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int[] getUIControls() {
        return this.uiControls;
    }

    @Override
    public boolean useLastColumnAsDetail() {
        return this.useLastColumnAsDetail;
    }

    public Object getValueAt(int n, Key<?> key) {
        return ((KeysTableRow)this.getRow(n)).getValue(key);
    }

    @Override
    public GeneralTableModel copy() {
        return new KeysTableModel(this);
    }

    public <V> List<V> getValidValues(Key<V> key) {
        return this.getValidValues(key, TableKey.DEFAULT_VALID_ROW_PREDICATE);
    }

    public <V> List<V> getValidValues(Key<V> key, Predicate<KeysTableRow> predicate) {
        int n = this.getColumnIndex(key);
        if (n < 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.getRowCount());
        for (KeysTableRow keysTableRow : this.validRows(predicate)) {
            arrayList.add(keysTableRow.getValue(n));
        }
        return arrayList;
    }

    public <V> List<V> getValidValuesOrDefault(ValueMap valueMap, Key<V> key, Predicate<KeysTableRow> predicate) {
        int n = this.getColumnIndex(key);
        if (n < 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            KeysTableRow keysTableRow = (KeysTableRow)this.getRow(i);
            if (!predicate.test(keysTableRow)) continue;
            String string = this.valueToString(keysTableRow.getValue(n), i, n);
            arrayList.add(string.isEmpty() ? valueMap.getDynamicDefaultValue(this, i, key) : keysTableRow.getValue(n));
        }
        return arrayList;
    }

    public List<KeysTableRow> validRows() {
        return this.validRows(TableKey.DEFAULT_VALID_ROW_PREDICATE);
    }

    public List<KeysTableRow> validRows(Predicate<KeysTableRow> predicate) {
        ArrayList<KeysTableRow> arrayList = new ArrayList<KeysTableRow>(this.getRowCount());
        for (KeysTableRow keysTableRow : this) {
            if (!predicate.test(keysTableRow)) continue;
            arrayList.add(keysTableRow);
        }
        return arrayList;
    }

    @Deprecated
    public List<KeysTableRow> getValidRows() {
        ArrayList<KeysTableRow> arrayList = new ArrayList<KeysTableRow>();
        for (KeysTableRow keysTableRow : this) {
            if (!keysTableRow.isValid()) continue;
            arrayList.add(keysTableRow);
        }
        return arrayList;
    }

    public <V> List<V> getValuesWithDynamicDefaults(ValueMap valueMap, Key<V> key) {
        int n = this.getColumnIndex(key);
        if (n < 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object object = this.getValueAt(i, n);
            if (key.isValueEmpty(object)) {
                object = valueMap.getDynamicDefaultValue(this, i, key);
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    public ValueError getFirstError() {
        if (!this.isError()) {
            return null;
        }
        return (ValueError)this.errorTable.values().iterator().next();
    }

    public List<ValueError> getErrors() {
        if (!this.isError()) {
            return null;
        }
        return Lists.newArrayList((Iterable)this.errorTable.values());
    }

    public ValueError getError(Integer n, Integer n2) {
        if (this.errorTable == null) {
            return null;
        }
        return (ValueError)this.errorTable.get((Object)n, (Object)n2);
    }

    public ValueError putError(Integer n, Integer n2, ValueError valueError) {
        if (valueError == null) {
            return this.removeError(n, n2);
        }
        if (this.errorTable == null) {
            this.errorTable = HashBasedTable.create();
        }
        return (ValueError)this.errorTable.put((Object)n, (Object)n2, (Object)valueError);
    }

    public void removeError(Integer n) {
        if (this.errorTable == null) {
            return;
        }
        this.errorTable.row((Object)n).clear();
    }

    public ValueError removeError(Integer n, Integer n2) {
        if (this.errorTable == null) {
            return null;
        }
        return (ValueError)this.errorTable.remove((Object)n, (Object)n2);
    }

    public boolean isError() {
        return this.errorTable != null && !this.errorTable.isEmpty();
    }

    @Override
    public void rowBasedTableChanged(RowBasedTableModelEvent rowBasedTableModelEvent) {
        if (!this.isError()) {
            return;
        }
        switch (rowBasedTableModelEvent.getType()) {
            case 0: {
                this.updateIndicesInsert(rowBasedTableModelEvent);
                break;
            }
            case 1: {
                this.updateIndicesDelete(rowBasedTableModelEvent);
                break;
            }
            case 3: {
                this.updateIndicesMove(rowBasedTableModelEvent);
            }
        }
    }

    private void updateIndicesInsert(RowBasedTableModelEvent rowBasedTableModelEvent) {
        int[] nArray = rowBasedTableModelEvent.getRows();
        if (nArray.length == 1 && nArray[0] == rowBasedTableModelEvent.getModel().getRowCount() - 1) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.errorTable.rowKeySet());
        Collections.sort(arrayList);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Integer n = (Integer)arrayList.get(i);
            int n2 = Arrays.binarySearch(nArray, n);
            int n3 = Math.abs(n2 + 1);
            if (n3 == 0) continue;
            Map map = this.errorTable.row((Object)n);
            this.errorTable.row((Object)(n + n3)).putAll(map);
            map.clear();
        }
    }

    private void updateIndicesDelete(RowBasedTableModelEvent rowBasedTableModelEvent) {
        int[] nArray = rowBasedTableModelEvent.getRows();
        for (int i = 0; i < nArray.length; ++i) {
            this.removeError(nArray[i]);
        }
        ArrayList arrayList = new ArrayList(this.errorTable.rowKeySet());
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Integer n = (Integer)arrayList.get(i);
            int n2 = Arrays.binarySearch(nArray, n);
            int n3 = Math.abs(n2 + 1);
            if (n3 == 0) continue;
            Map map = this.errorTable.row((Object)n);
            this.errorTable.row((Object)(n - n3)).putAll(map);
            map.clear();
        }
    }

    private void updateIndicesMove(RowBasedTableModelEvent rowBasedTableModelEvent) {
        int[] nArray = rowBasedTableModelEvent.getRows();
        Map map = this.errorTable.row((Object)nArray[0]);
        Map map2 = this.errorTable.row((Object)nArray[1]);
        HashMap hashMap = new HashMap(map);
        map.clear();
        map.putAll(map2);
        map2.clear();
        map2.putAll(hashMap);
    }
}

