/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.table;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.table.AbstractTableRow;
import com.ef_prime.rflow.core.common.table.Keys;
import com.ef_prime.rflow.core.common.table.TableRow;
import java.lang.reflect.Constructor;

public class KeysTableRow
extends AbstractTableRow {
    private Keys keys;
    private Object[] values;

    public KeysTableRow(Keys keys) {
        this.keys = keys;
        this.values = new Object[this.getColumnKeys().length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = this.getColumnKey(i).getDefaultValue();
        }
    }

    @Override
    public int getColumnCount() {
        return this.getColumnKeys().length;
    }

    @Override
    public String getColumnName(int n) {
        return this.getColumnKeys()[n].getTitle();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.getColumnKey(n).getJavaClass();
    }

    @Override
    public Key<?> getColumnKey(int n) {
        return this.getColumnKeys()[n];
    }

    @Override
    public Key<?>[] getColumnKeys() {
        return this.keys.getKeys();
    }

    @Override
    public boolean isCellEditable(int n) {
        Key<?> key = this.getColumnKey(n);
        return key.isEditable();
    }

    public int getIndex(Key<?> key) {
        Integer n = this.keys.getIndex(key);
        if (n == null) {
            throw new IllegalArgumentException("invalid key: " + key.getId());
        }
        return n;
    }

    public <V> V getValue(Key<V> key) {
        return (V)this.values[this.getIndex(key)];
    }

    public Object get(String string) {
        return this.values[this.keys.getIndex(string)];
    }

    @Override
    public Object getValue(int n) {
        return this.values[n];
    }

    @Override
    public boolean setValue(Object object, int n) {
        this.values[n] = object == null ? this.getColumnKey(n).getDefaultValue() : object;
        return true;
    }

    @Override
    public TableRow copyRow() {
        KeysTableRow keysTableRow;
        try {
            Constructor<?> constructor = this.getClass().getConstructor(Keys.class);
            keysTableRow = (KeysTableRow)constructor.newInstance(this.keys);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to copy KeysGeneralTableRow", exception);
        }
        keysTableRow.values = new Object[this.values.length];
        for (int i = 0; i < keysTableRow.values.length; ++i) {
            Key<?> key = this.getColumnKey(i);
            keysTableRow.values[i] = key.copyValue(this.getValue(i));
        }
        return keysTableRow;
    }

    public boolean isValid() {
        for (int i = 0; i < this.keys.getKeys().length; ++i) {
            Key<?> key = this.keys.getKeys()[i];
            Object object = this.getValue(i);
            if (!key.isRequired() || object != null && !key.isValueEmpty(object)) continue;
            return false;
        }
        return true;
    }
}

