/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.table;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.MutableValue;
import com.ef_prime.rflow.core.common.table.AbstractGeneralTableModel;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.GeneralTableModelEvent;
import com.ef_prime.rflow.core.common.table.GeneralTableModelEventHandler;
import com.ef_prime.rflow.core.common.table.RowBasedTableModelEvent;
import com.ef_prime.rflow.core.common.table.RowBasedTableModelEventHandler;
import com.ef_prime.rflow.core.common.table.TableRow;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.core.util.Yamlable;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.google.common.collect.Iterators;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class RowBasedTableModel<T extends TableRow>
extends AbstractGeneralTableModel
implements Iterable<T>,
Yamlable {
    private static final Logger LOGGER = Logger.getLogger(RowBasedTableModel.class.getName());
    public static final int SELECTION_CELL = 0;
    public static final int SELECTION_SINGLE_ROW = 1;
    public static final int SELECTION_MULTIPLE_ROW = 2;
    private TableRow defaultRow;
    protected List<T> rows;
    private int[] autoNumberColumns;
    private int onOffColumn = -1;
    private int selectionMode;
    private int[] selectedRows;
    private EventSupport<RowBasedTableModelEvent, RowBasedTableModelEventHandler> eventSupport = new EventSupport();
    private MutableValueHandler mutableValueHandler = new MutableValueHandler();
    private Map<Integer, ColumnChangeEventHandler> columnChangeEventHandlers = new HashMap<Integer, ColumnChangeEventHandler>();

    public RowBasedTableModel(T t) {
        this(t, null);
    }

    public RowBasedTableModel(T t, List<T> list) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        this.defaultRow = t.copyRow();
        this.rows = list;
        if (this.rows == null) {
            this.rows = new ArrayList<T>();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < t.getColumnCount(); ++i) {
            if (!t.isAutoNumber(i)) continue;
            arrayList.add(i);
        }
        this.autoNumberColumns = ArrayUtils.toPrimitive((Integer[])arrayList.toArray(new Integer[arrayList.size()]));
        this.initMutableValueHandler();
    }

    protected RowBasedTableModel(RowBasedTableModel<T> rowBasedTableModel) {
        super(rowBasedTableModel);
        this.defaultRow = rowBasedTableModel.defaultRow.copyRow();
        this.rows = new ArrayList<T>();
        for (int i = 0; i < rowBasedTableModel.rows.size(); ++i) {
            TableRow tableRow = (TableRow)rowBasedTableModel.rows.get(i);
            this.rows.add(tableRow.copyRow());
        }
        this.autoNumberColumns = (int[])rowBasedTableModel.autoNumberColumns.clone();
        this.onOffColumn = rowBasedTableModel.onOffColumn;
        this.selectionMode = rowBasedTableModel.selectionMode;
        this.initMutableValueHandler();
    }

    private void initMutableValueHandler() {
        this.mutableValueHandler.checkAll();
        this.addEventHandler(this.mutableValueHandler);
        this.addRowBasedTableModelEventHandler(this.mutableValueHandler);
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.unmodifiableIterator(this.rows.iterator());
    }

    public T getRow(int n) {
        return (T)((TableRow)this.rows.get(n));
    }

    public List<T> getRows() {
        return new ArrayList<T>(this.rows);
    }

    public T getDefaultRow() {
        return (T)((TableRow)Utility.cast(this.defaultRow.copyRow()));
    }

    @Override
    public Object getDefaultValueAt(int n) {
        return this.getDefaultRow().getValue(n);
    }

    public boolean isAutoNumberColumn() {
        return !ArrayUtils.isEmpty((int[])this.autoNumberColumns);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.defaultRow.getColumnCount();
    }

    public int getInternalColumnCount() {
        return this.defaultRow.getInternalColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.defaultRow.getColumnName(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.defaultRow.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        TableRow tableRow = (TableRow)this.rows.get(n);
        return tableRow.isCellEditable(n2);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return ((TableRow)this.rows.get(n)).getValue(n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Object object2 = this.getValueAt(n, n2);
        if (ObjectUtils.equals((Object)object, (Object)object2)) {
            return;
        }
        if (((TableRow)this.rows.get(n)).setValue(object, n2)) {
            if (object2 != object) {
                this.mutableValueHandler.valueRemoved(object2, n2);
            }
            this.dispatchEvent(GeneralTableModelEvent.cellUpdated(this, n, n2), RowBasedTableModelEvent.updated(this, n, n2, object2, object));
        }
    }

    @Override
    public void insertNewRow(int n) {
        this.rows.add(n, this.defaultRow.copyRow());
        int[] nArray = new int[]{n};
        this.dispatchRowInserted(nArray);
        this.autoNumberRow(n);
    }

    @Override
    public void insertNewRow(int n, Object ... objectArray) {
        TableRow tableRow = this.defaultRow.copyRow();
        int n2 = Math.min(objectArray.length, this.getColumnCount());
        for (int i = 0; i < n2; ++i) {
            tableRow.setValue(objectArray[i], i);
        }
        this.rows.add(n, tableRow);
        int[] nArray = new int[]{n};
        this.dispatchRowInserted(nArray);
    }

    @Override
    public void insertNewRows(int n, int n2) {
        int[] nArray = new int[n2 - n + 1];
        for (int i = 0; i < nArray.length; ++i) {
            int n3;
            nArray[i] = n3 = n + i;
            this.rows.add(n3, this.defaultRow.copyRow());
        }
        this.dispatchRowInserted(nArray);
        this.autoNumberRow(n);
    }

    public void insertRow(int n, TableRow tableRow) {
        this.rows.add(n, tableRow);
        int[] nArray = new int[]{n};
        this.dispatchRowInserted(nArray);
        this.autoNumberRow(n);
    }

    public void setOnOffColumn(int n) {
        this.onOffColumn = n;
    }

    public int getOnOffColumn() {
        return this.onOffColumn;
    }

    public void setSelectionMode(int n) {
        this.selectionMode = n;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectedRows(int[] nArray) {
        this.selectedRows = nArray;
    }

    public int[] getSelectedRows() {
        return this.selectedRows;
    }

    private void autoNumberRow(int n) {
        if (this.isAutoNumberColumn()) {
            for (int i = n; i < this.getRowCount(); ++i) {
                for (int j = 0; j < this.autoNumberColumns.length; ++j) {
                    this.setValueAt(i + 1, i, j);
                }
            }
        }
    }

    public void addRow(TableRow tableRow) {
        this.insertRow(this.getRowCount(), tableRow);
    }

    @Override
    public void removeRows(int[] nArray) {
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = (int[])nArray.clone();
        Arrays.sort(nArray2);
        ArrayDeque<TableRow> arrayDeque = new ArrayDeque<TableRow>();
        for (int i = nArray2.length - 1; i >= 0; --i) {
            int n = nArray2[i];
            if (n < 0 || n >= this.rows.size()) continue;
            arrayDeque.addFirst((TableRow)this.rows.remove(n));
        }
        if (!arrayDeque.isEmpty()) {
            this.dispatchEvent(GeneralTableModelEvent.rowDeleted(this, nArray2), RowBasedTableModelEvent.deleted(this, nArray2, arrayDeque.toArray(new TableRow[0])));
            this.autoNumberRow(nArray2[0]);
        }
    }

    @Override
    public void removeAllRows() {
        if (this.getRowCount() > 0) {
            this.removeRows(this.indices(0, this.getRowCount() - 1));
        }
    }

    @Override
    public void moveRow(int n, int n2) {
        int[] nArray;
        if (n == n2) {
            return;
        }
        TableRow tableRow = (TableRow)this.rows.remove(n);
        if (tableRow == null) {
            return;
        }
        if (n < n2) {
            this.rows.add(n2, tableRow);
            nArray = this.indices(n, n2);
        } else {
            this.rows.add(n2, tableRow);
            nArray = this.indices(n2, n);
        }
        this.dispatchEvent(GeneralTableModelEvent.rowUpdated(this, nArray), RowBasedTableModelEvent.moved(this, n, n2));
        this.autoNumberRow(Math.min(n, n2));
    }

    @Override
    public void makeCopies(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            TableRow tableRow = (TableRow)this.rows.get(nArray[i]);
            nArray2[i] = this.rows.size();
            this.rows.add(tableRow.copyRow());
        }
        this.dispatchRowInserted(nArray2);
    }

    @Override
    public int[] getUIControls() {
        return new int[0];
    }

    @Override
    public String valueToString(Object object, int n, int n2) {
        return ((TableRow)this.rows.get(n)).valueToString(object, n2);
    }

    public void addRowBasedTableModelEventHandler(RowBasedTableModelEventHandler rowBasedTableModelEventHandler) {
        this.eventSupport.addEventHandler(rowBasedTableModelEventHandler);
    }

    public void removeRowBasedTableModelEventHandler(RowBasedTableModelEventHandler rowBasedTableModelEventHandler) {
        this.eventSupport.removeEventHandler(rowBasedTableModelEventHandler);
    }

    @Override
    public void dispatchEvent(RowBasedTableModelEvent rowBasedTableModelEvent) {
        this.eventSupport.dispatchEvent(rowBasedTableModelEvent);
    }

    private void dispatchRowInserted(int[] nArray) {
        this.dispatchEvent(GeneralTableModelEvent.rowInserted(this, nArray), RowBasedTableModelEvent.inserted(this, nArray));
    }

    private void dispatchEvent(GeneralTableModelEvent generalTableModelEvent, RowBasedTableModelEvent rowBasedTableModelEvent) {
        this.dispatchEvent(generalTableModelEvent);
        this.dispatchEvent(rowBasedTableModelEvent);
        this.fireChangeEvent();
    }

    @Override
    public Key<?> getColumnKey(int n) {
        return this.defaultRow.getColumnKey(n);
    }

    @Override
    public Key<?>[] getColumnKeys() {
        return this.defaultRow.getColumnKeys();
    }

    @Override
    public void storeToElement(XmlContext xmlContext, Document document, Element element) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Element element2 = document.createElement("row");
            for (int j = 0; j < this.getInternalColumnCount(); ++j) {
                Object object = this.getValueAt(i, j);
                Key<?> key = this.getColumnKey(j);
                Element element3 = document.createElement("v");
                key.valueToElement(document, element3, object);
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
    }

    @Override
    public void loadElement(Element element, XmlContext xmlContext) {
        int n = this.rows.size();
        for (Element element2 : XmlUtility.elements(element)) {
            Object[] objectArray = new Object[this.getInternalColumnCount()];
            List<Element> list = XmlUtility.elements(element2);
            int n2 = 0;
            for (int i = 0; i < list.size(); ++i) {
                Element element3 = list.get(i);
                if (!element3.getTagName().equals("v")) continue;
                try {
                    objectArray[n2] = this.getColumnKey(n2).elementToValue(element3);
                }
                catch (Exception exception) {
                    objectArray[n2] = "";
                }
                ++n2;
            }
            TableRow tableRow = this.defaultRow.copyRow();
            tableRow.load(objectArray);
            this.rows.add(tableRow);
        }
        Object object = new int[this.rows.size() - n];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = n + i;
        }
        this.dispatchRowInserted((int[])object);
    }

    @Override
    public Object toYamlValue(YamlEx yamlEx) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.getRowCount(); ++i) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (int j = 0; j < this.getInternalColumnCount(); ++j) {
                Object object = this.getValueAt(i, j);
                Key<?> key = this.getColumnKey(j);
                arrayList2.add(key.valueToYamlValue(yamlEx, object, false));
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    @Override
    public void loadYamlValue(YamlEx yamlEx, Object object) {
        List list = (List)YamlEx.typeCheck(List.class, object);
        int n = this.rows.size();
        for (Object e : list) {
            List list2 = (List)YamlEx.typeCheck(List.class, e);
            Object[] objectArray = new Object[this.getInternalColumnCount()];
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = this.getColumnKey(i).yamlValueToValue(yamlEx, list2.get(i));
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Failed to read a table cell entry.", exception);
                continue;
            }
            TableRow tableRow = this.defaultRow.copyRow();
            tableRow.load(objectArray);
            this.rows.add(tableRow);
        }
        Object object2 = new int[this.rows.size() - n];
        for (int i = 0; i < ((Object)object2).length; ++i) {
            object2[i] = n + i;
        }
        this.dispatchRowInserted((int[])object2);
    }

    @Override
    public GeneralTableModel copy() {
        throw new UnsupportedOperationException();
    }

    private class MutableValueHandler
    implements GeneralTableModelEventHandler,
    RowBasedTableModelEventHandler {
        private MutableValueHandler() {
        }

        public void valueRemoved(Object object, int n) {
            if (!(object instanceof MutableValue)) {
                return;
            }
            MutableValue mutableValue = (MutableValue)object;
            ColumnChangeEventHandler columnChangeEventHandler = RowBasedTableModel.this.columnChangeEventHandlers.get(n);
            if (columnChangeEventHandler != null) {
                mutableValue.removeChangeEventHandler(columnChangeEventHandler);
            }
            mutableValue.setValueParent(null);
        }

        @Override
        public void tableChanged(GeneralTableModelEvent generalTableModelEvent) {
            switch (generalTableModelEvent.getType()) {
                case 0: {
                    for (int n : generalTableModelEvent.getRows()) {
                        this.check(n);
                    }
                    break;
                }
                case 1: {
                    if (generalTableModelEvent.rowIsAll()) {
                        for (int i = 0; i < RowBasedTableModel.this.getRowCount(); ++i) {
                            this.check(i);
                        }
                    } else if (generalTableModelEvent.columnIsAll()) {
                        for (int n : generalTableModelEvent.getRows()) {
                            this.check(n);
                        }
                    } else {
                        for (int i = 0; i < generalTableModelEvent.getRows().length; ++i) {
                            this.check(generalTableModelEvent.getRows()[i], generalTableModelEvent.getColumns()[i]);
                        }
                    }
                    break;
                }
            }
        }

        private void checkAll() {
            for (int i = 0; i < RowBasedTableModel.this.getRowCount(); ++i) {
                this.check(i);
            }
        }

        private void check(int n) {
            for (int i = 0; i < RowBasedTableModel.this.getColumnCount(); ++i) {
                this.check(n, i);
            }
        }

        private void check(int n, int n2) {
            Object object = RowBasedTableModel.this.getValueAt(n, n2);
            if (object instanceof MutableValue) {
                MutableValue mutableValue = (MutableValue)object;
                ColumnChangeEventHandler columnChangeEventHandler = RowBasedTableModel.this.columnChangeEventHandlers.get(n2);
                if (columnChangeEventHandler == null) {
                    columnChangeEventHandler = new ColumnChangeEventHandler(n2);
                    RowBasedTableModel.this.columnChangeEventHandlers.put(n2, columnChangeEventHandler);
                }
                if (!mutableValue.containsChangeEventHandler(columnChangeEventHandler)) {
                    mutableValue.addChangeEventHandler(columnChangeEventHandler);
                }
                mutableValue.setValueParent(RowBasedTableModel.this);
            }
        }

        @Override
        public void rowBasedTableChanged(RowBasedTableModelEvent rowBasedTableModelEvent) {
            switch (rowBasedTableModelEvent.getType()) {
                case 1: {
                    for (TableRow tableRow : rowBasedTableModelEvent.getDeleted()) {
                        for (int i = 0; i < tableRow.getColumnCount(); ++i) {
                            this.valueRemoved(tableRow.getValue(i), i);
                        }
                    }
                    break;
                }
            }
        }
    }

    private class ColumnChangeEventHandler
    implements ChangeEventHandler {
        private int column;

        public ColumnChangeEventHandler(int n) {
            this.column = n;
        }

        @Override
        public void handleChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            for (int i = 0; i < RowBasedTableModel.this.getRowCount(); ++i) {
                if (RowBasedTableModel.this.getValueAt(i, this.column) != object) continue;
                RowBasedTableModel.this.dispatchEvent(GeneralTableModelEvent.cellUpdated(RowBasedTableModel.this, i, this.column), RowBasedTableModelEvent.updated(RowBasedTableModel.this, i, this.column, object, object));
                break;
            }
        }
    }
}

