/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.table;

import com.ef_prime.rflow.core.common.keyvalue.MutableValue;
import com.ef_prime.rflow.core.common.table.UnboundTableModelEvent;
import com.ef_prime.rflow.core.common.table.UnboundTableModelEventHandler;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.common.xml.XmlElement;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.core.util.Yamlable;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.ChangeEventSupport;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UnboundTableModel
implements Iterable<List<Object>>,
MutableValue,
XmlElement,
Yamlable {
    private List<List<Object>> data;
    private int columnCount;
    private EventSupport<UnboundTableModelEvent, UnboundTableModelEventHandler> eventSupport = new EventSupport();
    private ChangeEventSupport changeEventSupport = new ChangeEventSupport(this);
    private Object parent;

    public UnboundTableModel() {
        this(new ArrayList<List<Object>>(10));
    }

    public UnboundTableModel(List<List<Object>> list) {
        this.data = list;
        this.updateColumnCount();
    }

    protected UnboundTableModel(UnboundTableModel unboundTableModel) {
        this.data = new ArrayList<List<Object>>(unboundTableModel.data.size());
        for (List<Object> list : unboundTableModel.data) {
            this.data.add((List<Object>)(list == null ? null : new ArrayList<Object>(list)));
        }
        this.columnCount = unboundTableModel.columnCount;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getRowName(int n) {
        return Integer.toString(n + 1);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public String getColumnName(int n) {
        return Integer.toString(n + 1);
    }

    public List<Object> getRow(int n) {
        return this.data.get(n);
    }

    public void clear() {
        this.data.clear();
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.data.size()) {
            return null;
        }
        List<Object> list = this.data.get(n);
        if (list == null) {
            return null;
        }
        if (n2 >= list.size()) {
            return null;
        }
        return list.get(n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object != null && object.equals("")) {
            object = null;
        }
        if (object == null && n >= this.data.size()) {
            return;
        }
        while (n >= this.data.size()) {
            this.data.add(null);
        }
        List<Object> list = this.data.get(n);
        if (list == null) {
            if (object == null) {
                return;
            }
            list = new ArrayList<Object>(n2 + 1);
            this.data.set(n, list);
        }
        if (object == null && n2 >= list.size()) {
            return;
        }
        while (n2 >= list.size()) {
            list.add(null);
        }
        Object object2 = this.getValueAt(n, n2);
        if (!Objects.equals(object, object2)) {
            list.set(n2, object);
            if (object == null) {
                if (n == this.data.size() - 1) {
                    this.trimRows();
                }
                if (n2 == list.size() - 1) {
                    UnboundTableModel.trimColumn(list);
                }
                if (n2 == this.columnCount - 1) {
                    this.updateColumnCount();
                }
                this.dispatchEvent(UnboundTableModelEvent.cellUpdated(this, n, n2, object2, object));
            } else {
                this.columnCount = Math.max(this.columnCount, n2 + 1);
                this.dispatchEvent(UnboundTableModelEvent.cellUpdated(this, n, n2, object2, object));
            }
        }
    }

    public int[] toDataRows(int[] nArray) {
        int n;
        for (n = 0; n < nArray.length && nArray[n] < this.getRowCount(); ++n) {
        }
        if (n != nArray.length) {
            nArray = ArrayUtils.subarray((int[])nArray, (int)0, (int)n);
        }
        return nArray;
    }

    public int[] toDataColumns(int[] nArray) {
        int n;
        for (n = 0; n < nArray.length && nArray[n] < this.getColumnCount(); ++n) {
        }
        if (n != nArray.length) {
            nArray = ArrayUtils.subarray((int[])nArray, (int)0, (int)n);
        }
        return nArray;
    }

    public void insertRows(int[] nArray) {
        if ((nArray = this.toDataRows(nArray)).length == 0) {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.data.add(nArray[i], null);
        }
        this.dispatchEvent(UnboundTableModelEvent.rowInserted(this, nArray));
    }

    public void removeRows(int[] nArray) {
        if ((nArray = this.toDataRows(nArray)).length == 0) {
            return;
        }
        ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>(nArray.length);
        for (int i = nArray.length - 1; i >= 0; --i) {
            arrayList.add(this.data.remove(nArray[i]));
        }
        this.trimRows();
        this.updateColumnCount();
        this.dispatchEvent(UnboundTableModelEvent.rowDeleted(this, nArray, Lists.reverse(arrayList)));
    }

    public void insertColumns(int[] nArray) {
        if ((nArray = this.toDataColumns(nArray)).length == 0) {
            return;
        }
        for (List<Object> list : this.data) {
            if (list == null) continue;
            for (int i = nArray.length - 1; i >= 0; --i) {
                list.add(nArray[i], null);
            }
        }
        this.columnCount += nArray.length;
        this.dispatchEvent(UnboundTableModelEvent.columnInserted(this, nArray));
    }

    public void removeColumns(int[] nArray) {
        if ((nArray = this.toDataColumns(nArray)).length == 0) {
            return;
        }
        ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(new ArrayList(this.data.size()));
        }
        for (List<Object> list : this.data) {
            int n;
            if (list == null) {
                for (n = 0; n < arrayList.size(); ++n) {
                    ((List)arrayList.get(n)).add(null);
                }
                continue;
            }
            for (n = nArray.length - 1; n >= 0; --n) {
                int n2 = nArray[n];
                List list2 = (List)arrayList.get(n);
                if (n2 < list.size()) {
                    list2.add(list.remove(n2));
                    continue;
                }
                list2.add(null);
            }
            UnboundTableModel.trimColumn(list);
        }
        this.trimRows();
        this.updateColumnCount();
        this.dispatchEvent(UnboundTableModelEvent.columnDeleted(this, nArray, arrayList));
    }

    private void trimRows() {
        for (int i = this.data.size() - 1; i >= 0; --i) {
            List<Object> list = this.data.get(i);
            if (list == null) {
                this.data.remove(i);
                continue;
            }
            boolean bl = true;
            for (Object object : list) {
                if (object == null) continue;
                bl = false;
                break;
            }
            if (!bl) break;
            this.data.remove(i);
        }
    }

    private static void trimColumn(List<Object> list) {
        for (int i = list.size() - 1; i >= 0 && list.get(i) == null; --i) {
            list.remove(i);
        }
    }

    private void updateColumnCount() {
        int n = 0;
        for (List<Object> list : this.data) {
            if (list != null && (n = Math.max(n, list.size())) == this.columnCount) break;
        }
        this.columnCount = n;
    }

    public UnboundTableModel copy() {
        return new UnboundTableModel(this);
    }

    @Override
    public Iterator<List<Object>> iterator() {
        return Iterators.unmodifiableIterator(this.data.iterator());
    }

    @Override
    public boolean containsChangeEventHandler(ChangeEventHandler changeEventHandler) {
        return this.changeEventSupport.containsEventHandler(changeEventHandler);
    }

    @Override
    public void addChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.changeEventSupport.addEventHandler(changeEventHandler);
    }

    @Override
    public void removeChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.changeEventSupport.removeEventHandler(changeEventHandler);
    }

    @Override
    public void beginValueChange() {
        this.changeEventSupport.beginChange();
    }

    @Override
    public void endValueChange() {
        this.changeEventSupport.endChange();
    }

    @Override
    public Object getValueParent() {
        return this.parent;
    }

    @Override
    public void setValueParent(Object object) {
        this.parent = object;
    }

    public void addEventHandler(UnboundTableModelEventHandler unboundTableModelEventHandler) {
        this.eventSupport.addEventHandler(unboundTableModelEventHandler);
    }

    public void removeEventHandler(UnboundTableModelEventHandler unboundTableModelEventHandler) {
        this.eventSupport.removeEventHandler(unboundTableModelEventHandler);
    }

    public void dispatchEvent(UnboundTableModelEvent unboundTableModelEvent) {
        this.eventSupport.dispatchEvent(unboundTableModelEvent);
        this.changeEventSupport.dispatchEvent();
    }

    @Override
    public void storeToElement(XmlContext xmlContext, Document document, Element element) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Element element2 = document.createElement("row");
            for (int j = 0; j < this.getColumnCount(); ++j) {
                Object object = this.getValueAt(i, j);
                Element element3 = document.createElement("v");
                element3.appendChild(document.createTextNode(object == null ? "" : object.toString()));
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
    }

    @Override
    public void loadElement(Element element, XmlContext xmlContext) {
        this.data.clear();
        this.columnCount = 0;
        for (Element element2 : XmlUtility.elements(element)) {
            List<Element> list = XmlUtility.elements(element2);
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Element element3 = list.get(i);
                if (!element3.getTagName().equals("v")) continue;
                String string = element3.getTextContent();
                if (string != null && string.isEmpty()) {
                    string = null;
                }
                arrayList.add(string);
            }
            this.data.add(arrayList);
            this.columnCount = Math.max(this.columnCount, arrayList.size());
        }
    }

    @Override
    public Object toYamlValue(YamlEx yamlEx) {
        return this.data;
    }

    @Override
    public void loadYamlValue(YamlEx yamlEx, Object object) {
        List list = (List)object;
        this.data.clear();
        this.columnCount = 0;
        for (List list2 : list) {
            ArrayList<String> arrayList = new ArrayList<String>(list2.size());
            for (int i = 0; i < list2.size(); ++i) {
                String string;
                Object e = list2.get(i);
                if (e == null) {
                    string = null;
                } else {
                    string = e.toString();
                    if (string.isEmpty()) {
                        string = null;
                    }
                }
                arrayList.add(string);
            }
            this.data.add(arrayList);
            this.columnCount = Math.max(this.columnCount, arrayList.size());
        }
    }
}

