/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.tree;

import com.ef_prime.rflow.core.common.list.BasicListModel;
import com.ef_prime.rflow.core.common.tree.AbstractGeneralTreeNode;
import com.ef_prime.rflow.core.common.tree.GeneralTreeNode;
import com.ef_prime.rflow.core.common.tree.LazyGeneralTreeNode;
import java.util.ArrayDeque;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractLazyGeneralTreeNode
extends BasicListModel<GeneralTreeNode>
implements LazyGeneralTreeNode {
    protected GeneralTreeNode parent;

    @Override
    public GeneralTreeNode getRoot() {
        GeneralTreeNode generalTreeNode = this;
        while (generalTreeNode.getParent() != null) {
            generalTreeNode = generalTreeNode.getParent();
        }
        return generalTreeNode;
    }

    @Override
    public GeneralTreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(GeneralTreeNode generalTreeNode) {
        this.parent = generalTreeNode;
    }

    @Override
    public GeneralTreeNode[] getPathToRoot() {
        ArrayDeque<AbstractLazyGeneralTreeNode> arrayDeque = new ArrayDeque<AbstractLazyGeneralTreeNode>();
        arrayDeque.add(this);
        GeneralTreeNode generalTreeNode = this;
        while (generalTreeNode.getParent() != null) {
            generalTreeNode = generalTreeNode.getParent();
            arrayDeque.addFirst((AbstractLazyGeneralTreeNode)generalTreeNode);
        }
        return arrayDeque.toArray(new GeneralTreeNode[arrayDeque.size()]);
    }

    @Override
    public boolean isDescendantOf(GeneralTreeNode generalTreeNode) {
        GeneralTreeNode generalTreeNode2 = this;
        while (generalTreeNode2.getParent() != null) {
            if (((Object)generalTreeNode2).equals(generalTreeNode)) {
                return true;
            }
            generalTreeNode2 = generalTreeNode2.getParent();
        }
        return false;
    }

    @Override
    public void addChild(GeneralTreeNode generalTreeNode) {
        this.add(generalTreeNode);
        generalTreeNode.setParent(this);
    }

    @Override
    public int getChildCount() {
        return this.size();
    }

    @Override
    public GeneralTreeNode getChildAt(int n) {
        return (GeneralTreeNode)this.get(n);
    }

    @Override
    public int indexOfChild(GeneralTreeNode generalTreeNode) {
        return this.indexOfChild(generalTreeNode);
    }

    @Override
    public void insertChild(int n, GeneralTreeNode generalTreeNode) {
        this.add(n, generalTreeNode);
        generalTreeNode.setParent(this);
    }

    @Override
    public void removeChild(int n) {
        GeneralTreeNode generalTreeNode = (GeneralTreeNode)this.remove(n);
        if (generalTreeNode != null) {
            generalTreeNode.setParent(null);
        }
    }

    @Override
    public void removeChild(GeneralTreeNode generalTreeNode) {
        if (this.remove(generalTreeNode)) {
            generalTreeNode.setParent(null);
        }
    }

    @Override
    public void removeChildren() {
        this.clear();
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public String getIconName() {
        return null;
    }

    @Override
    public String getLargeIconName() {
        return null;
    }

    public String toString() {
        return this.getDisplayString();
    }

    @Override
    public String getDisplayString() {
        return this.getName();
    }

    @Override
    public Object getIdentifier() {
        return this.getName();
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hashCode((Object)this.getIdentifier());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AbstractGeneralTreeNode)) {
            return false;
        }
        AbstractGeneralTreeNode abstractGeneralTreeNode = (AbstractGeneralTreeNode)object;
        return ObjectUtils.equals((Object)this.getIdentifier(), (Object)abstractGeneralTreeNode.getIdentifier());
    }
}

