/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.tree;

import com.ef_prime.rflow.core.common.list.ListEvent;
import com.ef_prime.rflow.core.common.list.ListEventHandler;
import com.ef_prime.rflow.core.common.tree.GeneralTreeModelEvent;
import com.ef_prime.rflow.core.common.tree.GeneralTreeModelEventHandler;
import com.ef_prime.rflow.core.common.tree.GeneralTreeNode;
import com.ef_prime.rflow.core.common.tree.TreeIterator;
import com.ef_prime.rflow.ui.common.event.EventSupport;

public class GeneralTreeModel
implements ListEventHandler {
    private GeneralTreeNode rootNode;
    private EventSupport<GeneralTreeModelEvent, GeneralTreeModelEventHandler> observable = new EventSupport();

    public GeneralTreeModel(GeneralTreeNode generalTreeNode) {
        this.rootNode = generalTreeNode;
        TreeIterator treeIterator = new TreeIterator(generalTreeNode);
        while (treeIterator.hasNext()) {
            treeIterator.next().addEventHandler(this);
        }
    }

    public GeneralTreeNode getRootNode() {
        return this.rootNode;
    }

    public void unloadModel() {
        TreeIterator treeIterator = new TreeIterator(this.rootNode);
        while (treeIterator.hasNext()) {
            treeIterator.next().removeEventHandler(this);
        }
    }

    public void addObserver(GeneralTreeModelEventHandler generalTreeModelEventHandler) {
        this.observable.addEventHandler(generalTreeModelEventHandler);
    }

    public void removeObserver(GeneralTreeModelEventHandler generalTreeModelEventHandler) {
        this.observable.removeEventHandler(generalTreeModelEventHandler);
    }

    public void dispatchEvent(GeneralTreeModelEvent generalTreeModelEvent) {
        this.observable.dispatchEvent(generalTreeModelEvent);
    }

    public GeneralTreeNode getChild(GeneralTreeNode generalTreeNode, int n) {
        return generalTreeNode.getChildAt(n);
    }

    public int getChildCount(GeneralTreeNode generalTreeNode) {
        return generalTreeNode.getChildCount();
    }

    public boolean isLeaf(GeneralTreeNode generalTreeNode) {
        return generalTreeNode.allowsChildren();
    }

    public int getIndexOfChild(GeneralTreeNode generalTreeNode, GeneralTreeNode generalTreeNode2) {
        return generalTreeNode.indexOfChild(generalTreeNode2);
    }

    public void nodesWereInserted(GeneralTreeNode generalTreeNode, int[] nArray) {
        this.dispatchEvent(GeneralTreeModelEvent.nodesInserted(this, generalTreeNode, nArray));
    }

    public void nodesWereRemoved(GeneralTreeNode generalTreeNode, int[] nArray, GeneralTreeNode[] generalTreeNodeArray) {
        this.dispatchEvent(GeneralTreeModelEvent.nodesRemoved(this, generalTreeNode, nArray, generalTreeNodeArray));
    }

    public void nodesChanged(GeneralTreeNode generalTreeNode, int[] nArray) {
        this.dispatchEvent(GeneralTreeModelEvent.nodesChanged(this, generalTreeNode, nArray));
    }

    public void nodeStructureChanged(GeneralTreeNode generalTreeNode) {
        this.dispatchEvent(GeneralTreeModelEvent.structureChanged(this, generalTreeNode));
    }

    @Override
    public void contentsAdded(ListEvent listEvent) {
        GeneralTreeNode generalTreeNode = (GeneralTreeNode)listEvent.getSource();
        for (int n : listEvent.getIndices()) {
            GeneralTreeNode generalTreeNode2 = (GeneralTreeNode)generalTreeNode.getElementAt(n);
            generalTreeNode2.addEventHandler(this);
        }
        this.nodesWereInserted(generalTreeNode, listEvent.getIndices());
    }

    @Override
    public void contentsRemoved(ListEvent listEvent) {
        GeneralTreeNode[] generalTreeNodeArray = new GeneralTreeNode[listEvent.getRemoved().length];
        for (Object object : listEvent.getRemoved()) {
            GeneralTreeNode generalTreeNode = (GeneralTreeNode)object;
            generalTreeNode.removeEventHandler(this);
        }
        GeneralTreeNode generalTreeNode = (GeneralTreeNode)listEvent.getSource();
        this.nodesWereRemoved(generalTreeNode, listEvent.getIndices(), generalTreeNodeArray);
    }

    @Override
    public void contentsChanged(ListEvent listEvent) {
        GeneralTreeNode generalTreeNode = (GeneralTreeNode)listEvent.getSource();
        this.nodeStructureChanged(generalTreeNode);
    }

    @Override
    public void contentsMoved(ListEvent listEvent) {
    }
}

