/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.tree;

import com.ef_prime.rflow.core.common.tree.GeneralTreeModelEventHandler;
import com.ef_prime.rflow.core.common.tree.GeneralTreeNode;
import com.ef_prime.rflow.ui.common.event.Event;
import org.apache.commons.lang3.ArrayUtils;

public class GeneralTreeModelEvent
extends Event<GeneralTreeModelEventHandler> {
    private static final int CHANGED = 0;
    private static final int INSERTED = 1;
    private static final int REMOVED = 2;
    private static final int STRUCTURE_CHANGED = 3;
    private int type;
    private Object source;
    protected GeneralTreeNode path;
    protected int[] childIndices;
    protected GeneralTreeNode[] children;

    public static GeneralTreeModelEvent nodesChanged(Object object, GeneralTreeNode generalTreeNode, int[] nArray) {
        return new GeneralTreeModelEvent(0, object, generalTreeNode, nArray, null);
    }

    public static GeneralTreeModelEvent nodesInserted(Object object, GeneralTreeNode generalTreeNode, int[] nArray) {
        return new GeneralTreeModelEvent(1, object, generalTreeNode, nArray, null);
    }

    public static GeneralTreeModelEvent nodesRemoved(Object object, GeneralTreeNode generalTreeNode, int[] nArray, GeneralTreeNode[] generalTreeNodeArray) {
        return new GeneralTreeModelEvent(2, object, generalTreeNode, nArray, null);
    }

    public static GeneralTreeModelEvent structureChanged(Object object, GeneralTreeNode generalTreeNode) {
        return new GeneralTreeModelEvent(object, generalTreeNode);
    }

    private GeneralTreeModelEvent(int n, Object object, GeneralTreeNode generalTreeNode, int[] nArray, GeneralTreeNode[] generalTreeNodeArray) {
        this.source = object;
        this.path = generalTreeNode;
        this.childIndices = nArray;
        this.children = generalTreeNodeArray;
    }

    private GeneralTreeModelEvent(Object object, GeneralTreeNode generalTreeNode) {
        this.type = 3;
        this.source = object;
        this.path = generalTreeNode;
        this.childIndices = new int[0];
    }

    public Object getSource() {
        return this.source;
    }

    public GeneralTreeNode getPath() {
        return this.path;
    }

    public GeneralTreeNode[] getChildren() {
        return (GeneralTreeNode[])ArrayUtils.clone((Object[])this.children);
    }

    public int[] getChildIndices() {
        return ArrayUtils.clone((int[])this.childIndices);
    }

    @Override
    public void dispatch(GeneralTreeModelEventHandler generalTreeModelEventHandler) {
        switch (this.type) {
            case 0: {
                generalTreeModelEventHandler.treeNodesChanged(this);
                break;
            }
            case 1: {
                generalTreeModelEventHandler.treeNodesInserted(this);
                break;
            }
            case 2: {
                generalTreeModelEventHandler.treeNodesRemoved(this);
                break;
            }
            case 3: {
                generalTreeModelEventHandler.treeStructureChanged(this);
            }
        }
    }
}

