/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.tree;

import com.ef_prime.rflow.core.common.tree.GeneralTreeNode;
import java.util.ArrayDeque;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;

public class TreeUtility {
    public static GeneralTreeNode[] getPath(GeneralTreeNode generalTreeNode) {
        ArrayDeque<GeneralTreeNode> arrayDeque = new ArrayDeque<GeneralTreeNode>();
        arrayDeque.add(generalTreeNode);
        GeneralTreeNode generalTreeNode2 = generalTreeNode;
        while (generalTreeNode2.getParent() != null) {
            generalTreeNode2 = generalTreeNode2.getParent();
            arrayDeque.addFirst(generalTreeNode2);
        }
        return arrayDeque.toArray(new GeneralTreeNode[arrayDeque.size()]);
    }

    public static String getKey(GeneralTreeNode generalTreeNode) {
        return StringUtils.join((Object[])TreeUtility.getPath(generalTreeNode), (String)".");
    }

    public static String getAddress(GeneralTreeNode generalTreeNode) {
        return StringUtils.join((Object[])TreeUtility.getPath(generalTreeNode), (String)"/");
    }

    public static GeneralTreeNode getElement(String[] stringArray, GeneralTreeNode generalTreeNode) {
        ArrayDeque<GeneralTreeNode> arrayDeque = new ArrayDeque<GeneralTreeNode>();
        if (!generalTreeNode.getDisplayString().equals(stringArray[0])) {
            return null;
        }
        arrayDeque.add(generalTreeNode);
        GeneralTreeNode generalTreeNode2 = generalTreeNode;
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            for (int j = 0; j < generalTreeNode2.getChildCount(); ++j) {
                GeneralTreeNode generalTreeNode3 = generalTreeNode2.getChildAt(j);
                if (!generalTreeNode3.getDisplayString().equals(string)) continue;
                arrayDeque.add(generalTreeNode3);
                generalTreeNode2 = generalTreeNode3;
                break;
            }
            if (arrayDeque.size() > i) continue;
            return null;
        }
        return (GeneralTreeNode)arrayDeque.getLast();
    }

    public static boolean isSiblings(TreeNode[] treeNodeArray) {
        if (treeNodeArray.length < 2) {
            return true;
        }
        int n = 0;
        TreeNode treeNode = treeNodeArray[n++].getParent();
        while (n < treeNodeArray.length) {
            if (!treeNode.equals(treeNodeArray[n].getParent())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isSiblings(TreePath[] treePathArray) {
        if (treePathArray.length < 2) {
            return true;
        }
        int n = 0;
        if (treePathArray[0].getPathCount() == 1) {
            return false;
        }
        Object object = treePathArray[n++].getParentPath().getLastPathComponent();
        while (n < treePathArray.length) {
            if (treePathArray[n].getPathCount() == 1) {
                return false;
            }
            if (!object.equals(treePathArray[n].getParentPath().getLastPathComponent())) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

