/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.util;

import com.ef_prime.rflow.core.common.util.ColumnInfo;
import org.apache.commons.collections.bag.HashBag;

public class ColumnInfoBuilder {
    private int maxValuesStock;
    private int intCount;
    private int doubleCount;
    private double minNumber = Double.MAX_VALUE;
    private double maxNumber = Double.MIN_VALUE;
    private int stringCount;
    private int emptyCount;
    private int minStringLength = Integer.MAX_VALUE;
    private int maxStringLength;
    private HashBag numberValues = new HashBag();
    private HashBag stringValues = new HashBag();

    public ColumnInfoBuilder(int n) {
        this.maxValuesStock = n;
    }

    public ColumnInfo build() {
        return new ColumnInfo(this);
    }

    public int getIntCount() {
        return this.intCount;
    }

    public int getDoubleCount() {
        return this.doubleCount;
    }

    public double getMinNumber() {
        return this.minNumber;
    }

    public double getMaxNumber() {
        return this.maxNumber;
    }

    public int getStringCount() {
        return this.stringCount;
    }

    public int getEmptyCount() {
        return this.emptyCount;
    }

    public int getMinStringLength() {
        return this.minStringLength;
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public HashBag getNumberValues() {
        return this.numberValues;
    }

    public HashBag getStringValues() {
        return this.stringValues;
    }

    public ColumnInfoBuilder addIntCount(int n) {
        this.intCount += n;
        return this;
    }

    public ColumnInfoBuilder addDoubleCount(int n) {
        this.doubleCount += n;
        return this;
    }

    public ColumnInfoBuilder updateMinNumber(double d) {
        if (this.minNumber > d) {
            this.minNumber = d;
        }
        return this;
    }

    public ColumnInfoBuilder updateMaxNumber(double d) {
        if (this.maxNumber < d) {
            this.maxNumber = d;
        }
        return this;
    }

    public ColumnInfoBuilder addStringCount(int n) {
        this.stringCount += n;
        return this;
    }

    public ColumnInfoBuilder addEmptyCount(int n) {
        this.emptyCount += n;
        return this;
    }

    public ColumnInfoBuilder updateMinStringLength(int n) {
        if (this.minStringLength > n) {
            this.minStringLength = n;
        }
        return this;
    }

    public ColumnInfoBuilder updateMaxStringLength(int n) {
        if (this.maxStringLength < n) {
            this.maxStringLength = n;
        }
        return this;
    }

    public ColumnInfoBuilder addNumberValue(String string) {
        this.addValue(this.numberValues, string);
        return this;
    }

    public ColumnInfoBuilder addStringValue(String string) {
        this.addValue(this.stringValues, string);
        return this;
    }

    private void addValue(HashBag hashBag, String string) {
        if (hashBag.uniqueSet().size() >= this.maxValuesStock) {
            if (hashBag.contains((Object)string)) {
                hashBag.add((Object)string);
            }
        } else {
            hashBag.add((Object)string);
        }
    }

    public boolean isInteger() {
        return this.stringCount == 0 && this.doubleCount == 0 && this.intCount > 0;
    }

    public boolean isDouble() {
        return this.stringCount == 0 && this.doubleCount > 0;
    }

    public boolean isString() {
        return this.stringCount > 0;
    }
}

