/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.util;

import com.ef_prime.rflow.core.common.util.ColumnInfo;
import com.ef_prime.rflow.core.common.util.ColumnInfoBuilder;
import com.ef_prime.rflow.core.common.util.Utility;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ColumnTypeVerifier {
    private int maxValuesStock = 30;
    private List<ColumnInfoBuilder> columns = new ArrayList<ColumnInfoBuilder>();
    private List<Pair<Integer, Integer>> columnCounts = new ArrayList<Pair<Integer, Integer>>();

    public void setMaxValueStock(int n) {
        this.maxValuesStock = n;
    }

    public int getMaxValueStock() {
        return this.maxValuesStock;
    }

    public List<ColumnInfo> getColumnInfos() {
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>(this.columns.size());
        for (ColumnInfoBuilder columnInfoBuilder : this.columns) {
            arrayList.add(columnInfoBuilder.build());
        }
        return arrayList;
    }

    public List<Pair<Integer, Integer>> getColumnCounts() {
        return this.columnCounts;
    }

    public void verifyRow(int n, List<String> list) {
        if (this.columnCounts.isEmpty()) {
            this.columnCounts.add((Pair<Integer, Integer>)new ImmutablePair((Object)n, (Object)list.size()));
        } else {
            Pair<Integer, Integer> pair = this.columnCounts.get(this.columnCounts.size() - 1);
            if (((Integer)pair.getRight()).intValue() != list.size()) {
                this.columnCounts.add((Pair<Integer, Integer>)new ImmutablePair((Object)n, (Object)list.size()));
            }
        }
        while (this.columns.size() < list.size()) {
            this.columns.add(new ColumnInfoBuilder(this.maxValuesStock));
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            ColumnInfoBuilder columnInfoBuilder = this.columns.get(i);
            if (string.isEmpty()) {
                columnInfoBuilder.addEmptyCount(1);
                continue;
            }
            boolean bl = false;
            bl = NumberUtils.isNumber((String)string);
            if (bl) {
                try {
                    Double d = Double.parseDouble(string);
                    columnInfoBuilder.updateMinNumber(d).updateMaxNumber(d);
                    if (Utility.isInteger(string)) {
                        columnInfoBuilder.addIntCount(1);
                    } else {
                        columnInfoBuilder.addDoubleCount(1);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
            }
            if (bl) {
                columnInfoBuilder.addNumberValue(string);
                continue;
            }
            columnInfoBuilder.addStringCount(1).updateMinStringLength(string.length()).updateMaxStringLength(string.length()).addStringValue(string);
        }
    }
}

