/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class TypeDefProperties
extends Properties {
    private static final String COMMA_MARK = "[:comma;]";

    public synchronized Object setProperty(Key key, Object object) {
        if (key.getType().generics != null && ((Collection)object).contains(null)) {
            throw new NullPointerException();
        }
        Object object2 = this.setProperty(key.getKeyString(), TypeDefProperties.toString(key.getType(), object));
        try {
            return object2 == null ? null : TypeDefProperties.valueOf(key.getType(), (String)object2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized Object getProperty(Key key) {
        String string = super.getProperty(key.getKeyString());
        if (string == null) {
            return key.getDefaultValue();
        }
        try {
            return TypeDefProperties.valueOf(key.getType(), string);
        }
        catch (Exception exception) {
            this.setProperty(key, key.getDefaultValue());
            return key.getDefaultValue();
        }
    }

    public synchronized Object remove(Key key) {
        return super.remove(key.getKeyString());
    }

    public synchronized boolean containsKey(Key key) {
        return super.containsKey(key.getKeyString());
    }

    private static String toString(Type type, Object object) {
        if (object == null) {
            return null;
        }
        try {
            switch (type.ordinal()) {
                case 0: {
                    return object.toString();
                }
                case 1: {
                    return Boolean.toString((Boolean)object);
                }
                case 2: {
                    return Integer.toString((Integer)object);
                }
                case 3: {
                    return Long.toString((Long)object);
                }
                case 4: {
                    return Float.toString(((Float)object).floatValue());
                }
                case 5: {
                    return Double.toString((Double)object);
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return TypeDefProperties.listToString(type, object);
                }
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("the value Type don't match the Type of key");
        }
        throw new RuntimeException("Undefined type:" + type.toString());
    }

    private static Object valueOf(Type type, String string) {
        switch (type.ordinal()) {
            case 0: {
                return string;
            }
            case 1: {
                return Boolean.valueOf(string);
            }
            case 2: {
                return Integer.valueOf(string);
            }
            case 3: {
                return Long.valueOf(string);
            }
            case 4: {
                return Float.valueOf(string);
            }
            case 5: {
                return Double.valueOf(string);
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return TypeDefProperties.listValueOf(type, string);
            }
        }
        throw new RuntimeException("Undefined type:" + type.toString());
    }

    private static String listToString(Type type, Object object) {
        Object object2 = "";
        for (Object e : (List)object) {
            String string = TypeDefProperties.toString(type.generics, e);
            string = string.replaceAll(",", COMMA_MARK);
            object2 = (String)object2 + string + ",";
        }
        return ((String)object2).substring(0, ((String)object2).length() - 1);
    }

    private static Object listValueOf(Type type, String string) {
        String[] stringArray = string.split(",");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String string2 : stringArray) {
            String string3 = string2.replaceAll(COMMA_MARK, ",");
            arrayList.add(TypeDefProperties.valueOf(type.generics, string3));
        }
        return arrayList;
    }

    public static TypeDefProperties setDefaultProperties(TypeDefProperties typeDefProperties, Key[] keyArray) {
        for (Key key : keyArray) {
            typeDefProperties.setProperty(key, key.getDefaultValue());
        }
        return typeDefProperties;
    }

    public void update(Key[] keyArray) {
        HashSet<Object> hashSet = new HashSet<Object>(this.keySet());
        for (Key key : keyArray) {
            if (!this.containsKey(key)) {
                this.setProperty(key, key.getDefaultValue());
            }
            hashSet.remove(key.toString());
        }
        Iterator<Object> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.remove((String)iterator.next());
        }
    }

    public void setPropertyAll(TypeDefProperties typeDefProperties) {
        Enumeration<Object> enumeration = typeDefProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setProperty(string, typeDefProperties.getProperty(string));
        }
    }

    public static interface Key {
        public Type getType();

        public Object getDefaultValue();

        public String getKeyString();
    }

    public static enum Type {
        STRING,
        BOOLEAN,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        LIST_STRING(STRING),
        LIST_BOOLEAN(BOOLEAN),
        LIST_INTEGER(INTEGER),
        LIST_LONG(LONG),
        LIST_FLOAT(FLOAT),
        LIST_DOUBLE(DOUBLE);

        private Type generics;

        private Type() {
        }

        private Type(Type type) {
            this.generics = type;
        }
    }
}

