/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Deque;
import java.util.Iterator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class Utility {
    public static final String PROGRAM_DIR = Utility.getJarLocation(Utility.class);
    private static boolean installed;

    public static boolean isInstalled() {
        return installed;
    }

    public static String getJarLocation(Class<?> clazz) {
        File file = null;
        try {
            File file2 = new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
            file = file2.getParentFile();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (file == null) {
            file = new File("");
        }
        return FilenameUtils.separatorsToUnix((String)file.getAbsolutePath());
    }

    public static final File programDir() {
        return new File(PROGRAM_DIR);
    }

    public static String getPathStr(String string) {
        return PROGRAM_DIR + "/" + string;
    }

    public static Path getPath(String string) {
        return Paths.get(Utility.getPathStr(string), new String[0]);
    }

    public static <T> T cast(Object object) {
        return (T)object;
    }

    public static boolean isInteger(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        char c = string.charAt(0);
        if (c != '+' && c != '-' && !Character.isDigit(c)) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void addClassPath(URL uRL) throws IOException {
        try {
            Class<URLClassLoader> clazz = URLClassLoader.class;
            Method method = clazz.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)ClassLoader.getSystemClassLoader(), uRL);
            Object object = System.getProperty("java.class.path");
            if (object == null) {
                object = "";
            }
            object = (String)object + File.pathSeparator + Paths.get(uRL.toURI()).toAbsolutePath().toString();
            System.setProperty("java.class.path", (String)object);
        }
        catch (Throwable throwable) {
            throw new IOException("Failed to load " + String.valueOf(uRL), throwable);
        }
    }

    public static String[] getClassPaths() {
        String string = System.getProperty("java.class.path");
        if (string == null) {
            return new String[0];
        }
        String[] stringArray = string.split(File.pathSeparator);
        Path path = Paths.get(PROGRAM_DIR, new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            Path path2;
            if (stringArray[i].startsWith(".\\") || stringArray[i].startsWith("./")) {
                stringArray[i] = stringArray[i].substring(2);
            }
            if ((path2 = Paths.get(stringArray[i], new String[0])).isAbsolute()) continue;
            stringArray[i] = path.resolve(path2).toString();
        }
        return stringArray;
    }

    public static <V> V createInstance(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return (V)Utility.cast(clazz.newInstance());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void invokeStaticMethod(String string, String string2) throws InvocationTargetException {
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod(string2, new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception, "Failed to invoke class:" + string + " method:" + string2);
        }
    }

    public static String getJavaBitness() {
        String string = System.getProperty("sun.arch.data.model");
        if (string != null && (string.equals("32") || string.equals("64"))) {
            return string;
        }
        string = System.getProperty("os.arch");
        if (string.endsWith("86")) {
            return "32";
        }
        if (string.endsWith("64")) {
            return "64";
        }
        return null;
    }

    public static <E> E getFromLast(Deque<E> deque, int n) {
        Iterator<E> iterator = deque.descendingIterator();
        E e = null;
        for (int i = 0; i < n; ++i) {
            if (!iterator.hasNext()) continue;
            e = iterator.next();
        }
        return e;
    }

    static {
        try {
            installed = !Paths.get(Utility.class.getProtectionDomain().getCodeSource().getLocation().toURI()).endsWith("bin");
        }
        catch (URISyntaxException uRISyntaxException) {
            installed = true;
        }
    }
}

