/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.StringEscapeUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Deprecated
public class XMLWriter {
    private Writer out;
    private boolean indent;
    private Stack<Element> openElements;

    public XMLWriter(Writer writer) {
        this(writer, true);
    }

    public XMLWriter(Writer writer, boolean bl) {
        this.out = writer;
        this.indent = bl;
        this.openElements = new Stack();
    }

    public String currentElement() {
        if (this.openElements.isEmpty()) {
            return null;
        }
        return this.openElements.peek().name;
    }

    public boolean isCurrentElement(String string) {
        String string2 = this.currentElement();
        return string2 != null && string2.equals(string);
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void writeAttribute(String string, String string2) throws IOException {
        if (this.openElements.isEmpty()) {
            throw new IOException();
        }
        this.getCurrentOpenElement().addAttribute(new Attribute(string, string2));
    }

    public void writeCharacters(String string) throws IOException {
        if (this.openElements.isEmpty()) {
            throw new IOException();
        }
        this.getCurrentOpenElement().isText = true;
        this.flushOpenElement(false);
        this.out.write(this.replaceChar(string));
    }

    public void writeDTD(String string) throws IOException {
        this.out.write(string);
        if (!string.endsWith("\n")) {
            this.newLine();
        }
    }

    public void writeEndDocument() throws IOException {
    }

    public void writeEndElement() throws IOException {
        if (this.openElements.isEmpty()) {
            throw new IOException();
        }
        if (!this.getCurrentOpenElement().doneWrite && !this.getCurrentOpenElement().isEmpty) {
            this.flushOpenElement(true);
        } else {
            if (this.getCurrentOpenElement().isEmpty) {
                this.flushOpenElement(true);
            }
            Element element = this.getCurrentOpenElement();
            if (!element.isText) {
                this.tabs();
            }
            this.out.write("</" + element.name + ">");
            this.newLine();
            this.popOpenElement();
        }
    }

    public void writeEmptyElement(String string) throws IOException {
        this.flushOpenElement(false);
        this.pushOpenElement(new Element(string, true));
    }

    public void writeStartDocument(String string, String string2) throws IOException {
        try {
            this.out.write("<?xml version=\"" + string2 + "\" encoding=\"" + string + "\"?>");
            this.newLine();
        }
        catch (IOException iOException) {
            throw new IOException(iOException);
        }
    }

    public void writeStartElement(String string) throws IOException {
        this.flushOpenElement(false);
        this.pushOpenElement(new Element(string, false));
    }

    public void writeDomNode(Node node) throws IOException {
        if (node != null) {
            switch (node.getNodeType()) {
                case 1: {
                    org.w3c.dom.Element element = (org.w3c.dom.Element)node;
                    if (element.getLocalName() != null) {
                        this.writeStartElement(element.getLocalName());
                    } else {
                        this.writeStartElement(element.getNodeName());
                    }
                    this.writeDomAttributesToXmlStreamWriter(element);
                    for (Node node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        this.writeDomNode(node2);
                    }
                    this.writeEndElement();
                    break;
                }
                case 3: {
                    this.writeCharacters(node.getTextContent());
                }
            }
        }
    }

    private void writeDomAttributesToXmlStreamWriter(org.w3c.dom.Element element) throws IOException {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (node.getLocalName() != null) {
                this.writeAttribute(node.getLocalName(), node.getNodeValue());
                continue;
            }
            this.writeAttribute(node.getNodeName(), node.getNodeValue());
        }
    }

    private void pushOpenElement(Element element) {
        this.openElements.push(element);
    }

    private Element getCurrentOpenElement() {
        if (this.openElements.isEmpty()) {
            return null;
        }
        return this.openElements.peek();
    }

    private void flushOpenElement(boolean bl) throws IOException {
        Element element = this.getCurrentOpenElement();
        if (element != null && !element.doneWrite) {
            try {
                this.tabs();
                this.out.write("<" + element.name);
                for (Attribute attribute : element.attrs) {
                    this.out.write(" " + attribute.name + "=\"" + this.replaceChar(attribute.value) + "\"");
                }
                if (element.isEmpty || bl) {
                    this.out.write("/>");
                } else {
                    this.out.write(">");
                }
                if (!element.isText) {
                    this.newLine();
                }
                element.doneWrite = true;
                if (element.isEmpty || bl) {
                    this.openElements.pop();
                }
            }
            catch (IOException iOException) {
                throw new IOException(iOException);
            }
        }
    }

    private Element popOpenElement() throws IOException {
        if (this.openElements.isEmpty()) {
            throw new IOException();
        }
        return this.openElements.pop();
    }

    private String replaceChar(String string) {
        return StringEscapeUtils.escapeXml((String)string);
    }

    private void tabs() throws IOException {
        if (this.indent) {
            for (int i = 0; i < this.openElements.size() - 1; ++i) {
                this.out.write("\t");
            }
        }
    }

    private void newLine() throws IOException {
        if (this.indent) {
            this.out.write("\n");
        }
    }

    private static class Element {
        String name;
        List<Attribute> attrs = new ArrayList<Attribute>();
        boolean doneWrite = false;
        boolean isEmpty;
        boolean isText = false;

        public Element(String string, boolean bl) {
            this.name = string;
            this.isEmpty = bl;
        }

        public void addAttribute(Attribute attribute) {
            this.attrs.add(attribute);
        }
    }

    private static class Attribute {
        String name;
        String value;

        public Attribute(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

