/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.xml;

import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.common.xml.XmlElement;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlUtility {
    private static final Logger LOGGER = Logger.getLogger(XmlUtility.class.getName());
    private static DocumentBuilder BUILDER;

    public static Document createDocument() {
        return BUILDER.newDocument();
    }

    public static Node getFirst(String string, Element element) {
        return element.getElementsByTagName(string).item(0);
    }

    public static String getText(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            return node.getNodeValue();
        }
        return null;
    }

    public static Element getChild(String string, Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !string.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    public static List<Element> getChildren(String string, Element element) {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !string.equals(node.getNodeName())) continue;
            arrayList.add((Element)node);
        }
        return arrayList;
    }

    public static List<Element> elements(Node node) {
        NodeList nodeList = node.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            arrayList.add((Element)node2);
        }
        return arrayList;
    }

    public static List<Element> elementsOfFirstNode(String string, Element element) {
        Element element2 = XmlUtility.getChild(string, element);
        if (element2 == null) {
            return new ArrayList<Element>();
        }
        return XmlUtility.elements(element2);
    }

    public static void writeXml(File file, Document document) throws IOException {
        XmlUtility.writeXml(file, document, 0);
    }

    public static void writeXml(File file, Document document, int n) throws IOException {
        Transformer transformer = XmlUtility.createTransformer(n);
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
            transformer.transform(new DOMSource(document), new StreamResult(bufferedWriter));
        }
    }

    private static Transformer createTransformer(int n) throws IOException {
        Transformer transformer;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformer = transformerFactory.newTransformer();
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        if (n > 0) {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", Integer.toString(n));
        }
        return transformer;
    }

    public static void writeElement(Writer writer, Element element) throws IOException {
        Transformer transformer = XmlUtility.createTransformer(0);
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        try {
            transformer.transform(new DOMSource(element), new StreamResult(writer));
        }
        catch (TransformerException transformerException) {
            throw new IOException(transformerException);
        }
    }

    public static Document readXml(File file) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            Document document = BUILDER.parse(new InputSource(bufferedReader));
            return document;
        }
    }

    public static Document readXml(InputStream inputStream) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
            Document document = BUILDER.parse(new InputSource(bufferedReader));
            return document;
        }
    }

    public static <T extends XmlElement> T readXml(File file, T t) throws IOException {
        Document document = XmlUtility.readXml(file);
        t.loadElement(document.getDocumentElement(), new XmlContext());
        return t;
    }

    public static void writeXml(File file, String string, XmlElement xmlElement) throws IOException {
        Document document = XmlUtility.createDocument();
        XmlUtility.addElement(new XmlContext(), document, string, xmlElement);
        XmlUtility.writeXml(file, document);
    }

    public static void addElement(XmlContext xmlContext, Document document, String string, XmlElement xmlElement) {
        Element element = document.createElement(string);
        xmlElement.storeToElement(xmlContext, document, element);
        document.appendChild(element);
    }

    public static void addElement(XmlContext xmlContext, Document document, Element element, String string, XmlElement xmlElement) {
        Element element2 = document.createElement(string);
        xmlElement.storeToElement(xmlContext, document, element2);
        element.appendChild(element2);
    }

    public static <T extends XmlElement> T loadElement(XmlContext xmlContext, Element element, String string, Map<String, Class<? extends T>> map) throws IOException {
        try {
            String string2 = element.getAttribute(string);
            if (string2 == null) {
                throw new IllegalStateException("element does not have attribute: " + string);
            }
            Class<T> clazz = map.get(string2);
            if (clazz == null) {
                throw new IllegalStateException("classMap does not contain type: " + string2);
            }
            XmlElement xmlElement = (XmlElement)clazz.newInstance();
            xmlElement.loadElement(element, xmlContext);
            return (T)xmlElement;
        }
        catch (Exception exception) {
            throw new IOException("Failed to load xml element: ", exception);
        }
    }

    public static String getAttribute(Element element, String string, String string2) {
        String string3 = element.getAttribute(string);
        if (string3.isEmpty()) {
            return string2;
        }
        return string3;
    }

    static {
        try {
            BUILDER = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.log(Level.SEVERE, parserConfigurationException.getMessage(), parserConfigurationException);
            BUILDER = null;
        }
    }
}

