/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.feature.backup;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditBackups;
import com.ef_prime.rflow.core.base.FileEditFiles;
import com.ef_prime.rflow.core.base.FileEditManager;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.feature.backup.FlowBackupManager;
import com.ef_prime.rflow.core.flow.FlowModel;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BackupThread
extends Thread
implements ValueChangeEventHandler {
    private static final Logger LOGGER = Logger.getLogger(BackupThread.class.getName());
    private boolean inProgress;
    private int pause;
    private long wait;
    private boolean doBackup = true;
    private FileEditManager fileEditManager;
    private Object lock = new Object();

    public BackupThread(FileEditManager fileEditManager) {
        super("Backup");
        this.fileEditManager = fileEditManager;
        this.setDaemon(true);
        this.doBackup = Rflow.settings().getValue(Settings.AUTO_BACKUP);
        Integer n = Rflow.settings().getValue(Settings.AUTO_BACKUP_INTERVAL);
        this.wait = n * 1000;
        Rflow.settings().addEventHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block12: while (true) {
            Iterator<FileEdit> iterator = this.lock;
            synchronized (iterator) {
                try {
                    this.lock.wait(this.wait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.doBackup || this.pause >= 1) continue;
            this.inProgress = true;
            try {
                iterator = this.fileEditManager.getFileEdits().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block12;
                    FileEdit fileEdit = iterator.next();
                    try {
                        if (fileEdit instanceof FlowModel) {
                            FlowModel flowModel = (FlowModel)fileEdit;
                            if (!flowModel.isDirtyForBackup()) continue;
                            try {
                                FlowBackupManager.backupCurrentFlow(flowModel, true);
                            }
                            catch (ConcurrentModificationException concurrentModificationException) {}
                            continue;
                        }
                        if (fileEdit.noSave()) {
                            FileEditFiles.getInstance().backup(fileEdit);
                            continue;
                        }
                        FileEditBackups.getInstance().backup(fileEdit);
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.SEVERE, "Failed to backup flow file.", exception);
                    }
                }
            }
            finally {
                this.inProgress = false;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBackup() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public void restart() {
        if (this.pause > 0) {
            --this.pause;
        }
    }

    public void pause() {
        ++this.pause;
        while (this.inProgress) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        if (Settings.AUTO_BACKUP.equals(valueChangeEvent.getKey())) {
            this.doBackup = Rflow.settings().getValue(Settings.AUTO_BACKUP);
        } else if (Settings.AUTO_BACKUP_INTERVAL.equals(valueChangeEvent.getKey())) {
            Integer n = Rflow.settings().getValue(Settings.AUTO_BACKUP_INTERVAL);
            this.wait = n * 1000;
        }
    }
}

