/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.feature.backup;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.RflowActions;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.app.file.ZipFileUtility;
import com.ef_prime.rflow.core.base.FileEditManager;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.feature.backup.BackupChangedEvent;
import com.ef_prime.rflow.core.feature.backup.BackupEntry;
import com.ef_prime.rflow.core.flow.ElementWriter;
import com.ef_prime.rflow.core.flow.FlowDataWriter;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.GraphWriter;
import com.ef_prime.rflow.core.util.ReadException;
import com.ef_prime.rflow.ui.common.component.LockFile;
import com.ef_prime.rflow.ui.common.event.EventManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class FlowBackupManager {
    private static final Logger LOGGER = Logger.getLogger(FlowBackupManager.class.getName());
    public static final DateFormat DATEFORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
    public static final String DEFAULT_RFLOW = "default.rflow";
    private static final String CONFIG = "config";

    public static String getCurrentDateZip() {
        return DATEFORMAT.format(new Date()) + ".zip";
    }

    public static File getFile(FlowModel flowModel, BackupEntry backupEntry) throws IOException {
        return new File(backupEntry.isTemporary() ? FlowBackupManager.getTempBackupFolder(flowModel) : FlowBackupManager.getBackupFolder(flowModel), backupEntry.getFileName());
    }

    public static File getBackupFolder(FlowModel flowModel) {
        return new File(flowModel.getFlowDataDir(), "backup");
    }

    public static File getTempBackupFolder(FlowModel flowModel) throws IOException {
        return new File(flowModel.getUserFlowTempDir(), "backup");
    }

    public static LockFile getLockFile(FlowModel flowModel) {
        return LockFile.createLockFile(FlowBackupManager.getBackupFolder(flowModel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void saveToBackup(FlowModel flowModel, File file) throws IOException {
        LockFile lockFile = FlowBackupManager.getLockFile(flowModel);
        lockFile.lock();
        try {
            File file2 = FlowBackupManager.getBackupFolder(flowModel);
            File file3 = new File(file2, FlowBackupManager.getCurrentDateZip());
            ZipFileUtility.saveSingleFileToZip(file, file3, DEFAULT_RFLOW);
            int n = 1024 * Rflow.settings().getValue(Settings.BACKUP_SIZE);
            File[] fileArray = FlowBackupManager.getBackupFiles(file2);
            Map<String, String> map = FlowBackupManager.readConfig(flowModel);
            long l = 0L;
            for (File file4 : fileArray) {
                if (!file4.isFile() || file4.getName().equals(CONFIG)) continue;
                if (l > (long)n) {
                    if (map.containsKey(file4.getName())) continue;
                    FileUtils.deleteQuietly((File)file4);
                    continue;
                }
                l += file4.length();
            }
        }
        finally {
            lockFile.release();
        }
        FlowBackupManager.fireBackupChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void saveToTempBackup(FlowModel flowModel, File file) throws IOException {
        LockFile lockFile = FlowBackupManager.getLockFile(flowModel);
        lockFile.lock();
        try {
            Calendar calendar;
            File file2 = FlowBackupManager.getTempBackupFolder(flowModel);
            File file3 = new File(file2, FlowBackupManager.getCurrentDateZip());
            ZipFileUtility.saveSingleFileToZip(file, file3, DEFAULT_RFLOW);
            try {
                calendar = FlowBackupManager.getCalendar(file3);
                FlowBackupManager.toUnitTime(calendar, 5);
            }
            catch (ParseException parseException) {
                LOGGER.log(Level.SEVERE, "Invalid back file name.", parseException);
                lockFile.release();
                return;
            }
            int n = 1024 * Rflow.settings().getValue(Settings.BACKUP_SIZE);
            File[] fileArray = FlowBackupManager.getBackupFiles(file2);
            long l = 0L;
            for (File file4 : fileArray) {
                if (!file4.isFile() || file4.equals(file3)) continue;
                if (l > (long)n) {
                    FileUtils.deleteQuietly((File)file4);
                    continue;
                }
                try {
                    Calendar calendar2 = FlowBackupManager.getCalendar(file4);
                    FlowBackupManager.toUnitTime(calendar2, 5);
                    if (calendar.equals(calendar2)) {
                        FileUtils.deleteQuietly((File)file4);
                        continue;
                    }
                    l += file4.length();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        finally {
            lockFile.release();
        }
        FlowBackupManager.fireBackupChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveTempBackups(FlowModel flowModel) {
        try {
            LockFile lockFile = FlowBackupManager.getLockFile(flowModel);
            lockFile.lock();
            try {
                File[] fileArray;
                Path path = FlowBackupManager.getBackupFolder(flowModel).toPath();
                File file = FlowBackupManager.getTempBackupFolder(flowModel);
                for (File file2 : fileArray = FlowBackupManager.getBackupFiles(file)) {
                    try {
                        Files.move(file2.toPath(), path.resolve(file2.getName()), new CopyOption[0]);
                    }
                    catch (Exception exception) {
                        LOGGER.warning("Failed to move a temporary backup file.");
                    }
                }
            }
            finally {
                lockFile.release();
                FlowBackupManager.fireBackupChangedEvent();
            }
        }
        catch (Exception exception) {
            LOGGER.warning("Failed to move temporary backup files.");
        }
    }

    public static File[] getBackupFiles(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return new File[0];
        }
        Arrays.sort(fileArray, new FileSorter());
        return fileArray;
    }

    public static Date getDate(File file) throws ParseException {
        return FlowBackupManager.getDate(file.getName());
    }

    public static Date getDate(String string) throws ParseException {
        String string2 = FilenameUtils.removeExtension((String)string);
        return DATEFORMAT.parse(string2);
    }

    private static Calendar getCalendar(File file) throws ParseException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(FlowBackupManager.getDate(file));
        return gregorianCalendar;
    }

    private static void toUnitTime(Calendar calendar, int n) {
        int n2 = calendar.get(12);
        n2 -= n2 % n;
        calendar.set(12, n2);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void restoreFromBackupFile(FileEditManager fileEditManager, FlowModel flowModel, File file) throws IOException, ReadException {
        Object object;
        Object object2;
        boolean bl = FileUtility.isChild(Rflow.project().getTempDir(), file);
        if (bl) {
            object2 = flowModel.getFlowDataDir().toPath().resolve("backuptemp");
            if (!Files.exists((Path)object2, new LinkOption[0])) {
                Files.createDirectories((Path)object2, new FileAttribute[0]);
            }
            object = object2.resolve(file.getName());
            Files.move(file.toPath(), (Path)object, StandardCopyOption.REPLACE_EXISTING);
            file = object.toFile();
        }
        flowModel.setDirty(false);
        flowModel.setClearOnUnloadLock(true);
        fileEditManager.unload(flowModel, flowModel);
        flowModel.setClearOnUnloadLock(false);
        object2 = FlowBackupManager.getLockFile(flowModel);
        ((LockFile)object2).lock();
        try {
            object = new ZipFile(file);
            try {
                Enumeration<? extends ZipEntry> enumeration = ((ZipFile)object).entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    if (zipEntry.isDirectory() || !DEFAULT_RFLOW.equals(zipEntry.getName())) continue;
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((ZipFile)object).getInputStream(zipEntry), "UTF-8"));){
                        RflowActions rflowActions = Rflow.getInstance().getActions();
                        File file2 = flowModel.getWorkingFile();
                        FlowModel flowModel2 = rflowActions.openFlowFile(bufferedReader, file2, false, null, false);
                        flowModel2.setDirty(true);
                        flowModel2.setDirtyAfterRestore(false);
                    }
                }
            }
            finally {
                ((ZipFile)object).close();
            }
        }
        finally {
            ((LockFile)object2).release();
        }
        if (bl) {
            FileUtils.deleteQuietly((File)file.getParentFile());
        }
        FlowBackupManager.fireBackupChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<BackupEntry> readEntries(FlowModel flowModel) throws IOException {
        LockFile lockFile = FlowBackupManager.getLockFile(flowModel);
        lockFile.lock();
        try {
            Map<String, String> map = FlowBackupManager.readConfig(flowModel);
            File file = FlowBackupManager.getTempBackupFolder(flowModel);
            File file2 = FlowBackupManager.getBackupFolder(flowModel);
            File[] fileArray = FlowBackupManager.getBackupFiles(file);
            File[] fileArray2 = FlowBackupManager.getBackupFiles(file2);
            ArrayList<BackupEntry> arrayList = new ArrayList<BackupEntry>();
            for (File file3 : fileArray) {
                if (!file3.isFile()) continue;
                try {
                    FlowBackupManager.getDate(file3);
                    arrayList.add(new BackupEntry(file3.getName(), true));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (File file3 : fileArray2) {
                if (!file3.isFile()) continue;
                String string = map.get(file3.getName());
                try {
                    FlowBackupManager.getDate(file3);
                    arrayList.add(new BackupEntry(file3.getName(), false, string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ArrayList<BackupEntry> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            lockFile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> readConfig(FlowModel flowModel) throws IOException {
        String[] stringArray = new HashMap();
        File file = new File(FlowBackupManager.getBackupFolder(flowModel), CONFIG);
        if (!file.exists()) {
            return stringArray;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            String[] stringArray2;
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringArray2 = string.split("\t", 2);
                if (stringArray2.length < 2) continue;
                stringArray.put(stringArray2[0], stringArray2[1]);
            }
            stringArray2 = stringArray;
            return stringArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void writeConfig(FlowModel flowModel, List<BackupEntry> list) throws Exception {
        LockFile lockFile = FlowBackupManager.getLockFile(flowModel);
        lockFile.lock();
        try {
            File file = new File(FlowBackupManager.getBackupFolder(flowModel), CONFIG);
            File file2 = new File(FlowBackupManager.getBackupFolder(flowModel), "config.tmp");
            if (file2.exists()) {
                FileUtils.forceDelete((File)file2);
            }
            if (file.exists()) {
                FileUtils.moveFile((File)file, (File)file2);
            }
            try {
                try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
                    for (BackupEntry backupEntry : list) {
                        if (backupEntry.isTemporary() || !backupEntry.isProtected()) continue;
                        bufferedWriter.write(backupEntry.getFileName());
                        bufferedWriter.write("\t");
                        bufferedWriter.write(backupEntry.getTag());
                        bufferedWriter.write("\n");
                    }
                }
                FileUtils.deleteQuietly((File)file2);
            }
            catch (Exception exception) {
                if (file.exists()) {
                    FileUtils.deleteQuietly((File)file);
                }
                if (file2.exists()) {
                    FileUtils.moveFile((File)file2, (File)file);
                }
                throw exception;
            }
        }
        finally {
            lockFile.release();
        }
        FlowBackupManager.fireBackupChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void removeBackupFile(FlowModel flowModel, BackupEntry[] backupEntryArray) throws IOException {
        LockFile lockFile = FlowBackupManager.getLockFile(flowModel);
        lockFile.lock();
        try {
            for (BackupEntry backupEntry : backupEntryArray) {
                FileUtils.forceDelete((File)FlowBackupManager.getFile(flowModel, backupEntry));
            }
        }
        finally {
            lockFile.release();
        }
        FlowBackupManager.fireBackupChangedEvent();
    }

    public static void backupCurrentFlow(FlowModel flowModel, boolean bl) throws Exception {
        File file = flowModel.getBackupFile();
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            return;
        }
        File file2 = new File(file.getParentFile(), file.getName() + ".tmp");
        ElementWriter[] elementWriterArray = new ElementWriter[]{new GraphWriter(flowModel.getLayout().fullCopy(), flowModel.getFlowSetting(), flowModel.getRootTask(), flowModel.getFlowProperties())};
        if (file2.exists()) {
            FileUtils.forceDelete((File)file2);
        }
        new FlowDataWriter().write(file2, elementWriterArray);
        if (file.exists()) {
            FileUtils.forceDelete((File)file);
        }
        FileUtils.moveFile((File)file2, (File)file);
        if (bl) {
            FlowBackupManager.saveToTempBackup(flowModel, file);
        } else {
            FlowBackupManager.saveToBackup(flowModel, file);
        }
        FlowBackupManager.fireBackupChangedEvent();
        flowModel.setDirtyForBackup(false);
    }

    private static void fireBackupChangedEvent() {
        EventManager.getInstance().dispatchEvent(new BackupChangedEvent());
    }

    private static class FileSorter
    implements Comparator<File> {
        private FileSorter() {
        }

        @Override
        public int compare(File file, File file2) {
            String string = file.getName();
            String string2 = file2.getName();
            return string.compareTo(string2) * -1;
        }
    }
}

