/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.feature.history;

import com.ef_prime.rflow.core.feature.history.FlowNodeFlavor;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.node.NodeModelController;
import com.ef_prime.rflow.node.NodeModelManager;
import com.ef_prime.rflow.ui.common.item.AbstractItem;
import com.ef_prime.rflow.ui.common.view.View;
import com.google.common.collect.Lists;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class FlowNodeTransferable
extends AbstractItem {
    private final List<FlowNode> nodes;
    private final DataFlavor[] flavors = new DataFlavor[]{FlowNodeFlavor.getInstance()};

    public FlowNodeTransferable(FlowNode flowNode) {
        this.nodes = Lists.newArrayList((Object[])new FlowNode[]{flowNode});
        this.init();
    }

    public FlowNodeTransferable(List<FlowNode> list) {
        this.nodes = Collections.unmodifiableList(list);
        this.init();
    }

    private void init() {
        this.setName(this.nodes.stream().map(flowNode -> flowNode.getTitle()).collect(Collectors.joining(", ")));
        if (this.nodes.size() > 0) {
            this.setIcon(this.nodes.get(0).getSmallIcon());
        }
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (FlowNodeFlavor.getInstance().equals(dataFlavor)) {
            return this.nodes;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (int i = 0; i < this.flavors.length; ++i) {
            if (!dataFlavor.equals(this.flavors[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public View createPreviewView() {
        if (this.nodes.size() != 1) {
            return null;
        }
        FlowNode flowNode = this.nodes.get(0);
        NodeModelController nodeModelController = NodeModelManager.getModelController(flowNode.getModel().getClass());
        return nodeModelController.createView(flowNode, true);
    }
}

