/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.feature.history;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.RflowEventHandler;
import com.ef_prime.rflow.core.task.SavedTaskGroup;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.task.TaskEvent;
import com.ef_prime.rflow.core.task.TaskEventHandler;
import com.ef_prime.rflow.core.task.TaskGroup;
import com.ef_prime.rflow.ui.common.component.TreeIterator;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FilenameUtils;
import org.jdesktop.swingx.tree.TreeModelSupport;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class HistoryManager
implements RflowEventHandler,
TaskEventHandler,
TreeModelListener {
    private static final Logger LOGGER = Logger.getLogger(HistoryManager.class.getName());
    private DefaultTreeModel treeModel;
    private Task root = new TaskGroup(null, "Root");
    private DefaultTreeModel oldTreeModel;
    private Task oldRoot;
    private TaskTreeTableModel treeTableModel;
    private static HistoryManager instance = new HistoryManager();
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
    private static final SimpleDateFormat LOCAL_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");

    private HistoryManager() {
        this.treeModel = new DefaultTreeModel(this.root, true);
        this.treeModel.addTreeModelListener(this);
        this.oldRoot = new TaskGroup(null, "Root");
        this.oldTreeModel = new DefaultTreeModel(this.oldRoot, true);
        this.treeTableModel = new TaskTreeTableModel((TreeTableNode)this.root.getTreeTableNode(), Lists.newArrayList((Object[])new String[]{"Title", " ", "Result"}));
        Rflow.getInstance().addRflowEventHandler(this);
    }

    public static HistoryManager getInstance() {
        return instance;
    }

    public Task getRoot() {
        return this.root;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public DefaultTreeModel getOldTreeModel() {
        return this.oldTreeModel;
    }

    public DefaultTreeTableModel getTreeTableModel() {
        return this.treeTableModel;
    }

    public void add(Task task) {
        this.treeModel.insertNodeInto(task, this.root, this.root.getChildCount());
    }

    public void remove(int n) {
        this.treeModel.removeNodeFromParent((Task)this.root.getChildAt(n));
    }

    public void remove(Task task) {
        this.treeModel.removeNodeFromParent(task);
    }

    @Override
    public void rflowProjectDidStart() {
        File file = Rflow.project().getLogDir();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            try {
                Date date = DATE_FORMAT.parse(FilenameUtils.removeExtension((String)file2.getName()));
                String string = LOCAL_DATE_FORMAT.format(date);
                SavedTaskGroup savedTaskGroup = new SavedTaskGroup(string, file2);
                this.oldRoot.add(savedTaskGroup);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        this.oldTreeModel.reload();
    }

    @Override
    public void rflowProjectWillEnd() {
        if (this.root.getChildCount() > 0) {
            String string = DATE_FORMAT.format(Calendar.getInstance(UTC).getTime());
            try {
                this.root.storeToYaml(new File(Rflow.project().getLogDir(), string + ".yaml"));
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
        for (int i = this.root.getChildCount() - 1; i >= 0; --i) {
            this.remove(i);
        }
        this.oldRoot = new TaskGroup(null, "Root");
        this.oldTreeModel.setRoot(this.oldRoot);
        this.oldTreeModel.reload();
    }

    @Override
    public void rflowWillShutdown() {
    }

    @Override
    public void taskStateChanged(final TaskEvent taskEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HistoryManager.this.treeModel.nodeChanged(taskEvent.getTask());
            }
        });
    }

    private TreePath getTreeTableModelPath(TreeModelEvent treeModelEvent) {
        Task task = (Task)treeModelEvent.getTreePath().getLastPathComponent();
        TreePath treePath = new TreePath(this.treeTableModel.getPathToRoot((TreeTableNode)task.getTreeTableNode()));
        return treePath;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.treeTableModel.getModelSupport().fireChildrenChanged(this.getTreeTableModelPath(treeModelEvent), treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        Object[] objectArray = treeModelEvent.getChildren();
        if (objectArray == null) {
            return;
        }
        for (Object object : objectArray) {
            Task task = (Task)object;
            TreeIterator treeIterator = new TreeIterator(task);
            while (treeIterator.hasNext()) {
                Task task2 = (Task)treeIterator.next();
                if (task2.containsTaskEventHandler(this)) continue;
                task2.addTaskEventHandler(this);
            }
        }
        this.treeTableModel.getModelSupport().fireChildrenAdded(this.getTreeTableModelPath(treeModelEvent), treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        Object[] objectArray = treeModelEvent.getChildren();
        if (objectArray == null) {
            return;
        }
        for (Object object : objectArray) {
            Task task = (Task)object;
            TreeIterator treeIterator = new TreeIterator(task);
            while (treeIterator.hasNext()) {
                Task task2 = (Task)treeIterator.next();
                task2.removeTaskEventHandler(this);
            }
        }
        this.treeTableModel.getModelSupport().fireChildrenRemoved(this.getTreeTableModelPath(treeModelEvent), treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.treeTableModel.getModelSupport().fireTreeStructureChanged(this.getTreeTableModelPath(treeModelEvent));
    }

    static {
        DATE_FORMAT.setTimeZone(UTC);
    }

    private static class TaskTreeTableModel
    extends DefaultTreeTableModel {
        public TaskTreeTableModel(TreeTableNode treeTableNode, List<?> list) {
            super(treeTableNode, list);
        }

        public TreeModelSupport getModelSupport() {
            return this.modelSupport;
        }
    }
}

