/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.feature.search;

import com.ef_prime.rflow.core.flow.FlowNode;
import java.text.ParseException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SearchContext {
    private FlowNode searchRootNode;
    private String query;
    private boolean matchObject;
    private boolean regularExpression;
    private boolean searchAll;
    private boolean matchCase;
    private boolean scriptSearch;
    private Pattern regexPattern;
    private Pattern regexPatternMulti;

    public SearchContext(FlowNode flowNode, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.searchRootNode = flowNode;
        this.query = string;
        this.matchObject = bl;
        this.matchCase = bl2;
        this.regularExpression = bl3;
        this.searchAll = bl4;
        this.scriptSearch = bl5;
    }

    public SearchContext(String string, boolean bl, boolean bl2, boolean bl3) {
        this.query = string;
        this.matchObject = bl;
        this.matchCase = bl2;
        this.regularExpression = bl3;
    }

    public FlowNode getSearchRootNode() {
        return this.searchRootNode;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isMatchObject() {
        return this.matchObject;
    }

    public boolean isRegularExpression() {
        return this.regularExpression;
    }

    public boolean isSearchAll() {
        return this.searchAll;
    }

    public Pattern getRegexPattern() throws ParseException {
        try {
            if (this.regexPattern == null) {
                this.regexPattern = Pattern.compile(this.query, this.isMatchCase() ? 0 : 2);
            }
            return this.regexPattern;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new ParseException(patternSyntaxException.getPattern(), patternSyntaxException.getIndex());
        }
    }

    public Pattern getMultiLineRegexPattern() throws ParseException {
        try {
            if (this.regexPatternMulti == null) {
                int n = 8;
                if (!this.isMatchCase()) {
                    n |= 2;
                }
                this.regexPatternMulti = Pattern.compile(this.query, n);
            }
            return this.regexPatternMulti;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new ParseException(patternSyntaxException.getPattern(), patternSyntaxException.getIndex());
        }
    }

    public boolean isMatchCase() {
        return this.matchCase;
    }

    public boolean isScriptSearch() {
        return this.scriptSearch;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append((Object)this.searchRootNode);
        hashCodeBuilder.append((Object)this.query);
        hashCodeBuilder.append(this.matchObject);
        hashCodeBuilder.append(this.regularExpression);
        hashCodeBuilder.append(this.searchAll);
        hashCodeBuilder.append(this.matchCase);
        return hashCodeBuilder.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SearchContext)) {
            return false;
        }
        SearchContext searchContext = (SearchContext)object;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.searchRootNode, (Object)searchContext.searchRootNode);
        equalsBuilder.append((Object)this.query, (Object)searchContext.query);
        equalsBuilder.append(this.matchObject, searchContext.matchObject);
        equalsBuilder.append(this.regularExpression, searchContext.regularExpression);
        equalsBuilder.append(this.searchAll, searchContext.searchAll);
        equalsBuilder.append(this.matchCase, searchContext.matchCase);
        return equalsBuilder.isEquals();
    }
}

