/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.feature.search;

import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.flow.FlowNode;
import javax.swing.tree.DefaultMutableTreeNode;

public class SearchNode
extends DefaultMutableTreeNode {
    private String title;
    private FlowNode flowNode;
    private SearchResult[] searchResults;

    public static SearchNode createContainerNode(String string) {
        return new SearchNode(string);
    }

    public static SearchNode createNoHitFlowNode(FlowNode flowNode) {
        return new SearchNode(flowNode, null);
    }

    public static SearchNode createHitFlowNode(FlowNode flowNode, SearchResult[] searchResultArray) {
        return new SearchNode(flowNode, searchResultArray);
    }

    public SearchNode(String string) {
        this.title = string;
    }

    public SearchNode(FlowNode flowNode, SearchResult[] searchResultArray) {
        this.flowNode = flowNode;
        this.searchResults = searchResultArray;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    public boolean isFlowNode() {
        return this.flowNode != null;
    }

    public void setSearchResults(SearchResult[] searchResultArray) {
        this.searchResults = searchResultArray;
    }

    public SearchResult[] getSearchResults() {
        return this.searchResults;
    }

    public SearchResult getSearchResult(int n) {
        return this.searchResults[n];
    }

    public int getResultCount() {
        if (this.searchResults != null) {
            return this.searchResults.length;
        }
        return 0;
    }

    public int getHitCount() {
        if (this.searchResults != null) {
            int n = 0;
            for (SearchResult searchResult : this.searchResults) {
                if (!searchResult.isEnabled()) continue;
                ++n;
            }
            return n;
        }
        return 0;
    }

    public boolean containsHit() {
        if (this.isLeaf()) {
            return this.getHitCount() > 0;
        }
        if (this.getHitCount() > 0) {
            return true;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!((SearchNode)this.getChildAt(i)).containsHit()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    @Override
    public String toString() {
        if (this.title != null) {
            return this.title;
        }
        if (this.isFlowNode()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.flowNode.getTitle());
            if (this.getHitCount() > 0) {
                stringBuilder.append(" [");
                stringBuilder.append(this.getHitCount());
                stringBuilder.append("]");
            }
            return stringBuilder.toString();
        }
        return "";
    }
}

