/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.feature.search;

import com.ef_prime.rflow.core.app.r.script.RTokenMaker;
import com.ef_prime.rflow.core.feature.search.SearchContext;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.ui.app.r.script.RScriptUtility;
import com.ef_prime.rflow.ui.common.component.CodingTextArea;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.SearchEngine;

public class SearchUtility {
    private static final Logger LOGGER = Logger.getLogger(SearchUtility.class.getName());

    public static List<TextSearchResult> searchRScript(SearchContext searchContext, RSyntaxDocument rSyntaxDocument) {
        ArrayList<TextSearchResult> arrayList = new ArrayList<TextSearchResult>();
        try {
            if (searchContext.isMatchObject()) {
                Element element = rSyntaxDocument.getDefaultRootElement();
                for (int i = 0; i < element.getElementCount(); ++i) {
                    Token token = rSyntaxDocument.getTokenListForLine(i);
                    SearchUtility.searchToken(searchContext, token, arrayList);
                }
            } else {
                SearchUtility.searchText(searchContext, rSyntaxDocument.getText(0, rSyntaxDocument.getLength()), arrayList);
            }
        }
        catch (ParseException | BadLocationException exception) {
            return new ArrayList<TextSearchResult>(0);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to search", exception);
            return new ArrayList<TextSearchResult>(0);
        }
        return arrayList;
    }

    public static List<TextSearchResult> searchRScript(SearchContext searchContext, String string) {
        ArrayList<TextSearchResult> arrayList = new ArrayList<TextSearchResult>();
        try {
            if (searchContext.isMatchObject()) {
                SearchUtility.searchToken(searchContext, string, new RTokenMaker(), arrayList);
            } else {
                SearchUtility.searchText(searchContext, string, arrayList);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<TextSearchResult> searchText(SearchContext searchContext, String string, boolean bl) {
        ArrayList<TextSearchResult> arrayList = new ArrayList<TextSearchResult>();
        try {
            if (searchContext.isMatchObject()) {
                if (bl) {
                    if (SearchUtility.matchText(searchContext, string)) {
                        arrayList.add(new TextSearchResult(0, string.length()));
                    }
                } else {
                    SearchUtility.searchWord(searchContext, string, arrayList);
                }
            } else {
                SearchUtility.searchText(searchContext, string, arrayList);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return arrayList;
    }

    private static void searchText(SearchContext searchContext, String string, List<TextSearchResult> list) throws ParseException {
        if (string.isEmpty()) {
            return;
        }
        if (searchContext.isRegularExpression()) {
            Pattern pattern = searchContext.getMultiLineRegexPattern();
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                list.add(new TextSearchResult(matcher.start(), matcher.end() - matcher.start()));
            }
        } else {
            String string2 = searchContext.getQuery();
            if (!searchContext.isMatchCase()) {
                string = string.toLowerCase();
                string2 = string2.toLowerCase();
            }
            int n = 0;
            while (n >= 0 && n < string.length()) {
                if ((n = string.indexOf(string2, n)) < 0) continue;
                list.add(new TextSearchResult(n, string2.length()));
                n += string2.length();
            }
        }
    }

    private static void searchWord(SearchContext searchContext, String string, List<TextSearchResult> list) throws ParseException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            while (n2 < n && Character.isLetterOrDigit(string.charAt(n2))) {
                ++n2;
            }
            CharSequence charSequence = string.subSequence(n3, n2);
            if (SearchUtility.matchText(searchContext, charSequence)) {
                list.add(new TextSearchResult(n3, n2 - n3));
            }
            while (n2 < n && !Character.isLetterOrDigit(string.charAt(n2))) {
                ++n2;
            }
        }
    }

    private static boolean matchText(SearchContext searchContext, CharSequence charSequence) throws ParseException {
        if (searchContext.isRegularExpression()) {
            Matcher matcher = searchContext.getRegexPattern().matcher(charSequence);
            return matcher.matches();
        }
        String string = searchContext.getQuery();
        return searchContext.isMatchCase() ? StringUtils.equals((CharSequence)charSequence, (CharSequence)string) : StringUtils.equalsIgnoreCase((CharSequence)charSequence, (CharSequence)string);
    }

    private static void searchToken(SearchContext searchContext, String string, RTokenMaker rTokenMaker, List<TextSearchResult> list) {
        Token token = rTokenMaker.getTokenList(new Segment(string.toCharArray(), 0, string.length()), 0, 0);
        try {
            SearchUtility.searchToken(searchContext, token, list);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private static void searchToken(SearchContext searchContext, Token token, List<TextSearchResult> list) throws ParseException {
        while (token != null) {
            if (token.getType() != 0 && token.length() > 0) {
                if (token.getType() == 13 || token.getType() == 14 || token.getType() == 15 || token.getType() == 1) {
                    int n = var3_3 + token.length();
                    for (var3_3 = token.getTextOffset(); var3_3 < n; ++var3_3) {
                        int n2;
                        int n3 = var3_3;
                        char[] cArray = token.getTextArray();
                        if (token.getType() == 1) {
                            while (var3_3 < n && Character.isLetterOrDigit(cArray[var3_3])) {
                                ++var3_3;
                            }
                        } else {
                            while (var3_3 < n && (Character.isUnicodeIdentifierPart(cArray[var3_3]) || cArray[var3_3] == '.')) {
                                ++var3_3;
                            }
                        }
                        if ((n2 = var3_3 - n3) <= 0) continue;
                        boolean bl = false;
                        if (searchContext.isRegularExpression()) {
                            var9_11 = searchContext.getRegexPattern();
                            var10_12 = ((Pattern)var9_11).matcher(new Segment(cArray, n3, n2));
                            bl = ((Matcher)var10_12).matches();
                        } else {
                            var9_11 = searchContext.getQuery();
                            var10_12 = new String(cArray, n3, n2);
                            boolean bl2 = bl = searchContext.isMatchCase() ? ((String)var9_11).equals(var10_12) : ((String)var9_11).equalsIgnoreCase((String)var10_12);
                        }
                        if (!bl) continue;
                        list.add(new TextSearchResult(token.getOffset() + (n3 - token.getTextOffset()), n2));
                    }
                } else {
                    var3_3 = 0;
                    if (searchContext.isRegularExpression()) {
                        Pattern pattern = searchContext.getRegexPattern();
                        Matcher matcher = pattern.matcher(RScriptUtility.tokenToSegment(token));
                        var3_3 = matcher.matches() ? 1 : 0;
                    } else {
                        var3_3 = searchContext.getQuery().equals(token.getLexeme()) ? 1 : 0;
                    }
                    if (var3_3 != 0) {
                        list.add(new TextSearchResult(token.getOffset(), token.length()));
                    }
                }
            }
            token = token.getNextToken();
        }
    }

    public static String replaceStringForRegex(SearchContext searchContext, String string, int n, int n2, String string2) {
        try {
            if (searchContext.isMatchObject()) {
                return SearchUtility.replaceObjectStringForRegex(searchContext, string.substring(n, n + n2), string2);
            }
            return SearchUtility.replaceStringForRegex(searchContext, string, n, string2);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private static String replaceStringForRegex(SearchContext searchContext, String string, int n, String string2) throws ParseException {
        Pattern pattern = searchContext.getMultiLineRegexPattern();
        Matcher matcher = pattern.matcher(string);
        if (matcher.find(n)) {
            return SearchEngine.getReplacementText((Matcher)matcher, (CharSequence)string2);
        }
        return null;
    }

    private static String replaceObjectStringForRegex(SearchContext searchContext, String string, String string2) throws ParseException {
        Pattern pattern = searchContext.getRegexPattern();
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return SearchEngine.getReplacementText((Matcher)matcher, (CharSequence)string2);
        }
        return null;
    }

    public static void repositionSearchResultsAfterReplace(SearchResult[] searchResultArray, TextSearchResult textSearchResult, int n) {
        for (SearchResult searchResult : searchResultArray) {
            TextSearchResult textSearchResult2;
            if (!(searchResult instanceof TextSearchResult) || (textSearchResult2 = (TextSearchResult)searchResult).getOffset() <= textSearchResult.getOffset()) continue;
            textSearchResult2.setOffset(textSearchResult2.getOffset() - textSearchResult.getLength() + n);
        }
    }

    public static void repositionSearchResultsAfterReplace(Iterable<TextSearchResult> iterable, TextSearchResult textSearchResult, int n) {
        for (TextSearchResult textSearchResult2 : iterable) {
            if (textSearchResult2.getOffset() <= textSearchResult.getOffset()) continue;
            textSearchResult2.setOffset(textSearchResult2.getOffset() - textSearchResult.getLength() + n);
        }
    }

    public static boolean isNext(JTextArea jTextArea, SearchContext searchContext, boolean bl, List<TextSearchResult> list) {
        if (list == null) {
            return false;
        }
        int n = bl ? jTextArea.getSelectionStart() + 1 : jTextArea.getSelectionStart() - 1;
        TextSearchResult textSearchResult = SearchUtility.findMatch(jTextArea, searchContext, bl, list, n);
        if (textSearchResult == null) {
            return false;
        }
        if (bl) {
            return textSearchResult.getOffset() >= n;
        }
        return textSearchResult.getOffset() <= n;
    }

    public static boolean find(JTextArea jTextArea, SearchContext searchContext, boolean bl, List<TextSearchResult> list) {
        int n = bl ? jTextArea.getSelectionStart() + 1 : jTextArea.getSelectionStart() - 1;
        return SearchUtility.find(jTextArea, searchContext, bl, list, n);
    }

    public static boolean find(JTextArea jTextArea, SearchContext searchContext, boolean bl, List<TextSearchResult> list, int n) {
        TextSearchResult textSearchResult = SearchUtility.findMatch(jTextArea, searchContext, bl, list, n);
        if (textSearchResult == null) {
            return false;
        }
        jTextArea.select(textSearchResult.getOffset(), textSearchResult.getOffset() + textSearchResult.getLength());
        return true;
    }

    private static TextSearchResult findMatch(JTextArea jTextArea, SearchContext searchContext, boolean bl, List<TextSearchResult> list, int n) {
        TextSearchResult textSearchResult = null;
        int n2 = Collections.binarySearch(list, new TextSearchResult(n, 0));
        if (n2 < 0) {
            int n3 = n2 = bl ? Math.abs(n2) - 1 : Math.abs(n2) - 2;
            if (n2 >= 0 && n2 < list.size()) {
                textSearchResult = list.get(n2);
            }
        } else {
            textSearchResult = list.get(n2);
        }
        return textSearchResult;
    }

    public static boolean canReplace(CodingTextArea codingTextArea, SearchContext searchContext, List<TextSearchResult> list) {
        if (list == null) {
            return false;
        }
        int n = codingTextArea.getSelectionStart();
        TextSearchResult textSearchResult = SearchUtility.findCurrentMatch(codingTextArea, searchContext, list, n);
        return textSearchResult != null && textSearchResult.isEnabled();
    }

    public static boolean replace(CodingTextArea codingTextArea, SearchContext searchContext, String string, List<TextSearchResult> list) {
        int n = codingTextArea.getSelectionStart();
        return SearchUtility.replace(codingTextArea, searchContext, string, list, n);
    }

    public static boolean replace(CodingTextArea codingTextArea, SearchContext searchContext, String string, List<TextSearchResult> list, int n) {
        TextSearchResult textSearchResult = SearchUtility.findCurrentMatch(codingTextArea, searchContext, list, n);
        if (textSearchResult == null || !textSearchResult.isEnabled()) {
            return false;
        }
        if (searchContext.isRegularExpression() && (string = SearchUtility.replaceStringForRegex(searchContext, codingTextArea.getText(), textSearchResult.getOffset(), textSearchResult.getLength(), string)) == null) {
            return false;
        }
        codingTextArea.replaceRange(string, textSearchResult.getOffset(), textSearchResult.getOffset() + textSearchResult.getLength());
        SearchUtility.repositionSearchResultsAfterReplace(list, textSearchResult, string.length());
        textSearchResult.setLength(string.length());
        textSearchResult.setEnabled(false);
        codingTextArea.select(textSearchResult.getOffset(), textSearchResult.getOffset() + textSearchResult.getLength());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceAll(CodingTextArea codingTextArea, SearchContext searchContext, String string, List<TextSearchResult> list) {
        codingTextArea.beginAtomicEdit();
        try {
            for (TextSearchResult textSearchResult : list) {
                boolean bl = SearchUtility.replace(codingTextArea, searchContext, string, list, textSearchResult.getOffset());
                if (bl) continue;
                boolean bl2 = false;
                return bl2;
            }
        }
        finally {
            codingTextArea.endAtomicEdit();
        }
        return true;
    }

    private static TextSearchResult findCurrentMatch(CodingTextArea codingTextArea, SearchContext searchContext, List<TextSearchResult> list, int n) {
        int n2 = Collections.binarySearch(list, new TextSearchResult(n, 0));
        if (n2 < 0) {
            return null;
        }
        return list.get(n2);
    }
}

