/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandAdapter;
import com.ef_prime.rflow.core.app.r.console.CompoundCommand;
import com.ef_prime.rflow.core.app.r.console.Executor;
import com.ef_prime.rflow.core.flow.CacheData;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.flow.FlowState;
import com.ef_prime.rflow.core.util.OperationFailedException;
import com.ef_prime.rflow.resource.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class CacheRunHandler {
    private static final Logger LOGGER = Logger.getLogger(CacheRunHandler.class.getName());
    private static final String BACKUP_EXTENSION = ".bak";
    private FlowModel flowModel;
    private static final int CACHE_STATE_OK = 0;
    private static final int CACHE_STATE_NOT_EXIST = 1;
    private static final int CACHE_STATE_COMMAND_MISMATCH = 2;
    private static final int CACHE_STATE_SIZE_MISMATCH = 4;

    public CacheRunHandler(FlowModel flowModel) {
        this.flowModel = flowModel;
    }

    public void init() {
        for (FlowNode flowNode : this.getState().getCacheNodes()) {
            CacheData cacheData = flowNode.getCacheData();
            String string = cacheData.isCommand() ? cacheData.getCommand() : CacheRunHandler.getCommand(flowNode);
            File file = new File(this.getCacheDir(true), cacheData.getFile().getName());
            if (!file.exists()) {
                file = new File(this.getCacheDir(false), cacheData.getFile().getName());
            }
            flowNode.setCacheData(new CacheData(file, string, cacheData.getDate(), cacheData.getSize(), cacheData.isValid()));
        }
    }

    protected FlowModel getFlowModel() {
        return this.flowModel;
    }

    protected FlowState getState() {
        return this.flowModel.getState();
    }

    private static String getCommand(FlowNode flowNode) {
        FlowRunOption flowRunOption = new FlowRunOption();
        flowRunOption.setDontSplitCommand(true);
        return Executor.getScriptExecutor().getScript(flowNode, null, flowRunOption);
    }

    public void checkCacheStatus() throws OperationFailedException {
        FlowNode[] flowNodeArray = this.getState().getCacheNodes().toArray(new FlowNode[0]);
        if (this.isCacheEmpty()) {
            return;
        }
        Object object = "";
        for (int i = 0; i < flowNodeArray.length; ++i) {
            String string;
            FlowNode flowNode = flowNodeArray[i];
            if (!flowNode.getCacheData().isValid() || (string = this.checkCacheState(flowNode)) == null) continue;
            object = (String)object + Messages.getString("Message.node_name") + " : " + flowNode.getTitle() + "\n";
            object = (String)object + string + "\n\n";
        }
        if (((String)object).length() > 0) {
            throw new OperationFailedException((String)object);
        }
    }

    public void saveCaches() throws IOException {
        File file = this.getCacheDir(false);
        File file2 = this.getCacheDir(true);
        for (FlowNode flowNode : this.getState().getCacheNodes()) {
            CacheData cacheData = flowNode.getCacheData();
            File file3 = null;
            file3 = cacheData.getFile();
            if (!file3.exists()) continue;
            boolean bl = FileUtility.isChild(file2, file3);
            File file4 = new File(file, file3.getName());
            if (bl) {
                if (!cacheData.isValid()) continue;
                if (file4.exists()) {
                    FileUtils.forceDelete((File)file4);
                }
                FileUtils.forceMkdir((File)file4.getParentFile());
                FileUtils.moveFile((File)file3, (File)file4);
                CacheData cacheData2 = flowNode.getCacheData();
                this.getState().setCache(flowNode, new CacheData(file4, cacheData2.getCommand(), cacheData2.getDate(), cacheData2.getSize(), cacheData2.isValid()));
                continue;
            }
            if (cacheData.isValid() || !file4.exists()) continue;
            FileUtils.deleteQuietly((File)file4);
        }
    }

    public void markCache(FlowNode flowNode) throws IOException {
        File file = this.getCacheFileNew(flowNode);
        String string = CacheRunHandler.getCommand(flowNode);
        this.getState().setCache(flowNode, new CacheData(file, string, null, 0L, false));
        this.cacheStateChanged();
    }

    public Command cacheNode(final FlowNode flowNode) throws IOException {
        File file;
        CompoundCommand compoundCommand = new CompoundCommand();
        final File file2 = this.getCacheFileNew(flowNode);
        File file3 = file = flowNode.isCacheData() ? this.getBackupFile(flowNode.getCacheData().getFile().getName()) : null;
        if (!file2.getParentFile().exists() && !file2.getParentFile().mkdirs()) {
            throw new IOException("failed to make cache folder");
        }
        final String string = CacheRunHandler.getCommand(flowNode);
        BasicCommand basicCommand = new BasicCommand("save.image(file=" + RUtility.quotedPath(file2.getAbsolutePath()) + ")");
        basicCommand.addCommandListener(new CommandAdapter(){

            @Override
            public void commandFinished(Command command) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                long l = file2.length();
                CacheRunHandler.this.getState().setCache(flowNode, new CacheData(file2, string, gregorianCalendar, l, true));
                CacheRunHandler.this.cacheStateChanged();
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
        });
        compoundCommand.add(basicCommand);
        return compoundCommand;
    }

    public Command loadCache(FlowNode flowNode) throws FileNotFoundException {
        File file = flowNode.getCacheData().getFile();
        String string = this.checkCacheState(flowNode);
        if (string != null) {
            flowNode.getCacheData().setValid(false);
            this.cacheVaildChanged();
            throw new FileNotFoundException(string);
        }
        return new BasicCommand("load(file=" + RUtility.quotedPath(file.getAbsolutePath()) + ")");
    }

    public void removeCache(FlowNode flowNode, boolean bl, boolean bl2) throws OperationFailedException {
        try {
            File file = flowNode.getCacheData().getFile();
            boolean bl3 = FileUtility.isChild(this.getCacheDir(true), file);
            if (!bl2) {
                if (file.exists() && bl3 && !file.delete()) {
                    throw new IOException("failed to delete RData cache file");
                }
            } else {
                File file2 = this.getBackupFile(file.getName());
                if (file.exists()) {
                    if (file2.exists() && !file2.delete()) {
                        throw new IOException("failed to delete RData cache file");
                    }
                    if (!file2.getParentFile().exists() && !file2.getParentFile().mkdirs()) {
                        throw new IOException("failed to create backup folder");
                    }
                    if (bl3) {
                        if (!file.renameTo(file2)) {
                            throw new IOException("failed to move cache file");
                        }
                    } else if (!file2.createNewFile()) {
                        throw new IOException("failed to create dummy cache flag");
                    }
                }
            }
            if (bl) {
                this.getState().removeCacheNode(flowNode);
            } else {
                flowNode.getCacheData().setValid(false);
            }
            this.cacheStateChanged();
        }
        catch (IOException iOException) {
            throw new OperationFailedException(Messages.getString("Error.cache_delete") + ": " + flowNode.getTitle(), true);
        }
    }

    private String checkCacheState(FlowNode flowNode) {
        String string = "";
        switch (this.checkCacheExists(flowNode)) {
            case 1: {
                string = Messages.getString("Error.no_cache");
                break;
            }
            case 2: {
                string = Messages.getString("Error.cache_command_mismatch");
                break;
            }
            case 4: {
                string = Messages.getString("Error.cache_size_mismatch");
            }
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    private int checkCacheExists(FlowNode flowNode) {
        CacheData cacheData = flowNode.getCacheData();
        File file = cacheData.getFile();
        if (!cacheData.isDate()) {
            cacheData.setValid(false);
            return 0;
        }
        if (!file.exists()) {
            cacheData.setValid(false);
            return 1;
        }
        if (!CacheRunHandler.getCommand(flowNode).equals(cacheData.getCommand())) {
            cacheData.setValid(false);
            return 2;
        }
        if (cacheData.isSize() && cacheData.getSize() != file.length()) {
            cacheData.setValid(false);
            return 4;
        }
        cacheData.setValid(true);
        this.cacheVaildChanged();
        return 0;
    }

    public void restoreCache(FlowNode flowNode, boolean bl) {
        if (bl) {
            this.getState().setCache(flowNode, flowNode.getCacheData());
            this.cacheVaildChanged();
            return;
        }
        try {
            boolean bl2;
            File file = flowNode.getCacheData().getFile();
            File file2 = this.getBackupFile(file.getName());
            boolean bl3 = bl2 = file2.length() == 0L;
            if (file2.exists()) {
                String string;
                if (flowNode.getCacheData().isCommand() && !(string = CacheRunHandler.getCommand(flowNode)).equals(flowNode.getCacheData().getCommand())) {
                    throw new IOException("saved cache command conflicts with current flow command");
                }
                if (!bl2) {
                    if (file.exists() && !file.delete()) {
                        throw new IOException("failed to delete cache");
                    }
                    if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                        throw new IOException("failed to create cache folder");
                    }
                    if (!file2.renameTo(file)) {
                        throw new IOException("failed to move backup cache");
                    }
                } else {
                    file2.delete();
                }
                flowNode.getCacheData().setValid(true);
                this.getState().setCache(flowNode, flowNode.getCacheData());
            }
            this.cacheVaildChanged();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Failed to restore cache.", iOException);
        }
    }

    public void cleanCaches() {
        File file = this.getCacheDir(false);
        if (!file.exists()) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        File[] fileArray = this.getState().getCacheNodes().iterator();
        while (fileArray.hasNext()) {
            File[] fileArray2 = fileArray.next();
            hashSet.add(fileArray2.getCacheData().getFile().getName());
        }
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.isFile() || !FilenameUtils.isExtension((String)file2.getName(), (String)"RData") || hashSet.contains(file2.getName())) continue;
            FileUtils.deleteQuietly((File)file2);
        }
        if (file.listFiles().length == 0) {
            file.delete();
        }
    }

    private File getCacheFileNew(FlowNode flowNode) throws IOException {
        File file;
        String string = CacheRunHandler.getCommand(flowNode);
        File file2 = this.getCacheDir(true);
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("failed to create cache dir");
        }
        int n = 0;
        while (true) {
            String string2 = n == 0 ? "" : String.valueOf(n);
            Long l = new Long(System.currentTimeMillis());
            String string3 = Integer.toHexString(string.hashCode() ^ l.hashCode());
            String string4 = "cache" + string2 + "_" + string3;
            file = new File(file2, string4 + ".RData");
            if (!file.exists() && !this.getState().isCacheFile(string4 + ".RData")) break;
            ++n;
        }
        return file;
    }

    public void clearAllCache() {
        for (FlowNode flowNode : this.getState().getCacheNodes()) {
            if (!flowNode.getCacheData().isValid()) continue;
            flowNode.getCacheData().setValid(false);
        }
        this.cacheVaildChanged();
    }

    public File getCacheDir(boolean bl) {
        File file = bl ? this.flowModel.getFlowDataTempDir() : this.flowModel.getFlowDataDir();
        return new File(file, "cache");
    }

    private File getBackupFile(String string) {
        File file = new File(this.getCacheDir(true), string);
        return new File(file.getParentFile(), file.getName() + BACKUP_EXTENSION);
    }

    private boolean isCacheEmpty() {
        return this.getState().getCacheNodes().isEmpty();
    }

    protected void cacheVaildChanged() {
    }

    protected void cacheStateChanged() {
    }
}

