/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.flow.ElementReader;
import com.ef_prime.rflow.core.flow.SingleElementReader;
import com.ef_prime.rflow.core.util.ReadException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class FlowDataReader {
    public void read(File file, ElementReader[] elementReaderArray) throws ReadException, IOException {
        this.read(new InputSource(file.toURI().toASCIIString()), elementReaderArray);
    }

    public void read(Reader reader, ElementReader[] elementReaderArray) throws ReadException, IOException {
        this.read(new InputSource(reader), elementReaderArray);
    }

    private void read(InputSource inputSource, ElementReader[] elementReaderArray) throws ReadException, IOException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputSource, (DefaultHandler)new Handler(elementReaderArray));
        }
        catch (SAXException sAXException) {
            throw new ReadException(sAXException);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ReadException(parserConfigurationException);
        }
    }

    private static class Handler
    extends DefaultHandler2 {
        private ElementReader readerManager = new ElementReader();
        private StringBuilder sb;
        private Document document = XmlUtility.createDocument();
        private Deque<Element> stack = new ArrayDeque<Element>();

        Handler(ElementReader[] elementReaderArray) {
            for (ElementReader elementReader : elementReaderArray) {
                this.readerManager.addElementReader(elementReader);
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.sb = new StringBuilder();
            this.pushElement(string3, attributes, this.stack);
            SingleElementReader singleElementReader = this.readerManager.getSingleElementReader(string3);
            if (singleElementReader == null) {
                return;
            }
            singleElementReader.startElement(attributes);
        }

        private void pushElement(String string, Attributes attributes, Deque<Element> deque) {
            Element element = this.document.createElement(string);
            for (int i = 0; i < attributes.getLength(); ++i) {
                element.setAttribute(attributes.getQName(i), attributes.getValue(i));
            }
            if (!deque.isEmpty()) {
                deque.peek().appendChild(element);
            }
            deque.push(element);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            SingleElementReader singleElementReader;
            String string4 = this.sb.toString();
            Element element = this.stack.pop();
            if (!string4.isEmpty() && !element.hasChildNodes()) {
                element.appendChild(this.document.createTextNode(string4));
            }
            if ((singleElementReader = this.readerManager.getSingleElementReader(string3)) == null) {
                return;
            }
            singleElementReader.endElement(string4, element);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.sb.append(cArray, n, n2);
        }
    }
}

