/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.core.flow.ElementWriter;
import com.ef_prime.rflow.core.util.XMLException;
import com.ef_prime.rflow.core.util.XMLWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;

public class FlowDataWriter {
    private static final String RFLOW = "rflow";

    public void write(File file, ElementWriter[] elementWriterArray) throws IOException, XMLException {
        XMLWriter xMLWriter = new XMLWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
        this.write(xMLWriter, elementWriterArray, true);
    }

    public String writeToString(ElementWriter[] elementWriterArray) throws XMLException {
        StringWriter stringWriter = new StringWriter();
        this.write(new XMLWriter(stringWriter), elementWriterArray, false);
        return stringWriter.getBuffer().toString();
    }

    public void write(XMLWriter xMLWriter, ElementWriter[] elementWriterArray, boolean bl) throws XMLException {
        this.write(xMLWriter, elementWriterArray, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(XMLWriter xMLWriter, ElementWriter[] elementWriterArray, boolean bl, boolean bl2) throws XMLException {
        try {
            this.writeInternal(xMLWriter, elementWriterArray, bl);
        }
        finally {
            if (bl2 && xMLWriter != null) {
                xMLWriter.close();
            }
        }
    }

    private void writeInternal(XMLWriter xMLWriter, ElementWriter[] elementWriterArray, boolean bl) throws XMLException {
        if (bl) {
            xMLWriter.writeStartDocument("UTF-8", "1.0");
            xMLWriter.writeDTD(this.getDTD());
            xMLWriter.writeStartElement(RFLOW);
        }
        for (ElementWriter elementWriter : elementWriterArray) {
            elementWriter.write(xMLWriter);
        }
        if (bl) {
            xMLWriter.writeEndElement();
            xMLWriter.writeEndDocument();
        }
    }

    private String getDTD() {
        return "<!DOCTYPE rflow [\n<!ENTITY lt \"&#38;#60;\">\n<!ENTITY gt \"&#62;\">\n<!ENTITY amp \"&#38;#38;\">\n<!ENTITY apos \"&#39;\">\n<!ENTITY quot \"&#34;\">\n]>";
    }
}

