/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.core.flow.FlowGraphEvent;
import com.ef_prime.rflow.core.flow.FlowGraphEventHandler;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.node.NodeModelEvent;
import com.ef_prime.rflow.node.NodeModelEventHandler;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.event.GraphEvent;
import edu.uci.ics.jung.graph.event.GraphEventListener;
import edu.uci.ics.jung.graph.event.GraphEventType;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class FlowGraph
extends SparseGraph {
    private FlowModel flowModel;
    private FlowNode parentNode = null;
    private Deque<Vertex> vertexList = new ArrayDeque<Vertex>();
    private boolean adjusting;
    private EventSupport<FlowGraphEvent, FlowGraphEventHandler> graphEventSupport = new EventSupport();
    private EventSupport<NodeModelEvent, NodeModelEventHandler> eventSupport = new EventSupport();

    public FlowGraph() {
        this.addListener(new GraphEventHandler(), (GraphEventType)GraphEventType.ALL_SINGLE_EVENTS);
    }

    public boolean isRootGraph() {
        return this.parentNode == null || this.parentNode.isRootNode();
    }

    public void setParentNode(FlowNode flowNode) {
        this.parentNode = flowNode;
    }

    public FlowNode getParentNode() {
        return this.parentNode;
    }

    public void setFlowModel(FlowModel flowModel) {
        this.flowModel = flowModel;
    }

    public FlowModel getFlowModel() {
        if (!this.isRootGraph()) {
            FlowGraph flowGraph = this.getParentNode().getGraph();
            return flowGraph == null ? null : flowGraph.getFlowModel();
        }
        return this.flowModel;
    }

    public void setAdjusting(boolean bl) {
        this.adjusting = bl;
    }

    public boolean isAdjusting() {
        return this.adjusting;
    }

    public boolean contains(Vertex vertex) {
        return vertex != null && vertex.getGraph() == this;
    }

    public Iterator<Vertex> getVertexIterator() {
        return this.vertexList.iterator();
    }

    public Iterator<Vertex> getReverseVertexIterator() {
        return this.vertexList.descendingIterator();
    }

    public Deque<Vertex> getVertexList() {
        return new ArrayDeque<Vertex>(this.vertexList);
    }

    public void toTop(Vertex vertex) {
        if (this.vertexList.remove(vertex)) {
            this.vertexList.addLast(vertex);
        }
    }

    public Vertex addVertex(Vertex vertex) {
        this.vertexList.add(vertex);
        return super.addVertex(vertex);
    }

    public void removeVertex(Vertex vertex) {
        this.graphEventSupport.dispatchEvent(new FlowGraphEvent((FlowNode)vertex));
        this.vertexList.remove(vertex);
        super.removeVertex(vertex);
    }

    public void addGraphEventHandler(FlowGraphEventHandler flowGraphEventHandler) {
        this.graphEventSupport.addEventHandler(flowGraphEventHandler);
    }

    public void removeGraphEventHandler(FlowGraphEventHandler flowGraphEventHandler) {
        this.graphEventSupport.removeEventHandler(flowGraphEventHandler);
    }

    public void addNodeModelEventHandler(NodeModelEventHandler nodeModelEventHandler) {
        this.eventSupport.addEventHandler(nodeModelEventHandler);
    }

    public void removeNodeModelEventHandler(NodeModelEventHandler nodeModelEventHandler) {
        this.eventSupport.removeEventHandler(nodeModelEventHandler);
    }

    private class GraphEventHandler
    implements NodeModelEventHandler,
    GraphEventListener {
        private GraphEventHandler() {
        }

        @Override
        public void nodeModelChanged(NodeModelEvent nodeModelEvent) {
            FlowGraph.this.eventSupport.dispatchEvent(nodeModelEvent);
        }

        public void vertexAdded(GraphEvent graphEvent) {
            FlowNode flowNode = (FlowNode)graphEvent.getGraphElement();
            flowNode.getModel().addNodeModelEventHandler(this);
        }

        public void vertexRemoved(GraphEvent graphEvent) {
            FlowNode flowNode = (FlowNode)graphEvent.getGraphElement();
            flowNode.getModel().removeNodeModelEventHandler(this);
        }

        public void edgeAdded(GraphEvent graphEvent) {
        }

        public void edgeRemoved(GraphEvent graphEvent) {
        }
    }
}

