/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowNode;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import edu.uci.ics.jung.visualization.LayoutMutable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Set;

public class FlowLayout
extends AbstractLayout
implements LayoutMutable {
    private int gridDist = 10;
    private boolean movingNodes;
    private Comparator<FlowNode> layoutNodeComparator;

    public FlowLayout(FlowGraph flowGraph) {
        super((Graph)flowGraph);
    }

    protected void initializeLocations() {
    }

    public Point2D getCentroid(Iterable<FlowNode> iterable) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        for (FlowNode flowNode : iterable) {
            Point2D point2D = this.getLocation((ArchetypeVertex)flowNode);
            d += point2D.getX();
            d2 += point2D.getY();
            ++n;
        }
        return new Point2D.Float((float)(d /= (double)n), (float)(d2 /= (double)n));
    }

    public FlowGraph getGraph() {
        return (FlowGraph)super.getGraph();
    }

    public void advancePositions() {
    }

    protected void initialize_local_vertex(Vertex vertex) {
    }

    public boolean incrementsAreDone() {
        return true;
    }

    public boolean isIncremental() {
        return false;
    }

    public void restart() {
    }

    public void addVertex(Vertex vertex, double d, double d2) {
        this.initLocation(vertex);
        this.forceMove(vertex, d, d2);
    }

    public void initLocation(Vertex vertex) {
        Coordinates coordinates = this.getCoordinates((ArchetypeVertex)vertex);
        if (coordinates == null) {
            coordinates = new Coordinates();
            vertex.addUserDatum(this.getBaseKey(), (Object)coordinates, UserData.REMOVE);
        }
    }

    public void update() {
        try {
            for (Vertex vertex : this.getGraph().getVertices()) {
                Coordinates coordinates = this.getCoordinates((ArchetypeVertex)vertex);
                if (coordinates != null) continue;
                coordinates = new Coordinates();
                vertex.addUserDatum(this.getBaseKey(), (Object)coordinates, UserData.REMOVE);
                this.initializeLocation(vertex, coordinates, this.getCurrentSize());
                this.initialize_local_vertex(vertex);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.update();
        }
        this.initialize_local();
    }

    public boolean forceMoveOnGrid(Vertex vertex, double d, double d2) {
        Point point = this.getPointOnGrid(d, d2);
        Coordinates coordinates = this.getCoordinates((ArchetypeVertex)vertex);
        if (coordinates.x == (float)point.x && coordinates.y == (float)point.y) {
            return false;
        }
        super.forceMove(vertex, (double)point.x, (double)point.y);
        return true;
    }

    public Point getPointOnGrid(double d, double d2) {
        int n = (int)d % this.gridDist;
        int n2 = (int)d2 % this.gridDist;
        d = n < this.gridDist / 2 ? d - (double)n : d - (double)n + (double)this.gridDist;
        d2 = n2 < this.gridDist / 2 ? d2 - (double)n2 : d2 - (double)n2 + (double)this.gridDist;
        return new Point((int)d, (int)d2);
    }

    public Rectangle getLayoutSize() {
        Set set = this.getGraph().getVertices();
        if (set.size() > 0) {
            Rectangle rectangle = this.getVertexRect(set);
            return rectangle;
        }
        return new Rectangle();
    }

    public Rectangle getVertexRect(Iterable<FlowNode> iterable) {
        if (!iterable.iterator().hasNext()) {
            return new Rectangle();
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        double d4 = 0.0;
        for (FlowNode flowNode : iterable) {
            Point2D point2D = this.getLocation((ArchetypeVertex)flowNode);
            if (point2D == null) continue;
            if (point2D.getX() < d) {
                d = point2D.getX();
            }
            if (point2D.getY() < d2) {
                d2 = point2D.getY();
            }
            if (point2D.getX() > d3) {
                d3 = point2D.getX();
            }
            if (!(point2D.getY() > d4)) continue;
            d4 = point2D.getY();
        }
        return new Rectangle((int)d, (int)d2, (int)d3 - (int)d, (int)d4 - (int)d2);
    }

    public int getGridDistance() {
        return this.gridDist;
    }

    public void setGridDistance(int n) {
        this.gridDist = n;
    }

    public void beginNodesMove() {
        this.movingNodes = true;
    }

    public void endNodesMove() {
        this.movingNodes = false;
        this.fireStateChanged();
    }

    public void fireStateChanged() {
        if (this.movingNodes) {
            return;
        }
        super.fireStateChanged();
    }

    public Comparator<FlowNode> getLayoutNodeComparator() {
        if (this.layoutNodeComparator == null) {
            this.layoutNodeComparator = new LayoutNodeComparator();
        }
        return this.layoutNodeComparator;
    }

    private class LayoutNodeComparator
    implements Comparator<FlowNode> {
        private LayoutNodeComparator() {
        }

        @Override
        public int compare(FlowNode flowNode, FlowNode flowNode2) {
            Point2D point2D = FlowLayout.this.getLocation((ArchetypeVertex)flowNode);
            Point2D point2D2 = FlowLayout.this.getLocation((ArchetypeVertex)flowNode2);
            if (point2D2 == null) {
                if (point2D == null) {
                    return 0;
                }
                return -1;
            }
            if (point2D == null) {
                return 1;
            }
            if (point2D.getX() < point2D2.getX()) {
                return -1;
            }
            if (point2D.getX() > point2D2.getX()) {
                return 1;
            }
            if (point2D.getY() < point2D2.getY()) {
                return -1;
            }
            if (point2D.getY() > point2D2.getY()) {
                return 1;
            }
            return 0;
        }
    }
}

