/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditBackups;
import com.ef_prime.rflow.core.base.FileEditSupplier;
import com.ef_prime.rflow.core.base.FileEditSupport;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.SampleEntry;
import com.ef_prime.rflow.core.flow.ElementReader;
import com.ef_prime.rflow.core.flow.ElementWriter;
import com.ef_prime.rflow.core.flow.FlowDataReader;
import com.ef_prime.rflow.core.flow.FlowDataWriter;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowProperties;
import com.ef_prime.rflow.core.flow.FlowSettings;
import com.ef_prime.rflow.core.flow.FlowState;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.core.flow.GraphReader;
import com.ef_prime.rflow.core.flow.GraphWriter;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.core.flow.task.NodeTask;
import com.ef_prime.rflow.core.flow.task.NodeTaskGroup;
import com.ef_prime.rflow.core.util.ReadException;
import com.ef_prime.rflow.core.util.XMLException;
import com.ef_prime.rflow.node.NodeBreakpointChangeListener;
import com.ef_prime.rflow.node.NodeComment;
import com.ef_prime.rflow.node.NodeCommentListener;
import com.ef_prime.rflow.node.NodeModelChangeListener;
import com.ef_prime.rflow.node.NodePropertyChangeListener;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.LockFile;
import com.ef_prime.rflow.ui.common.component.OptionPaneChoiceHandler;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.flow.CacheEvent;
import com.ef_prime.rflow.ui.flow.CacheHandler;
import com.ef_prime.rflow.ui.flow.FlowExecutor;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.event.GraphEvent;
import edu.uci.ics.jung.graph.event.GraphEventListener;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class FlowModel
implements FileEdit,
NodeModelChangeListener,
NodePropertyChangeListener,
NodeCommentListener,
NodeBreakpointChangeListener,
ChangeEventHandler,
GraphEventListener {
    private static final Logger LOGGER = Logger.getLogger(FlowModel.class.getName());
    public static final String RFLOW_EXT = "rflow";
    public static final String DIR_RAF = ".raf";
    private static final String DIR_TMP = "tmp";
    private static final String DIR_NEWFLOW = "new_flow";
    private static final String EXT_BACKUP = ".bak";
    private static final String FILE_NEW_BACKUP = "new.bak";
    private static final String FILE_STATE_SAVE = ".rflow";
    private static final String EXT_SAVE_TEMP = ".savetemp";
    private static final String NAME_FILE_PREFIX = "FILE_";
    private static final Comparator<File> FILE_LAST_MODIFIED_SORTER = new Comparator<File>(){

        @Override
        public int compare(File file, File file2) {
            if (file.lastModified() < file2.lastModified()) {
                return -1;
            }
            return 1;
        }
    };
    private File workingFile;
    private FlowSettings flowSettings;
    private ViewLayout layout;
    private FlowState state;
    private NodeTask rootTask;
    private SampleEntry sample;
    private FlowNode rootNode;
    private CacheHandler cacheHandler;
    private FlowExecutor executor;
    private LockFile newFlowDirLock;
    private FlowProperties flowProperties;
    private File originalFile;
    private boolean isDirtyAfterRestore;
    private FileEditSupport resourceSupport = new FileEditSupport(this);
    private Object primaryView;
    private boolean clearOnUnloadLock;

    public static boolean isRflow(String string) {
        return FilenameUtils.isExtension((String)string, (String)RFLOW_EXT);
    }

    public static FlowModel createEmptyFlowModel() {
        return new FlowModel(null, null, null, null, null, null, null, null);
    }

    public static FlowModel readFlowModel(Object object, File file, SampleEntry sampleEntry) throws ReadException, IOException {
        FlowDataReader flowDataReader = new FlowDataReader();
        GraphReader graphReader = new GraphReader(new OptionPaneChoiceHandler(Rflow.getInstance().getMainFrame()), Rflow.mainView().getDefaultFlowPane().getSize());
        File file2 = null;
        if (object instanceof File) {
            file2 = (File)object;
            flowDataReader.read(file2, new ElementReader[]{graphReader});
        } else {
            flowDataReader.read((Reader)object, new ElementReader[]{graphReader});
        }
        return new FlowModel(file, graphReader.getFlowSettings(), graphReader.getFlowProperties(), graphReader.getViewLayout(), graphReader.getFlowState(), graphReader.getRootTask(), sampleEntry, file2);
    }

    private FlowModel(File file, FlowSettings flowSettings, FlowProperties flowProperties, ViewLayout viewLayout, FlowState flowState, NodeTask nodeTask, SampleEntry sampleEntry, File file2) {
        String string;
        if (flowSettings == null) {
            flowSettings = FlowSettings.createDefaultSettings();
        }
        if (flowProperties == null) {
            flowProperties = new FlowProperties();
        }
        if (viewLayout == null) {
            viewLayout = new ViewLayout();
        }
        if (flowState == null) {
            flowState = new FlowState();
        }
        if (nodeTask == null) {
            nodeTask = new NodeTaskGroup();
        }
        nodeTask.getProperty().setTitle(Messages.getString("Explorer.task.root"));
        this.workingFile = file;
        this.flowSettings = flowSettings;
        this.flowProperties = flowProperties;
        this.layout = viewLayout;
        this.state = flowState;
        this.rootTask = nodeTask;
        this.sample = sampleEntry;
        this.originalFile = file2;
        this.rootNode = FlowNode.createRootNode(this, new SubflowNodeModel(viewLayout));
        FlowGraph flowGraph = new FlowGraph();
        flowGraph.setFlowModel(this);
        flowGraph.addVertex((Vertex)this.rootNode);
        this.cacheHandler = new CacheHandler(this);
        if (!this.isNewFlow()) {
            this.cacheHandler.init();
        }
        this.executor = new FlowExecutor(this);
        viewLayout.getGraph().setFlowModel(this);
        flowState.setFlowModel(this);
        flowProperties.setFlowModel(this);
        if (!this.isNewFlow() && (string = flowSettings.getValue(FlowSettings.FOLDER)).equals(FlowSettings.FOLDER.getDefaultValue())) {
            File file3 = FlowModel.getNewFlowDataFolder(file, false);
            this.setFlowDataFolder(file, file3);
            this.getCacheHandler().init();
        }
        flowProperties.addChangeEventHandler(this);
    }

    public String getTitle() {
        if (this.isSample()) {
            return this.getSample().getName();
        }
        return this.isNewFlow() ? Messages.getString("Flow.new_flow") : this.getWorkingFileName();
    }

    private String getWorkingFileName() {
        return this.workingFile == null ? "" : FilenameUtils.removeExtension((String)this.workingFile.getName());
    }

    public File getWorkingFile() {
        return this.workingFile;
    }

    public File getOriginalFile() {
        return this.originalFile;
    }

    @Override
    public File getFile() {
        return this.getWorkingFile();
    }

    public FlowSettings getFlowSetting() {
        return this.flowSettings;
    }

    public ViewLayout getLayout() {
        return this.layout;
    }

    public FlowState getState() {
        return this.state;
    }

    public NodeTask getRootTask() {
        return this.rootTask;
    }

    public SampleEntry getSample() {
        return this.sample;
    }

    public FlowNode getRootNode() {
        return this.rootNode;
    }

    public CacheHandler getCacheHandler() {
        return this.cacheHandler;
    }

    public FlowExecutor getExecutor() {
        return this.executor;
    }

    public FlowProperties getFlowProperties() {
        return this.flowProperties;
    }

    public List<RPackage> getRPackages() {
        List<RPackage> list = this.flowProperties.getRPackages();
        return list;
    }

    public RPackage[] getRequiredRPackages() {
        List<RPackage> list = this.flowProperties.getRPackages();
        Iterator<RPackage> iterator = list.iterator();
        while (iterator.hasNext()) {
            RPackage rPackage = iterator.next();
            if (rPackage.isRequired()) continue;
            iterator.remove();
        }
        return list.toArray(new RPackage[list.size()]);
    }

    public List<RPackage> getAttachPackages() {
        List<RPackage> list = this.flowProperties.getRPackages();
        Iterator<RPackage> iterator = list.iterator();
        while (iterator.hasNext()) {
            RPackage rPackage = iterator.next();
            if (rPackage.isAttach()) continue;
            iterator.remove();
        }
        return list;
    }

    public void refreshRPackageStates() {
        Deque<Vertex> deque = this.getLayout().getGraph().getVertexList();
        for (Vertex vertex : deque) {
            FlowNode flowNode = (FlowNode)vertex;
            this.getState().checkRPackage(flowNode);
            if (!flowNode.getModel().isSubflow()) continue;
            Set<FlowNode> set = FlowUtil.getAllDescendants((SubflowNodeModel)flowNode.getModel());
            for (FlowNode flowNode2 : set) {
                this.getState().checkRPackage(flowNode2);
            }
        }
    }

    public Optional<FlowNode> getFlowNode(String string) {
        Set<FlowNode> set = FlowUtil.getAllDescendants((SubflowNodeModel)this.rootNode.getModel());
        for (FlowNode flowNode : set) {
            if (!flowNode.getUid().equals(string)) continue;
            return Optional.of(flowNode);
        }
        return Optional.empty();
    }

    public boolean contains(FlowNode flowNode) {
        if (flowNode == null) {
            return false;
        }
        return this == flowNode.getFlowModel().orElse(null);
    }

    public boolean isNewFlow() {
        return this.workingFile == null;
    }

    public boolean isSample() {
        return this.sample != null;
    }

    public Object getPrimaryView() {
        return this.primaryView;
    }

    public void setPrimaryView(Object object) {
        this.primaryView = object;
    }

    public void setClearOnUnloadLock(boolean bl) {
        this.clearOnUnloadLock = bl;
    }

    public boolean isClearOnUnloadLock() {
        return this.clearOnUnloadLock;
    }

    @Override
    public String getFileEditName() {
        return this.getTitle();
    }

    @Override
    public void setDirty(boolean bl) {
        this.resourceSupport.setDirty(bl);
        this.setDirtyAfterRestore(bl);
    }

    @Override
    public boolean isDirty() {
        return this.resourceSupport.isDirty() && !this.isSample();
    }

    public void setDirtyAfterRestore(boolean bl) {
        this.isDirtyAfterRestore = bl;
    }

    public boolean isDirtyAfterRestore() {
        return this.isDirtyAfterRestore;
    }

    @Override
    public FileEditSupport getFileEditSupport() {
        return this.resourceSupport;
    }

    @Override
    public void loadFileEdit() {
        this.resourceSupport.loadFileEdit();
        if (this.isNewFlow()) {
            this.tryOriginalFlowDataDirLock();
            if (this.newFlowDirLock == null) {
                this.newFlowDirLock = LockFile.getDirWithLock(Rflow.project().getTempDir(), DIR_NEWFLOW);
            }
            this.cacheHandler.init();
        }
        EventManager.getInstance().registerEventHandler(CacheEvent.class, this.state);
        FlowNode.addNodeModelChangeListener(this);
        FlowNode.addNodePropertyChangeListener(this);
        FlowNode.addNodeCommentListener(this);
        FlowNode.addNodeModelChangeListener(this.state);
        FlowNode.addNodeModelChangeListener(this.cacheHandler);
        FlowNode.addNodeBreakpointChangeListener(this);
        FlowNode.addNodeBreakpointChangeListener(this.cacheHandler);
        FlowViewer.addGraphEventListener(this);
        FlowViewer.addGraphEventListener(this.state);
        FlowViewer.addGraphEventListener(this.cacheHandler);
        Rflow.mainView().addActiveViewerListener(this.state);
        this.protectFileEdits(true);
        this.updateLastModified();
    }

    private void tryOriginalFlowDataDirLock() {
        if (this.originalFile == null) {
            return;
        }
        File file = this.originalFile.getParentFile();
        if (file == null) {
            return;
        }
        File file2 = file.getParentFile();
        if (file2 == null || !file2.getName().startsWith(DIR_NEWFLOW)) {
            return;
        }
        File file3 = new File(file2, ".lock");
        LockFile lockFile = new LockFile(file3);
        FileLock fileLock = lockFile.tryLock();
        if (fileLock != null) {
            this.newFlowDirLock = lockFile;
        }
    }

    private void protectFileEdits(boolean bl) {
        Set<FlowNode> set = FlowUtil.getAllDescendants(this.layout.getGraph().getParentNode());
        for (FlowNode flowNode : set) {
            this.protectFileEdit(flowNode, bl);
        }
    }

    private void protectFileEdit(FlowNode flowNode, boolean bl) {
        FileEditSupplier fileEditSupplier = flowNode.getFileEditSupplier();
        if (fileEditSupplier != null) {
            if (bl) {
                fileEditSupplier.load(flowNode);
            } else {
                fileEditSupplier.unload(flowNode);
            }
        }
    }

    @Override
    public void unloadFileEdit(boolean bl) {
        this.resourceSupport.unloadFileEdit(bl);
        EventManager.getInstance().removeEventHandler(CacheEvent.class, this.state);
        FlowNode.removeNodeModelChangeListener(this);
        FlowNode.removeNodePropertyChangeListener(this);
        FlowNode.removeNodeCommentListener(this);
        FlowNode.removeNodeModelChangeListener(this.state);
        FlowNode.removeNodeModelChangeListener(this.cacheHandler);
        FlowNode.removeNodeBreakpointChangeListener(this);
        FlowNode.removeNodeBreakpointChangeListener(this.cacheHandler);
        FlowViewer.removeGraphEventListener(this);
        FlowViewer.removeGraphEventListener(this.state);
        FlowViewer.removeGraphEventListener(this.cacheHandler);
        Rflow.mainView().removeActiveViewerListener(this.state);
        this.protectFileEdits(false);
        if (this.isNewFlow() && bl) {
            try {
                File file = this.getStateSaveFile();
                ElementWriter[] elementWriterArray = new ElementWriter[]{new GraphWriter(this.layout, this.flowSettings, this.rootTask, this.flowProperties)};
                if (file.exists()) {
                    FileUtils.forceDelete((File)file);
                }
                FileUtils.forceMkdir((File)file.getParentFile());
                new FlowDataWriter().write(file, elementWriterArray);
            }
            catch (XMLException | IOException exception) {
                LOGGER.log(Level.SEVERE, "Failed to save flow's state.", exception);
            }
        }
        this.releaseNewDirLock(bl);
        if (!bl && !this.clearOnUnloadLock) {
            this.removeTempDirs();
        }
        if (!this.isNewFlow()) {
            this.cleanFlowDir();
        }
    }

    private void releaseNewDirLock(boolean bl) {
        if (this.newFlowDirLock != null) {
            this.newFlowDirLock.release();
            if (!bl && !this.clearOnUnloadLock) {
                FileUtils.deleteQuietly((File)this.newFlowDirLock.getFile().getParentFile());
            }
        }
    }

    private void cleanFlowDir() {
        File file = this.getFlowDataDir();
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        boolean bl = true;
        for (File file2 : fileArray) {
            boolean bl2;
            if (!file2.isDirectory()) continue;
            File[] fileArray2 = file2.listFiles();
            if (fileArray2 == null) {
                bl = false;
                continue;
            }
            boolean bl3 = bl2 = fileArray2.length == 0;
            if (bl2) {
                FileUtils.deleteQuietly((File)file2);
                continue;
            }
            bl = false;
        }
        if (bl) {
            FileUtils.deleteQuietly((File)file);
        }
    }

    public File getFlowDataDir() {
        if (!this.isNewFlow()) {
            String string = DIR_RAF + File.separatorChar + this.flowSettings.getValue(FlowSettings.FOLDER);
            return new File(this.workingFile.getParent(), string);
        }
        return this.newFlowDirLock.getFile().getParentFile();
    }

    public File getFlowDataTempDir() {
        return new File(this.getFlowDataDir(), DIR_TMP);
    }

    public File getUserFlowTempDir() throws IOException {
        if (this.isNewFlow()) {
            return this.getFlowDataTempDir();
        }
        return FileEditBackups.getInstance().createTempDirectory(this).toFile();
    }

    private void removeTempDirs() {
        FileUtils.deleteQuietly((File)this.getFlowDataTempDir());
        FileEditBackups.getInstance().removeTempDirectory(this);
    }

    public File getStateSaveFile() throws IOException {
        return new File(this.getUserFlowTempDir(), FILE_STATE_SAVE);
    }

    public File getBackupFile() throws IOException {
        String string = this.isNewFlow() ? FILE_NEW_BACKUP : this.getWorkingFile().getName() + EXT_BACKUP;
        return new File(this.getUserFlowTempDir(), string);
    }

    public File getSaveTempFile() throws IOException {
        Object object = this.isNewFlow() ? "new" : this.getWorkingFile().getName();
        object = (String)object + EXT_SAVE_TEMP;
        return new File(this.getUserFlowTempDir(), (String)object);
    }

    public boolean isFlowData() {
        File[] fileArray = this.getFlowDataDir().listFiles();
        if (fileArray == null) {
            return false;
        }
        for (File file : fileArray) {
            File[] fileArray2;
            if (file.isFile()) {
                return true;
            }
            if (!file.isDirectory() || (fileArray2 = file.listFiles()) == null || fileArray2.length <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void save(Path path) throws IOException {
        try {
            this.save(path.toFile(), false);
        }
        catch (XMLException xMLException) {
            throw new IOException(xMLException);
        }
    }

    @Override
    public void saveBackup(Path path) throws IOException {
        this.save(path);
    }

    public void save(File file, boolean bl) throws IOException, XMLException {
        boolean bl2;
        Object object;
        File file2;
        boolean bl3 = this.isNewFlow();
        boolean bl4 = file.exists();
        boolean bl5 = bl3 || !file.equals(this.getWorkingFile());
        File file3 = this.getFlowDataDir();
        if (bl5) {
            file2 = FlowModel.getNewFlowDataFolder(file, bl5 && bl4);
            this.setFlowDataFolder(file, file2);
        }
        file2 = file;
        if (bl4) {
            file2 = this.getSaveTempFile();
            FileUtils.forceMkdir((File)file2.getParentFile());
        }
        ElementWriter[] elementWriterArray = new ElementWriter[]{new GraphWriter(this.getLayout(), this.getFlowSetting(), this.getRootTask(), this.getFlowProperties())};
        new FlowDataWriter().write(file2, elementWriterArray);
        if (!file2.equals(file)) {
            object = FileUtility.getUniqueNumberFile(file.getParentFile(), file.getName(), "-", EXT_BACKUP, 3, true);
            FileUtils.moveFile((File)file, (File)object);
            FileUtils.moveFile((File)file2, (File)file);
            FileUtils.deleteQuietly((File)object);
        }
        this.workingFile = file;
        this.updateLastModified();
        this.sample = null;
        this.getRootNode().getProperty().setTitle(this.getTitle());
        if (bl5 && bl) {
            FileUtils.copyDirectory((File)file3, (File)this.getFlowDataDir());
            object = FlowModel.searchForName(file3);
            File file4 = new File(this.getFlowDataDir(), NAME_FILE_PREFIX + (String)object);
            if (file4.exists()) {
                FileUtils.forceDelete((File)file4);
            }
            if (bl3) {
                this.releaseNewDirLock(false);
            }
        }
        if (this.getFlowDataDir().exists() && !((File)(object = new File(this.getFlowDataDir(), NAME_FILE_PREFIX + FilenameUtils.removeExtension((String)file.getName())))).exists()) {
            ((File)object).createNewFile();
        }
        boolean bl6 = bl2 = bl5 && !bl;
        if (!bl2) {
            if (bl5) {
                this.getCacheHandler().init();
            }
            this.getCacheHandler().saveCaches();
        } else {
            this.getCacheHandler().clearAllCache();
        }
        this.getCacheHandler().cleanCaches();
        this.removeTempDirs();
        this.setDirty(false);
        this.dispatchFileEditEvent(3);
    }

    @Override
    public void clearEdit() {
    }

    public static File getRecoveryFile(File file) {
        File file2 = new File(file, DIR_TMP + File.separatorChar + FILE_STATE_SAVE);
        if (file2.exists()) {
            return file2;
        }
        return new File(file, DIR_TMP + File.separatorChar + FILE_NEW_BACKUP);
    }

    public static boolean isRecoveryFile(Path path2) throws IOException {
        return Files.list(path2).filter(path -> FilenameUtils.isExtension((String)path.getFileName().toString(), (String)"bak")).count() > 0L;
    }

    public static boolean isStateSaveFile(File file) {
        return file.getName().equals(FILE_STATE_SAVE);
    }

    public static File[] searchAndCleanUpNewFlowBackupFiles(Project project) {
        File file = project.getTempDir();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return new File[0];
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : fileArray) {
            if (!file2.isDirectory() || !file2.getName().startsWith(DIR_NEWFLOW)) continue;
            LockFile lockFile = LockFile.createLockFile(file2);
            File file3 = FlowModel.getRecoveryFile(file2);
            if (!file3.exists()) {
                FileUtils.deleteQuietly((File)file2);
                continue;
            }
            if (!lockFile.canObtainLock()) continue;
            arrayList.add(file3);
        }
        Collections.sort(arrayList, FILE_LAST_MODIFIED_SORTER);
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private void setFlowDataFolder(File file, File file2) {
        this.flowSettings.putValue(FlowSettings.FOLDER, file2.getName());
    }

    private static File getNewFlowDataFolder(File file, boolean bl) {
        Object object;
        String string = FilenameUtils.removeExtension((String)file.getName());
        File file2 = new File(file.getParentFile(), DIR_RAF);
        File file3 = new File(file2, string);
        int n = 1;
        while (!(!file3.exists() || bl && (object = FlowModel.searchForName(file3)) != null && ((String)object).equals(string))) {
            object = string + "_" + n;
            file3 = new File(file2, (String)object);
            ++n;
        }
        return file3;
    }

    public boolean checkDataConnection() {
        if (this.isNewFlow()) {
            return true;
        }
        File file = this.getFlowDataDir();
        File file2 = FlowModel.searchForNameFile(file);
        if (file2 == null) {
            return true;
        }
        String string = this.getWorkingFileName();
        String string2 = file2.getName().substring(NAME_FILE_PREFIX.length());
        return string2.equals(string);
    }

    public void rename(String string) throws IOException {
        File file = new File(this.getWorkingFile().getParentFile(), string + FILE_STATE_SAVE);
        this.move(file);
    }

    public void move(File file) throws IOException {
        Object object;
        if (this.isNewFlow() || this.getWorkingFile().equals(file)) {
            return;
        }
        File file2 = this.getWorkingFile();
        File file3 = this.getFlowDataDir();
        if (file.exists()) {
            try {
                object = FlowModel.readFlowModel(file, file, null);
                ((FlowModel)object).remove();
            }
            catch (ReadException readException) {
                throw new IOException(readException);
            }
        }
        FileUtils.moveFile((File)this.getWorkingFile(), (File)file);
        this.workingFile = file;
        object = new File(file3, NAME_FILE_PREFIX + FlowModel.searchForName(file3));
        File file4 = new File(file3, NAME_FILE_PREFIX + FilenameUtils.removeExtension((String)file.getName()));
        if (!((File)object).equals(file4) && ((File)object).exists()) {
            FileUtils.moveFile((File)object, (File)file4);
        }
        File file5 = FlowModel.getNewFlowDataFolder(this.workingFile, false);
        if (file3.isDirectory()) {
            FileUtils.moveDirectory((File)file3, (File)file5);
        }
        this.setFlowDataFolder(this.workingFile, file5);
        this.save();
        this.getCacheHandler().init();
        FileUtility.removeDirectoryIfEmpty(new File(file2.getParentFile(), DIR_RAF));
        this.dispatchFileEditEvent(3);
    }

    public void remove() throws IOException {
        if (this.checkDataConnection() && this.getFlowDataDir().exists()) {
            FileUtility.removeFile(this.getFlowDataDir());
        }
        if (this.getWorkingFile().exists()) {
            FileUtility.removeFile(this.getWorkingFile());
        }
        FileUtility.removeDirectoryIfEmpty(new File(this.getWorkingFile().getParentFile(), DIR_RAF));
    }

    public FlowModel copyToDir(File file) throws IOException {
        File file2 = this.getFlowDataDir();
        String string = FlowModel.searchForName(file2);
        File file3 = FileUtility.getUniqueNumberFile(file, this.getWorkingFileName(), "_", FILE_STATE_SAVE, 1, true);
        FlowModel flowModel = new FlowModel(file3, this.flowSettings, this.flowProperties, this.layout, this.state, this.rootTask, this.sample, file3);
        String string2 = flowModel.getWorkingFileName();
        File file4 = FlowModel.getNewFlowDataFolder(file3, false);
        flowModel.setFlowDataFolder(file3, file4);
        File file5 = flowModel.getFlowDataDir();
        if (file2.exists()) {
            FileUtils.copyDirectory((File)file2, (File)file5);
            if (!string2.equals(string)) {
                File file6 = new File(file5, NAME_FILE_PREFIX + string);
                File file7 = new File(file5, NAME_FILE_PREFIX + string2);
                if (file6.exists()) {
                    FileUtils.moveFile((File)file6, (File)file7);
                } else {
                    FileUtils.touch((File)file7);
                }
            }
        }
        flowModel.save();
        this.getCacheHandler().init();
        return flowModel;
    }

    public void copyDataToNewDataDir() throws IOException {
        File file = this.getFlowDataDir();
        String string = FlowModel.searchForName(file);
        String string2 = this.getWorkingFileName();
        File file2 = FlowModel.getNewFlowDataFolder(this.getWorkingFile(), false);
        this.setFlowDataFolder(this.getWorkingFile(), file2);
        File file3 = this.getFlowDataDir();
        FileUtils.copyDirectory((File)file, (File)file3);
        File file4 = new File(file3, NAME_FILE_PREFIX + string);
        File file5 = new File(file3, NAME_FILE_PREFIX + string2);
        FileUtils.moveFile((File)file4, (File)file5);
        this.save();
        this.getCacheHandler().init();
    }

    public void moveDataToNewDataDir() throws IOException {
        File file = this.getFlowDataDir();
        String string = FlowModel.searchForName(file);
        String string2 = this.getWorkingFileName();
        File file2 = new File(file, NAME_FILE_PREFIX + string);
        File file3 = new File(file, NAME_FILE_PREFIX + string2);
        FileUtils.moveFile((File)file2, (File)file3);
        File file4 = FlowModel.getNewFlowDataFolder(this.workingFile, false);
        FileUtils.moveDirectory((File)file, (File)file4);
        this.setFlowDataFolder(this.workingFile, file4);
        this.save();
        this.getCacheHandler().init();
    }

    public void createNewDataDir() throws IOException {
        for (FlowNode flowNode : this.getState().getCacheNodes()) {
            flowNode.getCacheData().setValid(false);
        }
        File file = FlowModel.getNewFlowDataFolder(this.workingFile, false);
        this.setFlowDataFolder(this.workingFile, file);
        this.save();
        this.getCacheHandler().init();
    }

    private void save() throws IOException {
        ElementWriter[] elementWriterArray = new ElementWriter[]{new GraphWriter(this.layout, this.flowSettings, this.rootTask, this.flowProperties)};
        try {
            new FlowDataWriter().write(this.workingFile, elementWriterArray);
            this.updateLastModified();
        }
        catch (XMLException xMLException) {
            throw new IOException(xMLException);
        }
    }

    private static String searchForName(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        for (File file2 : file.listFiles()) {
            if (!file2.getName().startsWith(NAME_FILE_PREFIX)) continue;
            return file2.getName().substring(NAME_FILE_PREFIX.length());
        }
        return null;
    }

    private static File searchForNameFile(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        for (File file2 : file.listFiles()) {
            if (!file2.getName().startsWith(NAME_FILE_PREFIX)) continue;
            return file2;
        }
        return null;
    }

    @Override
    public void nodePropertyChanged(FlowNode flowNode) {
        if (this.contains(flowNode)) {
            this.setDirty(true);
        }
    }

    @Override
    public void nodeCommentChanged(FlowNode flowNode, NodeComment nodeComment, NodeComment nodeComment2) {
        if (this.contains(flowNode)) {
            this.setDirty(true);
        }
    }

    @Override
    public void nodeModelChanged(FlowNode flowNode) {
        if (this.contains(flowNode)) {
            this.setDirty(true);
        }
    }

    @Override
    public void subflowNodeModelChanged(FlowNode flowNode) {
        if (this.contains(flowNode)) {
            this.setDirty(true);
        }
    }

    @Override
    public void handleChanged(ChangeEvent changeEvent) {
        this.setDirty(true);
    }

    public void vertexAdded(GraphEvent graphEvent) {
        FlowGraph flowGraph = (FlowGraph)graphEvent.getGraph();
        if (!flowGraph.isAdjusting()) {
            FlowNode flowNode = (FlowNode)graphEvent.getGraphElement();
            this.protectFileEdit(flowNode, true);
        }
    }

    public void vertexRemoved(GraphEvent graphEvent) {
        FlowGraph flowGraph = (FlowGraph)graphEvent.getGraph();
        if (!flowGraph.isAdjusting()) {
            FlowNode flowNode = (FlowNode)graphEvent.getGraphElement();
            this.protectFileEdit(flowNode, false);
        }
    }

    public void edgeAdded(GraphEvent graphEvent) {
    }

    public void edgeRemoved(GraphEvent graphEvent) {
    }

    @Override
    public void nodeBreakpointChanged(FlowNode flowNode, int n, int n2) {
        if (this.contains(flowNode)) {
            this.setDirty(true);
        }
    }
}

