/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.core.base.FileEditSupplier;
import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueError;
import com.ef_prime.rflow.core.flow.CacheData;
import com.ef_prime.rflow.core.flow.FlowEdge;
import com.ef_prime.rflow.core.flow.FlowError;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNodeUIDManager;
import com.ef_prime.rflow.core.flow.FlowState;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.node.NodeBreakpointChangeListener;
import com.ef_prime.rflow.node.NodeComment;
import com.ef_prime.rflow.node.NodeCommentListener;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.NodeModelChangeListener;
import com.ef_prime.rflow.node.NodeProperty;
import com.ef_prime.rflow.node.NodePropertyChangeListener;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import com.ef_prime.rflow.node.base.TunnelNodeModel;
import com.ef_prime.rflow.node.group.AppearanceGroup;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.flow.DefaultUndoableEdits;
import edu.uci.ics.jung.graph.impl.DirectedSparseVertex;
import java.awt.event.ActionEvent;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;

public class FlowNode
extends DirectedSparseVertex
implements ValueChangeEventHandler {
    public static final int BREAKPOINT_NONE = 0;
    public static final int BREAKPOINT_DISABLED = 1;
    public static final int BREAKPOINT_ENABLED = 2;
    public static final int BREAKPOINT_DOCUMENT_CHANGED = 3;
    private static final BreakpointChanged BREAKPOINT_CHANGED = new BreakpointChanged();
    private NodeModel model;
    private NodeProperty property;
    private NodeComment comment;
    private boolean isRoot;
    private String uid;
    private String date;
    private FlowModel parentModel;
    private CacheData cacheData = null;
    private DefaultUndoableEdits.ClearCacheEdit clearCacheEdit;
    private static Queue<NodeModelChangeListener> listeners = new ConcurrentLinkedQueue<NodeModelChangeListener>();
    private static Queue<NodeBreakpointChangeListener> breakpointListeners = new ConcurrentLinkedQueue<NodeBreakpointChangeListener>();
    private static Queue<NodePropertyChangeListener> propertyListeners = new ConcurrentLinkedQueue<NodePropertyChangeListener>();
    private static Queue<NodeCommentListener> commentListeners = new ConcurrentLinkedQueue<NodeCommentListener>();

    public static FlowNode createRootNode(FlowModel flowModel, NodeModel nodeModel) {
        FlowNode flowNode = new FlowNode(nodeModel);
        flowNode.isRoot = true;
        flowNode.parentModel = flowModel;
        return flowNode;
    }

    public FlowNode(NodeModel nodeModel) {
        this(nodeModel, NodeProperty.createDefaultProperty(), NodeComment.create(), "", "");
    }

    public FlowNode(NodeModel nodeModel, NodeProperty nodeProperty, NodeComment nodeComment, String string, String string2) {
        this.model = nodeModel;
        this.setProperty(nodeProperty);
        this.comment = nodeComment;
        if (this.comment == null) {
            this.comment = NodeComment.create();
        }
        if (string == null || string.isEmpty()) {
            string = Long.toString(System.currentTimeMillis());
        }
        this.date = string;
        if (StringUtils.isEmpty((CharSequence)string2)) {
            string2 = FlowNodeUIDManager.getInstance().getUID(this);
        }
        this.uid = string2;
        if (nodeModel.isSubflow()) {
            ((SubflowNodeModel)nodeModel).setParentNode(this);
        }
    }

    private FlowNode(NodeModel nodeModel, NodeProperty nodeProperty, NodeComment nodeComment, CacheData cacheData) {
        this(nodeModel, nodeProperty, nodeComment, "", "");
        this.cacheData = cacheData;
    }

    public NodeModel getModel() {
        return this.model;
    }

    public boolean isRootNode() {
        return this.isRoot;
    }

    public String getDate() {
        return this.date;
    }

    public String getUid() {
        return this.uid;
    }

    public NodeProperty getProperty() {
        return this.property;
    }

    public void setProperty(NodeProperty nodeProperty) {
        if (this.property != null && this.getProperty().equals(nodeProperty)) {
            return;
        }
        if (this.property != null) {
            this.property.removeEventHandler(this);
        }
        this.property = nodeProperty;
        nodeProperty.addEventHandler(this);
        FlowNode.fireNodePropertyChanged(this);
    }

    public NodeComment getComment() {
        return this.comment;
    }

    public void setComment(NodeComment nodeComment) {
        if (this.comment.equals(nodeComment)) {
            return;
        }
        NodeComment nodeComment2 = this.comment;
        this.comment = nodeComment;
        FlowNode.fireNodeCommentChanged(this, nodeComment2, nodeComment);
    }

    private int getBreakpointState() {
        if (this.model.getBreakpoints().isEmpty()) {
            return 0;
        }
        Integer n = this.model.getBreakpoints().get(0);
        if (Math.abs(n) != 1) {
            return 0;
        }
        if (n > 0) {
            return 2;
        }
        return 1;
    }

    public void setBreakpointState(int n) {
        if (this.getBreakpointState() != n) {
            int n2 = this.getBreakpointState();
            if (n2 != 0) {
                this.model.getBreakpoints().remove(0);
            }
            switch (n) {
                case 0: {
                    break;
                }
                case 2: {
                    this.model.getBreakpoints().add(0, 1);
                    break;
                }
                case 1: {
                    this.model.getBreakpoints().add(0, -1);
                }
            }
            FlowNode.fireNodeBreakpointChanged(this, n2, n, true);
        }
    }

    public boolean isFirstBreakpoint() {
        return this.getBreakpointState() != 0;
    }

    public boolean isFirstBreakpointEnabled() {
        return this.getBreakpointState() == 2;
    }

    public String getTitle() {
        if (this.isRootNode()) {
            return this.parentModel.getTitle();
        }
        String string = this.property.getTitle();
        if (string != null) {
            return string;
        }
        return this.model.getDefaultTitle();
    }

    public CacheData getCacheData() {
        return this.cacheData;
    }

    public void setCacheData(CacheData cacheData) {
        this.cacheData = cacheData;
    }

    public boolean isCacheData() {
        return this.cacheData != null && this.cacheData.flagExists();
    }

    public DefaultUndoableEdits.ClearCacheEdit getClearCacheEdit() {
        return this.clearCacheEdit;
    }

    public void setClearCacheEdit(DefaultUndoableEdits.ClearCacheEdit clearCacheEdit) {
        if (this.clearCacheEdit != null) {
            this.clearCacheEdit.setInsignificant();
        }
        this.clearCacheEdit = clearCacheEdit;
    }

    public boolean isInClosedSubflow() {
        FlowGraph flowGraph = this.getGraph();
        boolean bl = false;
        while (flowGraph != null && !flowGraph.isRootGraph()) {
            boolean bl2 = bl = !flowGraph.getParentNode().getModel().isOpenSubflow();
            if (bl) break;
            flowGraph = flowGraph.getParentNode().getGraph();
        }
        return bl;
    }

    public FlowGraph getGraph() {
        return (FlowGraph)super.getGraph();
    }

    public FlowNode getParentNode() {
        return this.getGraph() == null ? null : this.getGraph().getParentNode();
    }

    public Optional<FlowModel> getFlowModel() {
        if (this.parentModel != null) {
            return Optional.of(this.parentModel);
        }
        return this.getGraph() == null ? Optional.empty() : Optional.ofNullable(this.getGraph().getFlowModel());
    }

    public FlowNode[] getPath(boolean bl) {
        FlowNode flowNode;
        ArrayDeque<FlowNode> arrayDeque = new ArrayDeque<FlowNode>();
        FlowNode flowNode2 = flowNode = bl ? this : this.getParentNode();
        while (flowNode != null) {
            arrayDeque.addFirst(flowNode);
            flowNode = flowNode.getParentNode();
        }
        return arrayDeque.toArray(new FlowNode[arrayDeque.size()]);
    }

    public boolean isExecutable() {
        Optional<FlowModel> optional;
        if (!this.getModel().isExecutable() || this.getGraph() == null) {
            return false;
        }
        boolean bl = true;
        if (this.getModel() != TunnelNodeModel.outModel && this.getGraph().getParentNode() != null && this.getGraph().getParentNode().getModel().isSubflow()) {
            boolean bl2 = bl = !this.isInClosedSubflow() || !FlowUtil.isHeadInNode(this);
        }
        if (bl && (optional = this.getFlowModel()).isPresent()) {
            FlowState flowState = optional.get().getState();
            List<FlowNode> list = FlowUtil.getStream(this, true, false, true);
            block0: for (FlowNode flowNode : list) {
                List<FlowError> list2 = flowState.getError(flowNode);
                if (list2 == null) continue;
                for (FlowError flowError : list2) {
                    if (flowError.isExecutable()) continue;
                    bl = false;
                    break block0;
                }
            }
        }
        return bl;
    }

    public Set<FlowNode> getNexts() {
        return new HashSet<FlowNode>(this.getSuccsToOutEdges().keySet());
    }

    public Icon getIcon() {
        AppearanceGroup appearanceGroup = this.getProperty().getAppearanceGroup();
        return appearanceGroup == null ? this.getModel().getIcon() : appearanceGroup.getIcon();
    }

    public Icon getSmallIcon() {
        if (this.isRootNode()) {
            return FileResource.getIcon("img/doc_16.png");
        }
        AppearanceGroup appearanceGroup = this.getProperty().getAppearanceGroup();
        return appearanceGroup == null ? this.getModel().getSmallIcon() : appearanceGroup.getSmallIcon();
    }

    public FlowNode copy() {
        FlowNode flowNode = new FlowNode(this.model.copy(), this.property.copy(), this.comment.copy(), "", "");
        flowNode.isRoot = this.isRoot;
        flowNode.parentModel = this.parentModel;
        return flowNode;
    }

    public FlowNode fullCopy() {
        FlowNode flowNode = this.cacheData != null ? new FlowNode(this.model.fullCopy(), this.property.copy(), this.comment.copy(), this.cacheData.copy()) : new FlowNode(this.model.fullCopy(), this.property.copy(), this.comment.copy(), "", "");
        flowNode.isRoot = this.isRoot;
        flowNode.parentModel = this.parentModel;
        return flowNode;
    }

    public FlowNode getNextNode() {
        Iterator iterator = this.getSuccsToOutEdges().keySet().iterator();
        if (iterator.hasNext()) {
            return (FlowNode)iterator.next();
        }
        return null;
    }

    public FlowNode getPreviousNode() {
        Iterator iterator = this.getPredsToInEdges().keySet().iterator();
        if (iterator.hasNext()) {
            return (FlowNode)iterator.next();
        }
        return null;
    }

    public FlowEdge getInEdge() {
        Iterator iterator;
        Iterator iterator2 = this.getPredsToInEdges().values().iterator();
        if (iterator2.hasNext() && (iterator = ((Set)iterator2.next()).iterator()).hasNext()) {
            return (FlowEdge)((Object)iterator.next());
        }
        return null;
    }

    public int inDegree() {
        return this.getPredsToInEdges().size();
    }

    public int outDegree() {
        return this.getSuccsToOutEdges().size();
    }

    public boolean isInGraph() {
        return this.getGraph() != null;
    }

    public ValueError getValueError() {
        return this.getModel().getValueError();
    }

    public FileEditSupplier getFileEditSupplier() {
        Operation operation;
        if (this.getModel() instanceof UINodeModel && (operation = ((UINodeModel)this.getModel()).getModel()) instanceof FileEditSupplier) {
            return (FileEditSupplier)((Object)operation);
        }
        return null;
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        FlowNode.fireNodePropertyChanged(this);
    }

    public static FlowNode getTopClosedSubflowNode(FlowEdge flowEdge) {
        return FlowNode.getTopClosedSubflowNode(flowEdge.getSource());
    }

    public static FlowNode getTopClosedSubflowNode(FlowNode flowNode) {
        FlowNode flowNode2 = flowNode;
        FlowNode flowNode3 = null;
        while (flowNode2.getGraph() != null && !flowNode2.getGraph().isRootGraph()) {
            if (!(flowNode2 = flowNode2.getParentNode()).getModel().isOpenSubflow()) {
                // empty if block
            }
            flowNode3 = flowNode2;
        }
        if (flowNode3 != null) {
            return flowNode3;
        }
        return null;
    }

    public static void addNodeModelChangeListener(NodeModelChangeListener nodeModelChangeListener) {
        listeners.add(nodeModelChangeListener);
    }

    public static void removeNodeModelChangeListener(NodeModelChangeListener nodeModelChangeListener) {
        listeners.remove(nodeModelChangeListener);
    }

    public static void fireNodeModelChanged(FlowNode flowNode) {
        if (!flowNode.getModel().isSubflow()) {
            for (NodeModelChangeListener nodeModelChangeListener : listeners) {
                nodeModelChangeListener.nodeModelChanged(flowNode);
            }
        } else {
            FlowNode.fireSubflowNodeModelChanged(flowNode);
        }
        if (flowNode.getGraph() != null && !flowNode.getGraph().isRootGraph()) {
            FlowNode.fireSubflowNodeModelChanged(flowNode.getParentNode());
        }
    }

    public static void fireSubflowNodeModelChanged(FlowNode flowNode) {
        for (NodeModelChangeListener nodeModelChangeListener : listeners) {
            nodeModelChangeListener.subflowNodeModelChanged(flowNode);
        }
        if (flowNode.getGraph() != null && !flowNode.getGraph().isRootGraph()) {
            FlowNode.fireSubflowNodeModelChanged(flowNode.getParentNode());
        }
    }

    public static void addNodePropertyChangeListener(NodePropertyChangeListener nodePropertyChangeListener) {
        propertyListeners.add(nodePropertyChangeListener);
    }

    public static void removeNodePropertyChangeListener(NodePropertyChangeListener nodePropertyChangeListener) {
        propertyListeners.remove(nodePropertyChangeListener);
    }

    public static void fireNodePropertyChanged(FlowNode flowNode) {
        for (NodePropertyChangeListener nodePropertyChangeListener : propertyListeners) {
            nodePropertyChangeListener.nodePropertyChanged(flowNode);
        }
    }

    public static void addNodeCommentListener(NodeCommentListener nodeCommentListener) {
        commentListeners.add(nodeCommentListener);
    }

    public static void removeNodeCommentListener(NodeCommentListener nodeCommentListener) {
        commentListeners.remove(nodeCommentListener);
    }

    public static void fireNodeCommentChanged(FlowNode flowNode, NodeComment nodeComment, NodeComment nodeComment2) {
        for (NodeCommentListener nodeCommentListener : commentListeners) {
            nodeCommentListener.nodeCommentChanged(flowNode, nodeComment, nodeComment2);
        }
    }

    public static void addNodeBreakpointChangeListener(NodeBreakpointChangeListener nodeBreakpointChangeListener) {
        breakpointListeners.add(nodeBreakpointChangeListener);
    }

    public static void removeNodeBreakpointChangeListener(NodeBreakpointChangeListener nodeBreakpointChangeListener) {
        breakpointListeners.remove(nodeBreakpointChangeListener);
    }

    public static void fireNodeBreakpointChanged(FlowNode flowNode, int n, int n2, boolean bl) {
        String string = "";
        switch (n2) {
            case 0: {
                string = "none";
                break;
            }
            case 2: {
                string = "on";
                break;
            }
            case 1: {
                string = "off";
                break;
            }
            case 3: {
                string = "changed";
            }
        }
        BREAKPOINT_CHANGED.doAction(string);
        for (NodeBreakpointChangeListener nodeBreakpointChangeListener : breakpointListeners) {
            nodeBreakpointChangeListener.nodeBreakpointChanged(flowNode, n, n2);
        }
    }

    private static class BreakpointChanged
    extends LoggableAction {
        private BreakpointChanged() {
        }

        @Override
        public void action(ActionEvent actionEvent) {
        }
    }
}

