/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.RflowEventHandler;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.google.common.hash.Hashing;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class FlowNodeUIDManager
implements RflowEventHandler {
    private static FlowNodeUIDManager instance;
    private Map<String, FlowNode> map = new HashMap<String, FlowNode>();
    private Random random = new Random();

    private FlowNodeUIDManager() {
        Rflow.getInstance().addRflowEventHandler(this);
    }

    public static FlowNodeUIDManager getInstance() {
        if (null == instance) {
            instance = new FlowNodeUIDManager();
        }
        return instance;
    }

    public String getUID(FlowNode flowNode) {
        String string = null;
        while (string == null) {
            string = this.createUID(flowNode);
            if (!this.map.containsKey(string)) {
                this.map.put(string, flowNode);
                continue;
            }
            string = null;
        }
        return string;
    }

    private String createUID(FlowNode flowNode) {
        long l = new Date().getTime();
        long l2 = this.random.nextLong();
        long l3 = Hashing.sha256().newHasher().putLong(l).putLong(l2).hash().asLong();
        return Long.toHexString(l3);
    }

    @Override
    public void rflowProjectDidStart() {
    }

    @Override
    public void rflowProjectWillEnd() {
        this.map.clear();
    }

    @Override
    public void rflowWillShutdown() {
    }
}

