/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.ViewWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.flow.FlowPropertyFileView;
import java.util.ArrayList;
import java.util.List;

public class FlowProperties
extends ValueMap {
    private static final RChoiceKey COL_PACKAGE_NAME = ((RChoiceKey.Builder)RChoiceKey.builder("name", Messages.getString("View.FlowProperties.package_name")).setCompletionSupport(RChoiceProvider.packages())).build();
    private static final BoolKey COL_ON_OPEN = ((BoolKey.Builder)BoolKey.builder("on_open", Messages.getString("View.FlowProperties.auto_load")).setDefaultValue(true)).build();
    private static final BoolKey COL_REQUIRED = ((BoolKey.Builder)BoolKey.builder("required", Messages.getString("View.FlowProperties.required")).setDefaultValue(true)).build();
    private static final RTableKey KEY_PACKAGES = ((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("packages", Messages.getString("View.FlowProperties.r_package"), COL_PACKAGE_NAME, COL_REQUIRED, COL_ON_OPEN).setUiControls(GeneralTableModel.UI_DEFAULT2)).setLabelPosition("none")).build();
    private FlowModel flowModel;

    public FlowProperties() {
        this.registerKeys(KEY_PACKAGES);
    }

    public void setFlowModel(FlowModel flowModel) {
        this.flowModel = flowModel;
    }

    public FlowModel getFlowModel() {
        return this.flowModel;
    }

    public List<RPackage> getRPackages() {
        KeysTableModel keysTableModel = this.getValue(KEY_PACKAGES);
        ArrayList<RPackage> arrayList = new ArrayList<RPackage>(keysTableModel.getRowCount());
        for (KeysTableRow keysTableRow : keysTableModel) {
            String string = keysTableRow.getValue(COL_PACKAGE_NAME);
            Boolean bl = keysTableRow.getValue(COL_REQUIRED);
            Boolean bl2 = keysTableRow.getValue(COL_ON_OPEN);
            arrayList.add(new RPackage(string, bl, bl2));
        }
        return arrayList;
    }

    @Override
    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        TabPaneWidgetNode tabPaneWidgetNode = (TabPaneWidgetNode)new TabPaneWidgetNode().add(new ViewWidgetNode(FlowPropertyFileView.class));
        return tabPaneWidgetNode.addTabWithKeys(Messages.getString("View.FlowProperties.r_package"), KEY_PACKAGES);
    }

    public void update(FlowProperties flowProperties) {
        if (!KeysTableModel.equals(this.getValue(KEY_PACKAGES), flowProperties.getValue(KEY_PACKAGES))) {
            this.putValue(KEY_PACKAGES, flowProperties.getValue(KEY_PACKAGES));
        }
    }

    @Override
    public ValueMap copy() {
        FlowProperties flowProperties = (FlowProperties)super.copy();
        flowProperties.flowModel = this.flowModel;
        return flowProperties;
    }
}

