/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.SessionEntry;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.view.ViewPosition;
import java.io.File;
import javax.swing.Icon;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FlowSessionEntry
extends SessionEntry {
    private String file;
    private String newFlow;
    private String nodeID;
    private boolean primary;
    private FlowNode node;

    public static FlowSessionEntry create(ViewPosition viewPosition, boolean bl, File file, FlowNode flowNode, Project project, boolean bl2) {
        return new FlowSessionEntry(viewPosition, bl, project.toProjectAbstractPath(file), null, flowNode, bl2);
    }

    public static FlowSessionEntry createNewFlow(ViewPosition viewPosition, boolean bl, String string, FlowNode flowNode, boolean bl2) {
        return new FlowSessionEntry(viewPosition, bl, null, string, flowNode, bl2);
    }

    public FlowSessionEntry() {
    }

    private FlowSessionEntry(ViewPosition viewPosition, boolean bl, String string, String string2, FlowNode flowNode, boolean bl2) {
        super(viewPosition, bl, FileResource.getIcon("img/doc_16.png"));
        this.file = string;
        this.node = flowNode;
        this.newFlow = string2;
        if (flowNode != null && !flowNode.isRootNode()) {
            this.nodeID = flowNode.getUid();
        }
        this.primary = bl2;
    }

    @Override
    public String getTitle() {
        if (this.node != null) {
            return this.node.getTitle();
        }
        return this.file == null ? Messages.getString("Flow.new_flow") : FilenameUtils.getName((String)this.file);
    }

    @Override
    public Icon getIcon() {
        if (this.node != null) {
            return this.node.getSmallIcon();
        }
        return super.getIcon();
    }

    @Override
    public String getType() {
        return "flow";
    }

    public boolean isNewFlow() {
        return this.newFlow != null;
    }

    public String getFile(Project project) {
        return project.toProjectAbsolutePath(this.file);
    }

    public String getNewFlow() {
        return this.newFlow;
    }

    public String getNode() {
        return this.nodeID;
    }

    public boolean isNode() {
        return this.nodeID != null && !this.nodeID.isEmpty();
    }

    public boolean isPrimary() {
        return this.primary;
    }

    @Override
    public void storeToElement(XmlContext xmlContext, Document document, Element element) {
        super.storeToElement(xmlContext, document, element);
        if (this.file != null) {
            element.setAttribute("file", this.file);
        }
        if (this.newFlow != null) {
            element.setAttribute("new", this.newFlow);
        }
        if (this.nodeID != null) {
            element.setAttribute("node", this.nodeID);
        }
        if (this.primary) {
            element.setAttribute("primary", Boolean.TRUE.toString());
        }
    }

    @Override
    public void loadElement(Element element, XmlContext xmlContext) {
        super.loadElement(element, xmlContext);
        this.file = XmlUtility.getAttribute(element, "file", null);
        this.newFlow = XmlUtility.getAttribute(element, "new", null);
        this.nodeID = XmlUtility.getAttribute(element, "node", null);
        this.primary = Boolean.valueOf(XmlUtility.getAttribute(element, "primary", Boolean.FALSE.toString()));
    }
}

